/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.util.concurrent.TimeUnit;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class CoresCreateViaPropertyIT
extends AbstractAlfrescoDistributedIT {
    static String testFolder;

    @BeforeClass
    public static void initData() throws Throwable {
        System.setProperty("create.alfresco.defaults", "alfresco,archive");
        testFolder = CoresCreateViaPropertyIT.initSolrServers(0, CoresCreateViaPropertyIT.class.getSimpleName(), null);
    }

    @AfterClass
    public static void destroyData() {
        CoresCreateViaPropertyIT.dismissSolrServers();
        System.clearProperty("create.alfresco.defaults");
    }

    @Test
    public void newCoreUsingAllDefaults() throws Exception {
        CoreContainer coreContainer = ((JettySolrRunner)jettyContainers.get(testFolder)).getCoreContainer();
        AlfrescoCoreAdminHandler coreAdminHandler = (AlfrescoCoreAdminHandler)coreContainer.getMultiCoreHandler();
        CoresCreateViaPropertyIT.assertNotNull((Object)coreAdminHandler);
        TimeUnit.SECONDS.sleep(15L);
        SolrCore defaultCore = AlfrescoSolrUtils.getCore(coreContainer, "alfresco");
        SolrCore archiveCore = AlfrescoSolrUtils.getCore(coreContainer, "archive");
        CoresCreateViaPropertyIT.assertNotNull((Object)defaultCore);
        CoresCreateViaPropertyIT.assertNotNull((Object)archiveCore);
    }
}

