/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.MLTextPropertyValue;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.carrot2.shaded.guava.common.collect.ImmutableList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DynamicCopyFieldsIT
extends AbstractAlfrescoDistributedIT {
    private static Node parentFolder;
    private static NodeMetaData parentFolderMetadata;
    private static Node node0;
    private static NodeMetaData metadataNode0;
    private static final int timeout = 100000;
    private static QName ASPECT_ALL_FIELDS_TYPE;
    private static final String MLTEXT_LOVPARTIAL = "mltextLOVPartial";
    private static final String TEXT_PATTERN_UNIQUE = "textPatternUnique";
    private static final String MLTEXT_FREE = "mltextFree";
    private static final String TEXT_LOVPARTIAL = "textLOVPartial";
    private static final String MLTEXT_PATTERN_UNIQUE = "mltextPatternUnique";
    private static final String MLTEXT_PATTERN_MANY = "mltextPatternMany";
    private static final String TEXT_LOVWHOLE = "textLOVWhole";
    private static final String MLTEXT_NONE = "mltextNone";
    private static final String TEXT_NONE = "textNone";
    private static final String TEXT_FREE = "textFree";
    private static final String MLTEXT_LOVWHOLE = "mltextLOVWhole";
    private static final String TEXT_PATTERN_MANY = "textPatternMany";
    private static Map<String, HashSet<String>> fieldMap;
    private static HashSet<QName> oldCrossLocaleProperties;
    private static HashSet<QName> oldCrossLocaleTypes;
    private static HashSet<QName> oldIdentifierProperties;

    private static QName getCustomQName(String name) {
        return QName.createQName((String)"allfieldtypes", (String)name);
    }

    @BeforeClass
    public static void initData() throws Throwable {
        DynamicCopyFieldsIT.initSolrServers(1, DynamicCopyFieldsIT.class.getSimpleName(), null);
        DynamicCopyFieldsIT.modifyAlfrescoSolrDataModel();
        DynamicCopyFieldsIT.indexNodes();
        fieldMap = DynamicCopyFieldsIT.getIndexedFieldsModifiers();
    }

    private static void modifyAlfrescoSolrDataModel() throws NoSuchFieldException, IllegalAccessException {
        Field crossLocalePropertiesField = AlfrescoSolrDataModel.getInstance().getClass().getDeclaredField("crossLocaleSearchProperties");
        crossLocalePropertiesField.setAccessible(true);
        Field crossLocaleTypesField = AlfrescoSolrDataModel.getInstance().getClass().getDeclaredField("crossLocaleSearchDataTypes");
        crossLocaleTypesField.setAccessible(true);
        Field identifierPropertiesField = AlfrescoSolrDataModel.getInstance().getClass().getDeclaredField("identifierProperties");
        identifierPropertiesField.setAccessible(true);
        HashSet crossLocaleProperties = (HashSet)crossLocalePropertiesField.get(AlfrescoSolrDataModel.getInstance());
        HashSet crossLocaleTypes = (HashSet)crossLocaleTypesField.get(AlfrescoSolrDataModel.getInstance());
        HashSet identifierProperties = (HashSet)identifierPropertiesField.get(AlfrescoSolrDataModel.getInstance());
        oldCrossLocaleProperties = (HashSet)crossLocaleProperties.clone();
        oldCrossLocaleTypes = (HashSet)crossLocaleTypes.clone();
        oldIdentifierProperties = (HashSet)identifierProperties.clone();
        crossLocaleTypes.clear();
        crossLocaleTypes.add(QName.createQName((String)"http://www.alfresco.org/model/dictionary/1.0", (String)"text"));
        crossLocaleTypes.add(QName.createQName((String)"http://www.alfresco.org/model/dictionary/1.0", (String)"content"));
        crossLocaleProperties.add(DynamicCopyFieldsIT.getCustomQName(MLTEXT_LOVPARTIAL));
        identifierProperties.add(DynamicCopyFieldsIT.getCustomQName(MLTEXT_FREE));
    }

    private static void indexNodes() throws Exception {
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, (List<Acl>)ImmutableList.of((Object)acl), (List<AclReaders>)ImmutableList.of((Object)aclReaders));
        Transaction bigTxn = AlfrescoSolrUtils.getTransaction(0, 2);
        parentFolder = AlfrescoSolrUtils.getNode(0L, bigTxn, acl, Node.SolrApiNodeStatus.UPDATED);
        parentFolderMetadata = AlfrescoSolrUtils.getNodeMetaData(parentFolder, bigTxn, acl, "elia", null, false);
        node0 = AlfrescoSolrUtils.getNode(99L, bigTxn, acl, Node.SolrApiNodeStatus.UPDATED);
        metadataNode0 = AlfrescoSolrUtils.getNodeMetaData(node0, bigTxn, acl, "elia", AlfrescoSolrUtils.ancestors(parentFolderMetadata.getNodeRef()), false);
        metadataNode0.getAspects().add(ASPECT_ALL_FIELDS_TYPE);
        metadataNode0.getProperties().put(DynamicCopyFieldsIT.getCustomQName(TEXT_PATTERN_UNIQUE), new StringPropertyValue("value"));
        metadataNode0.getProperties().put(DynamicCopyFieldsIT.getCustomQName(TEXT_LOVPARTIAL), new StringPropertyValue("value"));
        metadataNode0.getProperties().put(DynamicCopyFieldsIT.getCustomQName(TEXT_LOVWHOLE), new StringPropertyValue("value"));
        metadataNode0.getProperties().put(DynamicCopyFieldsIT.getCustomQName(TEXT_NONE), new StringPropertyValue("value"));
        metadataNode0.getProperties().put(DynamicCopyFieldsIT.getCustomQName(TEXT_FREE), new StringPropertyValue("value"));
        metadataNode0.getProperties().put(DynamicCopyFieldsIT.getCustomQName(TEXT_PATTERN_MANY), new StringPropertyValue("value"));
        metadataNode0.getProperties().put(DynamicCopyFieldsIT.getCustomQName(MLTEXT_LOVPARTIAL), new MLTextPropertyValue(Map.of(Locale.ENGLISH, "value")));
        metadataNode0.getProperties().put(DynamicCopyFieldsIT.getCustomQName(MLTEXT_FREE), new MLTextPropertyValue(Map.of(Locale.ENGLISH, "value")));
        metadataNode0.getProperties().put(DynamicCopyFieldsIT.getCustomQName(MLTEXT_PATTERN_UNIQUE), new MLTextPropertyValue(Map.of(Locale.ENGLISH, "value")));
        metadataNode0.getProperties().put(DynamicCopyFieldsIT.getCustomQName(MLTEXT_PATTERN_MANY), new MLTextPropertyValue(Map.of(Locale.ENGLISH, "value")));
        metadataNode0.getProperties().put(DynamicCopyFieldsIT.getCustomQName(MLTEXT_NONE), new MLTextPropertyValue(Map.of(Locale.ENGLISH, "value")));
        metadataNode0.getProperties().put(DynamicCopyFieldsIT.getCustomQName(MLTEXT_LOVWHOLE), new MLTextPropertyValue(Map.of(Locale.ENGLISH, "value")));
        DynamicCopyFieldsIT.indexTransaction(bigTxn, (List<Node>)ImmutableList.of((Object)parentFolder, (Object)node0), (List<NodeMetaData>)ImmutableList.of((Object)parentFolderMetadata, (Object)metadataNode0));
        DynamicCopyFieldsIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 2, 100000L);
    }

    @AfterClass
    public static void destroyData() throws NoSuchFieldException, IllegalAccessException {
        DynamicCopyFieldsIT.restoreAlfrescoSolrDataModel();
        DynamicCopyFieldsIT.dismissSolrServers();
    }

    private static void restoreAlfrescoSolrDataModel() throws NoSuchFieldException, IllegalAccessException {
        Field crossLocalePropertiesField = AlfrescoSolrDataModel.getInstance().getClass().getDeclaredField("crossLocaleSearchProperties");
        Field crossLocaleTypesField = AlfrescoSolrDataModel.getInstance().getClass().getDeclaredField("crossLocaleSearchDataTypes");
        Field identifierPropertiesField = AlfrescoSolrDataModel.getInstance().getClass().getDeclaredField("identifierProperties");
        crossLocalePropertiesField.setAccessible(true);
        crossLocaleTypesField.setAccessible(true);
        identifierPropertiesField.setAccessible(true);
        crossLocalePropertiesField.set(AlfrescoSolrDataModel.getInstance(), oldCrossLocaleProperties);
        crossLocaleTypesField.set(AlfrescoSolrDataModel.getInstance(), oldCrossLocaleTypes);
        identifierPropertiesField.set(AlfrescoSolrDataModel.getInstance(), oldIdentifierProperties);
    }

    @Test
    public void mltextLOVPartialGeneratedFieldsTest() {
        HashSet<String> fieldModifiers = fieldMap.get(MLTEXT_LOVPARTIAL);
        this.assertAllMultiValue(fieldModifiers);
        Set dynamicFieldsTypes = fieldModifiers.stream().map(this::modifierToDynamicFieldType).collect(Collectors.toSet());
        Assert.assertEquals(Set.of(DynamicFieldType.STORED, DynamicFieldType.NON_TOKENIZED_CROSS_LOCALE, DynamicFieldType.NON_TOKENIZED_LOCALE, DynamicFieldType.TOKENIZED_LOCALE, DynamicFieldType.TOKENIZED_CROSS_LOCALE, DynamicFieldType.SORT), dynamicFieldsTypes);
    }

    @Test
    public void textPatternUniqueGeneratedFieldsTest() {
        HashSet<String> fieldModifiers = fieldMap.get(TEXT_PATTERN_UNIQUE);
        this.assertAllSingleValue(fieldModifiers);
        Set dynamicFieldsTypes = fieldModifiers.stream().map(this::modifierToDynamicFieldType).collect(Collectors.toSet());
        Assert.assertEquals(Set.of(DynamicFieldType.STORED, DynamicFieldType.NON_TOKENIZED_LOCALE, DynamicFieldType.NON_TOKENIZED_CROSS_LOCALE, DynamicFieldType.SORT), dynamicFieldsTypes);
    }

    @Test
    public void mltextFreeGeneratedFieldsTest() {
        HashSet<String> fieldModifiers = fieldMap.get(MLTEXT_FREE);
        this.assertAllMultiValue(fieldModifiers);
        Set dynamicFieldsTypes = fieldModifiers.stream().map(this::modifierToDynamicFieldType).collect(Collectors.toSet());
        Assert.assertEquals(Set.of(DynamicFieldType.STORED, DynamicFieldType.NON_TOKENIZED_LOCALE, DynamicFieldType.TOKENIZED_LOCALE, DynamicFieldType.NON_TOKENIZED_CROSS_LOCALE), dynamicFieldsTypes);
    }

    @Test
    public void textLOVPartialGeneratedFieldsTest() {
        HashSet<String> fieldModifiers = fieldMap.get(TEXT_LOVPARTIAL);
        this.assertAllSingleValue(fieldModifiers);
        Set dynamicFieldsTypes = fieldModifiers.stream().map(this::modifierToDynamicFieldType).collect(Collectors.toSet());
        Assert.assertEquals(Set.of(DynamicFieldType.STORED, DynamicFieldType.NON_TOKENIZED_CROSS_LOCALE, DynamicFieldType.NON_TOKENIZED_LOCALE, DynamicFieldType.TOKENIZED_LOCALE, DynamicFieldType.TOKENIZED_CROSS_LOCALE, DynamicFieldType.DOCVALUE, DynamicFieldType.SORT), dynamicFieldsTypes);
    }

    @Test
    public void mltextPatternUniqueGeneratedFieldsTest() {
        HashSet<String> fieldModifiers = fieldMap.get(MLTEXT_PATTERN_UNIQUE);
        this.assertAllMultiValue(fieldModifiers);
        Set dynamicFieldsTypes = fieldModifiers.stream().map(this::modifierToDynamicFieldType).collect(Collectors.toSet());
        Assert.assertEquals(Set.of(DynamicFieldType.STORED, DynamicFieldType.NON_TOKENIZED_LOCALE, DynamicFieldType.SORT, DynamicFieldType.NON_TOKENIZED_CROSS_LOCALE), dynamicFieldsTypes);
    }

    @Test
    public void MLTextPatternManyGeneratedFieldsTest() {
        HashSet<String> fieldModifiers = fieldMap.get(MLTEXT_PATTERN_MANY);
        this.assertAllMultiValue(fieldModifiers);
        Set dynamicFieldsTypes = fieldModifiers.stream().map(this::modifierToDynamicFieldType).collect(Collectors.toSet());
        Assert.assertEquals(Set.of(DynamicFieldType.STORED, DynamicFieldType.NON_TOKENIZED_LOCALE, DynamicFieldType.TOKENIZED_LOCALE, DynamicFieldType.SORT, DynamicFieldType.NON_TOKENIZED_CROSS_LOCALE), dynamicFieldsTypes);
    }

    @Test
    public void textLOVWholeGeneratedFieldsTest() {
        HashSet<String> fieldModifiers = fieldMap.get(TEXT_LOVWHOLE);
        this.assertAllSingleValue(fieldModifiers);
        Set dynamicFieldsTypes = fieldModifiers.stream().map(this::modifierToDynamicFieldType).collect(Collectors.toSet());
        Assert.assertEquals(Set.of(DynamicFieldType.STORED, DynamicFieldType.NON_TOKENIZED_CROSS_LOCALE, DynamicFieldType.NON_TOKENIZED_LOCALE, DynamicFieldType.DOCVALUE, DynamicFieldType.SORT), dynamicFieldsTypes);
    }

    @Test
    public void textFreeGeneratedFieldsTest() {
        HashSet<String> fieldModifiers = fieldMap.get(TEXT_FREE);
        this.assertAllSingleValue(fieldModifiers);
        Set dynamicFieldsTypes = fieldModifiers.stream().map(this::modifierToDynamicFieldType).collect(Collectors.toSet());
        Assert.assertEquals(Set.of(DynamicFieldType.STORED, DynamicFieldType.TOKENIZED_CROSS_LOCALE, DynamicFieldType.TOKENIZED_LOCALE), dynamicFieldsTypes);
    }

    @Test
    public void mltextLOVWholeGeneratedFieldsTest() {
        HashSet<String> fieldModifiers = fieldMap.get(MLTEXT_LOVWHOLE);
        this.assertAllMultiValue(fieldModifiers);
        Set dynamicFieldsTypes = fieldModifiers.stream().map(this::modifierToDynamicFieldType).collect(Collectors.toSet());
        Assert.assertEquals(Set.of(DynamicFieldType.STORED, DynamicFieldType.NON_TOKENIZED_LOCALE, DynamicFieldType.SORT, DynamicFieldType.NON_TOKENIZED_CROSS_LOCALE), dynamicFieldsTypes);
    }

    @Test
    public void textPatternManyGeneratedFieldsTest() {
        HashSet<String> fieldModifiers = fieldMap.get(TEXT_PATTERN_MANY);
        this.assertAllSingleValue(fieldModifiers);
        Set dynamicFieldsTypes = fieldModifiers.stream().map(this::modifierToDynamicFieldType).collect(Collectors.toSet());
        Assert.assertEquals(Set.of(DynamicFieldType.STORED, DynamicFieldType.NON_TOKENIZED_CROSS_LOCALE, DynamicFieldType.NON_TOKENIZED_LOCALE, DynamicFieldType.TOKENIZED_CROSS_LOCALE, DynamicFieldType.TOKENIZED_LOCALE, DynamicFieldType.SORT), dynamicFieldsTypes);
    }

    public static Map<String, HashSet<String>> getIndexedFieldsModifiers() throws IOException, SolrServerException {
        SolrClient solrClient = DynamicCopyFieldsIT.getStandaloneClients().get(0);
        LukeRequest request = new LukeRequest();
        LukeResponse response = (LukeResponse)request.process(solrClient);
        Map<String, HashSet<String>> collect = response.getFieldInfo().keySet().stream().map(k -> k.split("@|\\{|\\}")).filter(e -> ((String[])e).length == 5).collect(Collectors.toMap(a -> a[4], a -> Sets.newHashSet((Object[])new String[]{a[1]}), (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        return collect;
    }

    private void assertAllSingleValue(Set<String> fieldModifiers) {
        Assert.assertFalse((String)"all the fields should be single value", (boolean)fieldModifiers.stream().filter(mod -> !this.isSingleValue((String)mod)).findAny().isPresent());
    }

    private void assertAllMultiValue(Set<String> fieldModifiers) {
        Assert.assertFalse((String)"all the fields should be multi value", (boolean)fieldModifiers.stream().filter(mod -> this.isSingleValue((String)mod)).findAny().isPresent());
    }

    private DynamicFieldType modifierToDynamicFieldType(String modifier) {
        if (modifier.contains("stored")) {
            return DynamicFieldType.STORED;
        }
        if (modifier.contains("sort")) {
            return DynamicFieldType.SORT;
        }
        if (modifier.charAt(1) == 'd') {
            return DynamicFieldType.DOCVALUE;
        }
        if (modifier.charAt(4) == 't') {
            if (modifier.charAt(3) == 'l') {
                return DynamicFieldType.TOKENIZED_LOCALE;
            }
            return DynamicFieldType.TOKENIZED_CROSS_LOCALE;
        }
        if (modifier.charAt(4) == '_') {
            if (modifier.charAt(3) == 'l') {
                return DynamicFieldType.NON_TOKENIZED_LOCALE;
            }
            return DynamicFieldType.NON_TOKENIZED_CROSS_LOCALE;
        }
        return DynamicFieldType.NONE;
    }

    private boolean isSingleValue(String modifier) {
        return modifier.charAt(0) == 's';
    }

    static {
        ASPECT_ALL_FIELDS_TYPE = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"allfieldtypes");
    }

    static enum DynamicFieldType {
        STORED,
        TOKENIZED_LOCALE,
        NON_TOKENIZED_LOCALE,
        TOKENIZED_CROSS_LOCALE,
        NON_TOKENIZED_CROSS_LOCALE,
        DOCVALUE,
        SORT,
        NONE;

    }
}

