/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.basics.RandomSupplier;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.apache.commons.io.FileUtils;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadLeakScope(value=ThreadLeakScope.Scope.NONE)
public abstract class SolrITInitializer
extends SolrTestCaseJ4 {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final int DEFAULT_CONNECTION_TIMEOUT1 = DEFAULT_CONNECTION_TIMEOUT;
    protected static final int CLIENT_SO_TIMEOUT = 90000;
    protected static final int INDEX_TIMEOUT = 100000;
    protected static final String JETTY_CONTEXT = "/solr";
    protected static final String SHARD_NAME_PREFIX = "shard";
    private static AtomicInteger nodeCnt;
    protected static boolean useExplicitNodeNames;
    public static Properties DEFAULT_CORE_PROPS;
    protected static Map<String, JettySolrRunner> jettyContainers;
    protected static int jettyPort;
    protected static Map<String, SolrClient> solrCollectionNameToStandaloneClient;
    protected static List<JettySolrRunner> solrShards;
    protected static List<SolrClient> clientShards;
    protected static String shards;
    protected static String[] shardsArr;
    protected static File testDir;
    protected static SolrCore defaultCore;
    protected static final String id = "id";

    @BeforeClass
    public static void setup() {
        DEFAULT_CORE_PROPS.setProperty("alfresco.commitInterval", "1000");
        DEFAULT_CORE_PROPS.setProperty("alfresco.newSearcherInterval", "2000");
        System.setProperty("alfresco.test", "true");
        System.setProperty("solr.tests.maxIndexingThreads", "10");
        System.setProperty("solr.tests.ramBufferSizeMB", "1024");
        testDir = new File(System.getProperty("user.dir") + "/target/jettys");
    }

    public static String initSolrServers(int numShards, String testClassName, Properties solrcoreProperties) throws Throwable {
        testClassName = (String)testClassName + "_" + System.currentTimeMillis();
        if (numShards > 0) {
            jettyPort = SolrITInitializer.getNextAvailablePort();
        }
        solrcoreProperties = SolrITInitializer.addExplicitShardingProperty(solrcoreProperties);
        clientShards = new ArrayList<SolrClient>();
        solrShards = new ArrayList<JettySolrRunner>();
        solrCollectionNameToStandaloneClient = new HashMap<String, SolrClient>();
        jettyContainers = new HashMap<String, JettySolrRunner>();
        nodeCnt = new AtomicInteger(0);
        String[] coreNames = new String[]{"collection1"};
        SolrITInitializer.distribSetUp((String)testClassName);
        SolrITInitializer.distribShardsSetUp(numShards);
        RandomSupplier.RandVal.uniqueValues = new HashSet<Object>();
        SolrITInitializer.createServers((String)testClassName, coreNames, numShards, solrcoreProperties);
        return testClassName;
    }

    private static Properties addExplicitShardingProperty(Properties solrcoreProperties) {
        if (solrcoreProperties == null) {
            solrcoreProperties = new Properties();
        }
        if (solrcoreProperties.getProperty("shard.method") == null) {
            solrcoreProperties.put("shard.method", "EXPLICIT_ID");
        }
        return solrcoreProperties;
    }

    public static void initSingleSolrServer(String testClassName, Properties solrcoreProperties) throws Throwable {
        SolrITInitializer.initSolrServers(0, testClassName, solrcoreProperties);
        JettySolrRunner jsr = jettyContainers.get(testClassName);
        CoreContainer coreContainer = jsr.getCoreContainer();
        AlfrescoCoreAdminHandler coreAdminHandler = (AlfrescoCoreAdminHandler)coreContainer.getMultiCoreHandler();
        SolrITInitializer.assertNotNull((Object)coreAdminHandler);
        String[] extras = null;
        if (solrcoreProperties != null && !solrcoreProperties.isEmpty()) {
            int i = 0;
            extras = new String[solrcoreProperties.size() * 2];
            for (Map.Entry<Object, Object> prop : solrcoreProperties.entrySet()) {
                extras[i++] = "property." + String.valueOf(prop.getKey());
                extras[i++] = (String)prop.getValue();
            }
        }
        defaultCore = AlfrescoSolrUtils.createCoreUsingTemplate(coreContainer, coreAdminHandler, "alfresco", "rerank", 1, 1, extras);
        SolrITInitializer.assertNotNull((Object)defaultCore);
        String url = SolrITInitializer.buildUrl(jsr.getLocalPort()) + "/alfresco";
        SolrClient standaloneClient = SolrITInitializer.createNewSolrClient(url);
        SolrITInitializer.assertNotNull((Object)standaloneClient);
        solrCollectionNameToStandaloneClient.put("alfresco", standaloneClient);
    }

    public static void dismissSolrServers() {
        try {
            SolrITInitializer.destroyServers();
            SolrITInitializer.distribTearDown();
            boolean keepTests = Boolean.parseBoolean(System.getProperty("keep.tests"));
            if (!keepTests) {
                FileUtils.deleteDirectory((File)testDir);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to shutdown test properly ", (Throwable)e);
        }
    }

    public static String getTestFilesHome() {
        return System.getProperty("user.dir") + "/target/test-classes/test-files";
    }

    public static void distribSetUp(String serverName) {
        SolrTestCaseJ4.resetExceptionIgnores();
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
        System.setProperty("solr.directoryFactory", "org.apache.solr.core.MockDirectoryFactory");
        System.setProperty("solr.log.dir", testDir.toPath().resolve(serverName).toString());
    }

    private static void distribShardsSetUp(int numShards) {
        if (numShards <= 0) {
            return;
        }
        StringBuilder shardWhitelistBuilder = new StringBuilder();
        for (int i = 0; i < numShards; ++i) {
            shardWhitelistBuilder.append("127.0.0.1:").append(jettyPort).append(JETTY_CONTEXT).append("/shard" + i).append(',');
        }
        shardWhitelistBuilder.deleteCharAt(shardWhitelistBuilder.length() - 1);
        System.setProperty("solr.shardsWhitelist", shardWhitelistBuilder.toString());
    }

    public static void distribTearDown() {
        System.clearProperty("solr.directoryFactory");
        System.clearProperty("solr.log.dir");
        System.clearProperty("solr.solr.home");
        SOLRAPIQueueClient.NODE_META_DATA_MAP.clear();
        SOLRAPIQueueClient.TRANSACTION_QUEUE.clear();
        SOLRAPIQueueClient.ACL_CHANGE_SET_QUEUE.clear();
        SOLRAPIQueueClient.ACL_READERS_MAP.clear();
        SOLRAPIQueueClient.ACL_MAP.clear();
        SOLRAPIQueueClient.NODE_MAP.clear();
    }

    protected static JettySolrRunner createJetty(String jettyKey, boolean basicAuth) throws Exception {
        if (jettyContainers.containsKey(jettyKey)) {
            return jettyContainers.get(jettyKey);
        }
        Path jettySolrHome = testDir.toPath().resolve(jettyKey);
        SolrITInitializer.seedSolrHome(jettySolrHome);
        return SolrITInitializer.createJetty(jettySolrHome.toFile(), null, null, false, jettyPort, SolrITInitializer.getSchemaFile(), basicAuth);
    }

    protected static void addCoreToJetty(String jettyKey, String sourceConfigName, String coreName, Properties additionalProperties) throws Exception {
        Path jettySolrHome = testDir.toPath().resolve(jettyKey);
        System.setProperty("solr.solr.home", jettySolrHome.toString());
        Path coreSourceConfig = new File(SolrITInitializer.getTestFilesHome() + "/" + sourceConfigName).toPath();
        Path coreHome = jettySolrHome.resolve(coreName);
        SolrITInitializer.seedCoreDir(jettyKey, coreName, coreSourceConfig, coreHome);
        SolrITInitializer.updateSolrCoreProperties(coreHome, additionalProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSolrCoreProperties(Path coreHome, Properties additionalProperties) throws IOException {
        if (additionalProperties != null) {
            InputStream in = null;
            OutputStream out = null;
            try {
                Properties properties = new Properties();
                String solrcoreProperties = coreHome.resolve("conf/solrcore.properties").toString();
                in = new FileInputStream(solrcoreProperties);
                properties.load(in);
                in.close();
                additionalProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)properties::put));
                out = new FileOutputStream(solrcoreProperties);
                properties.store(out, null);
            }
            finally {
                out.close();
                in.close();
            }
        }
    }

    protected static void start(JettySolrRunner jsr) throws Exception {
        if (!jsr.isRunning()) {
            jsr.start();
        }
    }

    protected static void createServers(String jettyKey, String[] coreNames, int numShards, Properties additionalProperties) throws Exception {
        boolean basicAuth = additionalProperties != null ? Boolean.parseBoolean(additionalProperties.getProperty("BasicAuth", "false")) : false;
        JettySolrRunner solr = SolrITInitializer.createJetty(jettyKey, basicAuth);
        jettyContainers.put(jettyKey, solr);
        Properties properties = new Properties();
        if (additionalProperties != null && additionalProperties.size() > 0) {
            properties.putAll((Map<?, ?>)additionalProperties);
            properties.remove("shard.method");
        }
        for (String coreName : coreNames) {
            SolrITInitializer.addCoreToJetty(jettyKey, coreName, coreName, properties);
        }
        shardsArr = new String[numShards];
        if (additionalProperties == null) {
            additionalProperties = new Properties();
        }
        String[] ranges = new String[]{"0-100", "100-200", "200-300", "300-400"};
        for (int i = 0; i < numShards; ++i) {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)additionalProperties);
            String shardname = SHARD_NAME_PREFIX + i;
            props.put("shard.instance", Integer.toString(i));
            props.put("shard.count", Integer.toString(numShards));
            if ("DB_ID_RANGE".equalsIgnoreCase(props.getProperty("shard.method"))) {
                props.put("shard.range", ranges[i]);
            }
            SolrITInitializer.addCoreToJetty(jettyKey, coreNames[0], shardname, props);
        }
        SolrITInitializer.start(solr);
        int jettyPort = solr.getLocalPort();
        for (String coreName : coreNames) {
            String url = SolrITInitializer.buildUrl(jettyPort) + "/" + coreName;
            LOGGER.info(url);
            solrCollectionNameToStandaloneClient.put(coreName, SolrITInitializer.createNewSolrClient(url));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numShards; ++i) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            String shardname = SHARD_NAME_PREFIX + i;
            String shardStr = SolrITInitializer.buildUrl(solr.getLocalPort()) + "/" + shardname;
            LOGGER.info(shardStr);
            SolrClient clientShard = SolrITInitializer.createNewSolrClient(shardStr);
            clientShards.add(clientShard);
            SolrITInitializer.shardsArr[i] = shardStr;
            sb.append(shardStr);
            solrShards.add(solr);
        }
        shards = sb.toString();
    }

    protected static void destroyServers() throws Exception {
        for (JettySolrRunner jetty : jettyContainers.values()) {
            jetty.stop();
        }
        for (SolrClient jClients : solrCollectionNameToStandaloneClient.values()) {
            jClients.close();
        }
        for (JettySolrRunner jetty : solrShards) {
            jetty.stop();
        }
        for (SolrClient client : clientShards) {
            client.close();
        }
        clientShards.clear();
        solrShards.clear();
        jettyContainers.clear();
        solrCollectionNameToStandaloneClient.clear();
    }

    public static JettySolrRunner createJetty(File solrHome, String dataDir, String shardList, boolean sslEnabled, int port, String schemaOverride, boolean basicAuth) {
        return SolrITInitializer.createJetty(solrHome, dataDir, shardList, sslEnabled, port, schemaOverride, useExplicitNodeNames, basicAuth);
    }

    public static JettySolrRunner createJetty(File solrHome, String dataDir, String shardList, boolean sslEnabled, int port, String schemaOverride, boolean explicitCoreNodeName, boolean basicAuth) {
        JettyConfig config;
        Properties props = new Properties();
        if (schemaOverride != null) {
            props.setProperty("schema", schemaOverride);
        }
        if (shardList != null) {
            props.setProperty("shards", shardList);
        }
        if (dataDir != null) {
            props.setProperty("solr.data.dir", dataDir);
        }
        if (explicitCoreNodeName) {
            props.setProperty("coreNodeName", Integer.toString(nodeCnt.incrementAndGet()));
        }
        SSLConfig sslConfig = new SSLConfig(sslEnabled, false, null, null, null, null);
        if (basicAuth) {
            LOGGER.info("###### adding basic auth ######");
            config = JettyConfig.builder().setContext(JETTY_CONTEXT).setPort(port).withFilter(BasicAuthFilter.class, "/sql/*").stopAtShutdown(true).withSSLConfig(sslConfig).build();
        } else {
            LOGGER.info("###### no basic auth ######");
            config = JettyConfig.builder().setContext(JETTY_CONTEXT).setPort(port).stopAtShutdown(true).withSSLConfig(sslConfig).build();
        }
        return new JettySolrRunner(solrHome.getAbsolutePath(), props, config);
    }

    public SortedMap<ServletHolder, String> getExtraServlets() {
        return null;
    }

    public SortedMap<Class<? extends Filter>, String> getExtraRequestFilters() {
        return null;
    }

    protected static SolrClient createNewSolrClient(String url) {
        try {
            HttpSolrClient client = new HttpSolrClient(url);
            client.setConnectionTimeout(DEFAULT_CONNECTION_TIMEOUT1);
            client.setSoTimeout(90000);
            client.setDefaultMaxConnectionsPerHost(100);
            client.setMaxTotalConnections(100);
            return client;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static String buildUrl(int port) {
        return SolrITInitializer.buildUrl((int)port, (String)JETTY_CONTEXT);
    }

    protected static String getSolrXml() {
        return "solr.xml";
    }

    protected static void seedSolrHome(Path jettyHome) throws IOException {
        FileUtils.copyFile((File)new File(SolrITInitializer.getTestFilesHome(), SolrITInitializer.getSolrXml()), (File)jettyHome.resolve(SolrITInitializer.getSolrXml()).toFile());
        FileUtils.copyDirectory((File)new File(SolrITInitializer.getTestFilesHome() + "/conf"), (File)jettyHome.resolve("conf").toFile());
        FileUtils.copyDirectory((File)new File(SolrITInitializer.getTestFilesHome() + "/alfrescoModels"), (File)jettyHome.resolve("alfrescoModels").toFile());
        FileUtils.copyDirectory((File)new File(SolrITInitializer.getTestFilesHome() + "/templates"), (File)jettyHome.resolve("templates").toFile());
    }

    private static void seedCoreDir(String testFolder, String coreName, Path coreSourceConfig, Path coreDirectory) throws IOException {
        Path confDir = coreDirectory.resolve("conf");
        confDir.toFile().mkdirs();
        if (Files.notExists(coreDirectory.resolve("core.properties"), new LinkOption[0])) {
            Properties coreProperties = new Properties();
            coreProperties.setProperty("name", coreName);
            SolrITInitializer.writeCoreProperties((Path)coreDirectory, (Properties)coreProperties, (String)testFolder);
        }
        FileUtils.copyDirectory((File)coreSourceConfig.resolve("conf").toFile(), (File)confDir.toFile());
    }

    static {
        DEFAULT_CORE_PROPS = new Properties();
    }

    public static class BasicAuthFilter
    implements Filter {
        public void init(FilterConfig config) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
            String auth = ((HttpServletRequest)request).getHeader("Authorization");
            if (auth != null) {
                auth = auth.replace("Basic ", "");
                byte[] bytes = Base64.getDecoder().decode(auth);
                String decodedBytes = new String(bytes);
                String[] pair = decodedBytes.split(":");
                String user = pair[0];
                String password = pair[1];
                if (user.equals("test") && password.equals("pass")) {
                    filterChain.doFilter(request, response);
                } else {
                    ((HttpServletResponse)response).sendError(403);
                }
            } else {
                ((HttpServletResponse)response).sendError(403);
            }
        }

        public void destroy() {
        }
    }
}

