/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.stream.IntStream;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.tracker.DocRouter;
import org.alfresco.solr.tracker.DocRouterFactory;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ACLIDMurmurRouterTest {
    private DocRouter router;
    @Mock
    private Acl acl;
    @Mock
    private Node node;

    @Before
    public void setUp() {
        this.router = DocRouterFactory.getRouter((Properties)new Properties(), (ShardMethodEnum)ShardMethodEnum.ACL_ID);
    }

    @Test
    public void negativeShardCount_shouldAlwaysReturnTrue() {
        int negativeShardCount = -14;
        Assert.assertTrue((boolean)this.router.routeAcl(negativeShardCount, 1, this.acl));
        Assert.assertTrue((boolean)this.router.routeNode(negativeShardCount, 1, this.node));
    }

    @Test
    public void zeroShardCount_shouldAlwaysReturnTrue() {
        int zeroShardCount = 0;
        Assert.assertTrue((boolean)this.router.routeAcl(zeroShardCount, 1, this.acl));
        Assert.assertTrue((boolean)this.router.routeNode(zeroShardCount, 1, this.node));
    }

    @Test
    public void oneShardInTheCluster_shouldAlwaysReturnTrue() {
        int zeroShardCount = 0;
        Assert.assertTrue((boolean)this.router.routeAcl(zeroShardCount, 1, this.acl));
        Assert.assertTrue((boolean)this.router.routeNode(zeroShardCount, 1, this.node));
    }

    @Test
    public void sevenShardsInTheCluster_shouldBalanceNodesAndAcls() {
        int[] shardIdentifiers = IntStream.range(0, 7).toArray();
        int shardCount = shardIdentifiers.length;
        int howManyDocumentsPerShard = 1000;
        HashMap aclDistributionMap = new HashMap();
        HashMap nodeDistributionMap = new HashMap();
        IntStream.range(0, shardCount * howManyDocumentsPerShard).mapToLong(Long::valueOf).forEach(id -> {
            Acl acl = new Acl((long)AlfrescoSolrUtils.randomPositiveInteger(), id);
            Node node = new Node();
            node.setAclId(acl.getId());
            Arrays.stream(shardIdentifiers).forEach(shardId -> {
                if (this.router.routeAcl(shardCount, shardId, acl).booleanValue()) {
                    aclDistributionMap.merge(shardId, 1, Integer::sum);
                }
                if (this.router.routeNode(shardCount, shardId, node).booleanValue()) {
                    nodeDistributionMap.merge(shardId, 1, Integer::sum);
                }
            });
        });
        StandardDeviation sd = new StandardDeviation();
        double aclsDeviation = sd.evaluate(aclDistributionMap.values().stream().mapToDouble(Number::doubleValue).toArray());
        double nodesDeviation = sd.evaluate(nodeDistributionMap.values().stream().mapToDouble(Number::doubleValue).toArray());
        Assert.assertEquals((long)shardIdentifiers.length, (long)nodeDistributionMap.size());
        Assert.assertEquals((long)shardIdentifiers.length, (long)aclDistributionMap.size());
        Assert.assertTrue((String)(aclDistributionMap.values().toString() + ", SD = " + aclsDeviation), (aclsDeviation / (double)howManyDocumentsPerShard * 100.0 < 30.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)(nodeDistributionMap.values().toString() + ", SD = " + nodesDeviation), (nodesDeviation / (double)howManyDocumentsPerShard * 100.0 < 30.0 ? 1 : 0) != 0);
    }
}

