/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.tracker.MetadataTracker;
import org.alfresco.util.CachingDateFormat;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrQuery;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public abstract class DistributedDateAbstractSolrTrackerIT
extends AbstractAlfrescoDistributedIT {
    @Test
    public void testDateMonth() throws Exception {
        DistributedDateAbstractSolrTrackerIT.putHandleDefaults();
        int numAcls = 25;
        AclChangeSet bulkAclChangeSet = AlfrescoSolrUtils.getAclChangeSet(numAcls);
        ArrayList<Acl> bulkAcls = new ArrayList<Acl>();
        ArrayList<AclReaders> bulkAclReaders = new ArrayList<AclReaders>();
        for (int i = 0; i < numAcls; ++i) {
            Acl bulkAcl = AlfrescoSolrUtils.getAcl(bulkAclChangeSet);
            bulkAcls.add(bulkAcl);
            bulkAclReaders.add(AlfrescoSolrUtils.getAclReaders(bulkAclChangeSet, bulkAcl, Collections.singletonList("joel" + bulkAcl.getId()), Collections.singletonList("phil" + bulkAcl.getId()), null));
        }
        AlfrescoSolrUtils.indexAclChangeSet(bulkAclChangeSet, bulkAcls, bulkAclReaders);
        int numNodes = 1000;
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<NodeMetaData> nodeMetaDatas = new ArrayList<NodeMetaData>();
        Transaction bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        Date[] dates = this.setupDates();
        int[] counts = new int[dates.length];
        for (int i = 0; i < numNodes; ++i) {
            int aclIndex = i % numAcls;
            int dateIndex = i % dates.length;
            String dateString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)dates[dateIndex]);
            int n = dateIndex;
            counts[n] = counts[n] + 1;
            Node node = AlfrescoSolrUtils.getNode(bigTxn, (Acl)bulkAcls.get(aclIndex), Node.SolrApiNodeStatus.UPDATED);
            node.setShardPropertyValue(dateString);
            nodes.add(node);
            NodeMetaData nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn, (Acl)bulkAcls.get(aclIndex), "mike", null, false);
            nodeMetaData.getProperties().put(ContentModel.PROP_CREATED, new StringPropertyValue(dateString));
            nodeMetaDatas.add(nodeMetaData);
        }
        DistributedDateAbstractSolrTrackerIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        DistributedDateAbstractSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), numNodes, 100000L);
        Optional shardProperty = MetadataTracker.getShardProperty((String)"created");
        DistributedDateAbstractSolrTrackerIT.assertTrue((String)"'created' field is expected to be found in data model", (boolean)shardProperty.isPresent());
        List fieldInstanceList = AlfrescoSolrDataModel.getInstance().getIndexedFieldNamesForProperty((QName)shardProperty.get()).getFields();
        AlfrescoSolrDataModel.FieldInstance fieldInstance = (AlfrescoSolrDataModel.FieldInstance)fieldInstanceList.get(0);
        String fieldName = fieldInstance.getField();
        SimpleDateFormat formatter = CachingDateFormat.getSolrDatetimeFormatWithoutMsecs();
        for (int i = 0; i < dates.length; ++i) {
            String startDate = formatter.format(dates[i]);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(dates[i]);
            ((Calendar)calendar).add(13, 1);
            String endDate = formatter.format(calendar.getTime());
            SolrQuery query = new SolrQuery("{!lucene}" + DistributedDateAbstractSolrTrackerIT.escapeQueryChars(fieldName) + ":[" + DistributedDateAbstractSolrTrackerIT.escapeQueryChars(startDate) + " TO " + DistributedDateAbstractSolrTrackerIT.escapeQueryChars(endDate) + " } ");
            DistributedDateAbstractSolrTrackerIT.assertCountAndColocation(query, counts[i]);
            this.assertCorrect(numNodes);
        }
    }

    protected Date[] setupDates() {
        return (Date[])IntStream.range(0, 12).mapToObj(index -> {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(1980, index, 21);
            return cal;
        }).map(Calendar::getTime).toArray(Date[]::new);
    }

    protected abstract void assertCorrect(int var1) throws Exception;
}

