/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.component;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.alfresco.solr.component.TempFileWarningLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class TempFileWarningLoggerTest {
    private Logger log;
    private Path path;

    @Before
    public void setUp() {
        this.path = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        this.log = (Logger)Mockito.mock(Logger.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)this.log.isWarnEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.log.isErrorEnabled()).thenReturn((Object)true);
    }

    @Test
    public void checkGlobBuiltCorrectly() {
        TempFileWarningLogger warner = new TempFileWarningLogger(this.log, "MyPrefix*", new String[]{"temp", "remove-me", "~notrequired"}, this.path);
        Assert.assertEquals((Object)"MyPrefix*.{temp,remove-me,~notrequired}", (Object)warner.getGlob());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void checkFindFiles() throws IOException {
        File f = File.createTempFile("MyPrefix", ".remove-me", this.path.toFile());
        f.deleteOnExit();
        try {
            TempFileWarningLogger warner = new TempFileWarningLogger(this.log, "MyPrefix*", new String[]{"temp", "remove-me", "~notrequired"}, this.path);
            boolean found = warner.checkFiles();
            Assert.assertTrue((String)"Should have found matching files", (boolean)found);
            ((Logger)Mockito.verify((Object)this.log, (VerificationMode)Mockito.never())).warn(ArgumentMatchers.anyString());
        }
        finally {
            f.delete();
        }
    }

    @Test
    public void checkWhenNoFilesToFind() throws IOException {
        File f = new File(this.path.toFile(), "TestFile.random");
        Assert.assertFalse((String)("Unable to perform test as file exists: " + String.valueOf(f)), (boolean)f.exists());
        TempFileWarningLogger warner = new TempFileWarningLogger(this.log, "TestFile", new String[]{"random"}, this.path);
        boolean found = warner.checkFiles();
        Assert.assertFalse((String)"Should NOT have found matching file", (boolean)found);
        ((Logger)Mockito.verify((Object)this.log, (VerificationMode)Mockito.never())).warn(ArgumentMatchers.anyString());
    }

    @Test
    public void removeManyFiles() throws IOException {
        File f = File.createTempFile("WFSTInputIterator", ".input", this.path.toFile());
        File f2 = File.createTempFile("WFSTInputIterator", ".sorted", this.path.toFile());
        f.deleteOnExit();
        f2.deleteOnExit();
        TempFileWarningLogger warner = new TempFileWarningLogger(this.log, "WFSTInputIterator*", new String[]{"input", "sorted"}, this.path);
        boolean found = warner.checkFiles();
        Assert.assertTrue((String)"Should have found matching file", (boolean)found);
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((boolean)f2.exists());
        if (found) {
            warner.removeFiles();
        }
        Assert.assertFalse((boolean)f.exists());
        Assert.assertFalse((boolean)f2.exists());
        boolean found2 = warner.checkFiles();
        Assert.assertFalse((String)"Should NOT have found a matching file", (boolean)found2);
    }

    @Test
    public void notToRemoveFilesThatDontMatch() throws IOException {
        File f = File.createTempFile("someotherfile", ".input", this.path.toFile());
        File f2 = File.createTempFile("someotherfile", ".sorted", this.path.toFile());
        f.deleteOnExit();
        f2.deleteOnExit();
        TempFileWarningLogger warner = new TempFileWarningLogger(this.log, "WFSTInputIterator*", new String[]{"input", "sorted"}, this.path);
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((boolean)f2.exists());
        warner.removeFiles();
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((boolean)f2.exists());
        boolean found2 = warner.checkFiles();
        Assert.assertFalse((String)"Should NOT have found a matching file", (boolean)found2);
    }
}

