/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class AlfrescoSolrSortIT
extends AbstractAlfrescoDistributedIT {
    @BeforeClass
    public static void initData() throws Throwable {
        AlfrescoSolrSortIT.initSolrServers(1, AlfrescoSolrSortIT.getClassName(), null);
    }

    @AfterClass
    public static void destroyData() {
        AlfrescoSolrSortIT.dismissSolrServers();
    }

    @After
    public void clearData() throws Exception {
        AlfrescoSolrSortIT.deleteByQueryAllClients("*:*");
    }

    @Test
    public void AlfrescoCollatableFieldType_emptyValuesSortingAsc__shouldBeRankedFirst() throws Exception {
        this.prepareIndexSegmentWithAllNonNullFieldValues("text@s__sort@{http://www.alfresco.org/model/content/1.0}title");
        AlfrescoSolrSortIT.putHandleDefaults();
        String[] expectedRanking = new String[]{"1", "3", "5", "6", "4", "2"};
        QueryResponse response = this.query(AlfrescoSolrSortIT.getDefaultTestClient(), true, "{\"query\":\"(id:(1 2 3 4 5 6))\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}", AlfrescoSolrSortIT.params((String[])new String[]{"qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "100", "sort", "text@s__sort@{http://www.alfresco.org/model/content/1.0}title asc"}));
        NamedList res = response.getResponse();
        SolrDocumentList searchResults = (SolrDocumentList)res.get("response");
        for (int i = 0; i < searchResults.size(); ++i) {
            AlfrescoSolrSortIT.assertThat((Object)((SolrDocument)searchResults.get(i)).get((Object)"id"), (Matcher)Is.is((Object)expectedRanking[i]));
        }
    }

    @Test
    public void AlfrescoMLCollatableFieldType_emptyValuesSortingDesc_shouldRankThemLast() throws Exception {
        this.prepareIndexSegmentWithAllNonNullFieldValues("mltext@m__sort@{http://www.alfresco.org/model/content/1.0}title");
        AlfrescoSolrSortIT.putHandleDefaults();
        String[] expectedRanking = new String[]{"2", "4", "1", "3", "5", "6"};
        QueryResponse response = this.query(AlfrescoSolrSortIT.getDefaultTestClient(), true, "{\"query\":\"(id:(1 2 3 4 5 6))\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}", AlfrescoSolrSortIT.params((String[])new String[]{"qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "100", "sort", "mltext@m__sort@{http://www.alfresco.org/model/content/1.0}title desc"}));
        NamedList res = response.getResponse();
        SolrDocumentList searchResults = (SolrDocumentList)res.get("response");
        for (int i = 0; i < searchResults.size(); ++i) {
            AlfrescoSolrSortIT.assertThat((Object)((SolrDocument)searchResults.get(i)).get((Object)"id"), (Matcher)Is.is((Object)expectedRanking[i]));
        }
    }

    private void prepareIndexSegmentWithAllNonNullFieldValues(String field) throws Exception {
        AlfrescoSolrSortIT.index(AlfrescoSolrSortIT.getDefaultTestClient(), true, "id", "1", "_version_", "0", field, "");
        AlfrescoSolrSortIT.index(AlfrescoSolrSortIT.getDefaultTestClient(), true, "id", "2", "_version_", "0", field, "B");
        AlfrescoSolrSortIT.index(AlfrescoSolrSortIT.getDefaultTestClient(), true, "id", "3", "_version_", "0", field, "");
        AlfrescoSolrSortIT.index(AlfrescoSolrSortIT.getDefaultTestClient(), true, "id", "4", "_version_", "0", field, "A");
        AlfrescoSolrSortIT.index(AlfrescoSolrSortIT.getDefaultTestClient(), true, "id", "5", "_version_", "0", field, "");
        AlfrescoSolrSortIT.index(AlfrescoSolrSortIT.getDefaultTestClient(), true, "id", "6", "_version_", "0", field, "");
        AlfrescoSolrSortIT.commit(AlfrescoSolrSortIT.getDefaultTestClient(), true);
    }
}

