/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query.afts.qparser;

import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.adaptor.QueryConstants;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.dataload.TestDataProvider;
import org.alfresco.solr.query.afts.qparser.AbstractQParserPluginIT;
import org.alfresco.util.CachingDateFormat;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class QParserPluginIT
extends AbstractQParserPluginIT
implements QueryConstants {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final long[] msecs = new long[]{333L, 20000L, 1200000L, 28800000L, 864000000L, 10368000000L, 311040000000L};

    @BeforeClass
    public static void loadData() throws Exception {
        TestDataProvider dataProvider = new TestDataProvider(h);
        dataProvider.loadTestDataset();
        FTS_TEST_DATE = dataProvider.getFtsTestDate();
        TEST_NODEREF = dataProvider.getTestNodeRef();
        TEST_ROOT_NODEREF = dataProvider.getRootNode();
    }

    @Test
    public void rootNodes() {
        this.assertAQuery("PATH:\"/\"", 1);
        this.assertAQuery("PATH:\"/.\"", 1);
    }

    @Test
    public void qNames() {
        this.assertAQuery("QNAME:\"nine\"", 1);
        this.assertAQuery("PRIMARYASSOCTYPEQNAME:\"cm:contains\"", 11);
        this.assertAQuery("PRIMARYASSOCTYPEQNAME:\"sys:children\"", 4);
        this.assertAQuery("ASSOCTYPEQNAME:\"cm:contains\"", 11);
        this.assertAQuery("ASSOCTYPEQNAME:\"sys:children\"", 5);
    }

    @Test
    public void pathsWithoutNamespace() {
        this.assertAQuery("PATH:\"/one\"", 1);
        this.assertAQuery("PATH:\"/two\"", 1);
        this.assertAQuery("PATH:\"/three\"", 1);
        this.assertAQuery("PATH:\"/four\"", 1);
    }

    @Test
    public void oneLevelPaths() {
        this.assertAQuery("PATH:\"/cm:one\"", 1);
        this.assertAQuery("PATH:\"/cm:two\"", 1);
        this.assertAQuery("PATH:\"/cm:three\"", 1);
        this.assertAQuery("PATH:\"/cm:four\"", 1);
        this.assertAQuery("PATH:\"/cm:eight-0\"", 1);
        this.assertAQuery("PATH:\"/cm:five\"", 0);
    }

    @Test
    public void twoLevelsPaths() {
        this.assertAQuery("PATH:\"/cm:one/cm:one\"", 0);
        this.assertAQuery("PATH:\"/cm:one/cm:two\"", 0);
        this.assertAQuery("PATH:\"/cm:two/cm:one\"", 0);
        this.assertAQuery("PATH:\"/cm:two/cm:two\"", 0);
        this.assertAQuery("PATH:\"/cm:one/cm:five\"", 1);
        this.assertAQuery("PATH:\"/cm:one/cm:six\"", 1);
        this.assertAQuery("PATH:\"/cm:two/cm:seven\"", 1);
        this.assertAQuery("PATH:\"/cm:one/cm:eight-1\"", 1);
        this.assertAQuery("PATH:\"/cm:two/cm:eight-2\"", 1);
        this.assertAQuery("PATH:\"/cm:one/cm:eight-2\"", 0);
        this.assertAQuery("PATH:\"/cm:two/cm:eight-1\"", 0);
        this.assertAQuery("PATH:\"/cm:two/cm:eight-0\"", 0);
        this.assertAQuery("PATH:\"/cm:one/cm:eight-0\"", 0);
    }

    @Test
    public void threeLevelsPaths() {
        this.assertAQuery("PATH:\"/cm:one/cm:five/cm:nine\"", 1);
        this.assertAQuery("PATH:\"/cm:one/cm:five/cm:ten\"", 1);
        this.assertAQuery("PATH:\"/cm:one/cm:five/cm:eleven\"", 1);
        this.assertAQuery("PATH:\"/cm:one/cm:five/cm:twelve\"", 1);
    }

    @Test
    public void fourLevelsPaths() {
        this.assertAQuery("PATH:\"/cm:one/cm:five/cm:twelve/cm:thirteen\"", 1);
        this.assertAQuery("PATH:\"/cm:one/cm:five/cm:twelve/cm:common\"", 1);
    }

    @Test
    public void fiveLevelsPaths() {
        this.assertAQuery("PATH:\"/cm:one/cm:five/cm:twelve/cm:thirteen/cm:fourteen\"", 1);
        this.assertAQuery("PATH:\"/cm:one/cm:five/cm:twelve/cm:thirteen/cm:common\"", 1);
    }

    @Test
    public void pathsWithWildcards() {
        this.assertAQuery("PATH:\"/cm:*\"", 5);
        this.assertAQuery("PATH:\"/cm:*/cm:*\"", 6);
        this.assertAQuery("PATH:\"/cm:*/cm:five\"", 1);
        this.assertAQuery("PATH:\"/cm:*/cm:*/cm:*\"", 6);
        this.assertAQuery("PATH:\"/cm:one/cm:*\"", 4);
        this.assertAQuery("PATH:\"/cm:*/cm:five/cm:*\"", 5);
        this.assertAQuery("PATH:\"/cm:one/cm:*/cm:nine\"", 1);
        this.assertAQuery("PATH:\"/*\"", 5);
        this.assertAQuery("PATH:\"/*/*\"", 6);
        this.assertAQuery("PATH:\"/*/cm:five\"", 1);
        this.assertAQuery("PATH:\"/*/*/*\"", 6);
        this.assertAQuery("PATH:\"/cm:one/*\"", 4);
        this.assertAQuery("PATH:\"/*/cm:five/*\"", 5);
        this.assertAQuery("PATH:\"/cm:one/*/cm:nine\"", 1);
    }

    @Test
    public void descendantsOrCurrentNodeExpressionInPaths() {
        this.assertAQuery("PATH:\"//.\"", 16);
        this.assertAQuery("PATH:\"//*\"", 15);
        this.assertAQuery("PATH:\"//*/.\"", 15);
        this.assertAQuery("PATH:\"//*/./.\"", 15);
        this.assertAQuery("PATH:\"//./*\"", 15);
        this.assertAQuery("PATH:\"//././*/././.\"", 15);
        this.assertAQuery("PATH:\"//cm:common\"", 1);
        this.assertAQuery("PATH:\"/one//common\"", 1);
        this.assertAQuery("PATH:\"/one/five//*\"", 7);
        this.assertAQuery("PATH:\"/one/five//.\"", 8);
        this.assertAQuery("PATH:\"/one//five/nine\"", 1);
        this.assertAQuery("PATH:\"/one//thirteen/fourteen\"", 1);
        this.assertAQuery("PATH:\"/one//thirteen/fourteen/.\"", 1);
        this.assertAQuery("PATH:\"/one//thirteen/fourteen//.\"", 1);
        this.assertAQuery("PATH:\"/one//thirteen/fourteen//.//.\"", 1);
    }

    @Test
    public void typesAndAspects() {
        this.assertAQuery("TYPE:\"" + String.valueOf(TEST_TYPE) + "\"", 1);
        this.assertAQuery("TYPE:\"" + TEST_TYPE.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 1);
        this.assertAQuery("EXACTTYPE:\"" + String.valueOf(TEST_TYPE) + "\"", 1);
        this.assertAQuery("EXACTTYPE:\"" + TEST_TYPE.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 1);
        this.assertAQuery("TYPE:\"" + String.valueOf(TEST_SUPER_TYPE) + "\"", 13);
        this.assertAQuery("TYPE:\"" + TEST_SUPER_TYPE.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 13);
        this.assertAQuery("TYPE:\"" + String.valueOf(ContentModel.TYPE_CONTENT) + "\"", 1);
        this.assertAQuery("TYPE:\"cm:content\"", 1);
        this.assertAQuery("TYPE:\"cm:content0\"", 0);
        this.assertAQuery("TYPE:\"cm:CONTENT\"", 1);
        this.assertAQuery("TYPE:\"cm:CONTENT1\"", 0);
        this.assertAQuery("TYPE:\"CM:CONTENT\"", 1);
        this.assertAQuery("TYPE:\"CM:CONTENT1\"", 0);
        this.assertAQuery("TYPE:\"CONTENT\"", 1);
        this.assertAQuery("TYPE:\"CONTENT1\"", 0);
        this.assertAQuery("TYPE:\"content\"", 1);
        this.assertAQuery("TYPE:\"content0\"", 0);
        this.assertAQuery("ASPECT:\"flubber\"", 0);
        this.assertAQuery("TYPE:\"" + ContentModel.TYPE_THUMBNAIL.toString() + "\"", 1);
        this.assertAQuery("TYPE:\"" + ContentModel.TYPE_THUMBNAIL.toString() + "\" TYPE:\"" + String.valueOf(ContentModel.TYPE_CONTENT) + "\"", 2);
        this.assertAQuery("EXACTTYPE:\"" + String.valueOf(TEST_SUPER_TYPE) + "\"", 12);
        this.assertAQuery("EXACTTYPE:\"" + TEST_SUPER_TYPE.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 12);
        this.assertAQuery("ASPECT:\"" + String.valueOf(TEST_ASPECT) + "\"", 1);
        this.assertAQuery("ASPECT:\"" + TEST_ASPECT.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 1);
        this.assertAQuery("EXACTASPECT:\"" + String.valueOf(TEST_ASPECT) + "\"", 1);
        this.assertAQuery("EXACTASPECT:\"" + TEST_ASPECT.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 1);
    }

    @Test
    public void dataTypes() {
        this.assertAQuery("d\\:double:\"5.6\"", 1);
        this.assertAQuery("d\\:int:\"1\"", 1);
        this.assertAQuery("d\\:float:\"3.4\"", 1);
        this.assertAQuery("d\\:content:\"fox\"", 1);
        this.assertAQuery("d\\:content:\"fox\"", 1, Locale.US, null, null, new String[0]);
    }

    @Test
    public void fulltext() {
        this.assertAQuery("TEXT:fox AND TYPE:\"" + String.valueOf(ContentModel.PROP_CONTENT) + "\"", 1);
        this.assertAQuery("TEXT:fox @cm\\:name:fox", 1);
        this.assertAQuery("d\\:content:fox d\\:text:fox", 1);
        this.assertAQuery("TEXT:fo AND TYPE:\"" + String.valueOf(ContentModel.PROP_CONTENT) + "\"", 0);
        this.assertAQuery("TEXT:\"fox\"", 1);
        this.assertAQuery("TEXT:\"fox\"", 0, null, new String[]{"@" + String.valueOf(ContentModel.PROP_NAME)}, null, new String[0]);
        this.assertAQuery("TEXT:\"fox\"", 1, null, new String[]{"@" + String.valueOf(ContentModel.PROP_NAME), "@" + String.valueOf(ContentModel.PROP_CONTENT)}, null, new String[0]);
        this.assertAQuery("TEXT:\"cabbage\"", 15, null, new String[]{"@" + String.valueOf(ORDER_TEXT)}, null, new String[0]);
        this.assertAQuery("TEXT:\"aeidnouy\"", 1);
        this.assertAQuery("TEXT:\"the\"", 1);
        this.assertAQuery("TEXT:\"and\"", 1);
        this.assertAQuery("TEXT:\"the lazy dog\"", 1);
        this.assertAQuery("TEXT:\"over lazy\"", 0);
        this.assertAQuery("TEXT:\"over the lazy dog\"", 1);
        this.assertAQuery("TEXT:\"over the lazy\"", 1);
        this.assertAQuery("TEXT:\"over a lazy\"", 1);
        String contentFieldName = this.escape(ContentModel.PROP_CONTENT);
        this.assertAQuery("@" + contentFieldName + ":\"fox\"", 1);
        this.assertAQuery("@" + contentFieldName + ".mimetype:\"text/plain\"", 1);
        this.assertAQuery("@" + contentFieldName + ".locale:\"en_GB\"", 1);
        this.assertAQuery("@" + contentFieldName + ".size:\"298\"", 1);
    }

    @Test
    public void wildcards() {
        String indexedStoredTokenisedAtomicFieldName = this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"text-indexed-stored-tokenised-atomic"));
        this.assertAQuery("\\@" + indexedStoredTokenisedAtomicFieldName + ":*a*", 1);
        this.assertAQuery("\\@" + indexedStoredTokenisedAtomicFieldName + ":*A*", 1);
        this.assertAQuery("\\@" + indexedStoredTokenisedAtomicFieldName + ":\"*a*\"", 1);
        this.assertAQuery("\\@" + indexedStoredTokenisedAtomicFieldName + ":\"*A*\"", 1);
        this.assertAQuery("\\@" + indexedStoredTokenisedAtomicFieldName + ":*s*", 1);
        this.assertAQuery("\\@" + indexedStoredTokenisedAtomicFieldName + ":*S*", 1);
        this.assertAQuery("\\@" + indexedStoredTokenisedAtomicFieldName + ":\"*s*\"", 1);
        this.assertAQuery("\\@" + indexedStoredTokenisedAtomicFieldName + ":\"*S*\"", 1);
        this.assertAQuery("TEXT:*A*", 1);
        this.assertAQuery("TEXT:\"*a*\"", 1);
        this.assertAQuery("TEXT:\"*A*\"", 1);
        this.assertAQuery("TEXT:*a*", 1);
        this.assertAQuery("TEXT:*Z*", 1);
        this.assertAQuery("TEXT:\"*z*\"", 1);
        this.assertAQuery("TEXT:\"*Z*\"", 1);
        this.assertAQuery("TEXT:*z*", 1);
        this.assertAQuery("TEXT:laz*", 1);
        this.assertAQuery("TEXT:laz~", 1);
        this.assertAQuery("TEXT:la?y", 1);
        this.assertAQuery("TEXT:?a?y", 1);
        this.assertAQuery("TEXT:*azy", 1);
        this.assertAQuery("TEXT:*az*", 1);
        this.assertAQuery("TEXT:\"*bage\"", 15, null, new String[]{"@" + String.valueOf(ORDER_TEXT)}, null, new String[0]);
        this.assertAQuery("TEXT:\"*ba*\"", 15, null, new String[]{"@" + String.valueOf(ORDER_TEXT)}, null, new String[0]);
        this.assertAQuery("TEXT:cabbage", 15, null, new String[]{"@" + String.valueOf(ORDER_TEXT)}, null, new String[0]);
        this.assertAQuery("TEXT:*cab*", 15, Locale.ENGLISH, new String[]{"@" + String.valueOf(ORDER_TEXT)}, null, new String[0]);
        this.assertAQuery("TEXT:*bage", 15, null, new String[]{"@" + String.valueOf(ORDER_TEXT)}, null, new String[0]);
        this.assertAQuery("TEXT:\"alfresco\"", 1);
        this.assertAQuery("TEXT:\"alfresc?\"", 1);
        this.assertAQuery("TEXT:\"alfres??\"", 1);
        this.assertAQuery("TEXT:\"alfre???\"", 1);
        this.assertAQuery("TEXT:\"alfr????\"", 1);
        this.assertAQuery("TEXT:\"alf?????\"", 1);
        this.assertAQuery("TEXT:\"al??????\"", 1);
        this.assertAQuery("TEXT:\"a???????\"", 1);
        this.assertAQuery("TEXT:\"????????\"", 2);
        this.assertAQuery("TEXT:\"a??re???\"", 1);
        this.assertAQuery("TEXT:\"?lfresco\"", 1);
        this.assertAQuery("TEXT:\"??fresco\"", 1);
        this.assertAQuery("TEXT:\"???resco\"", 1);
        this.assertAQuery("TEXT:\"????esco\"", 1);
        this.assertAQuery("TEXT:\"?????sco\"", 1);
        this.assertAQuery("TEXT:\"??????co\"", 1);
        this.assertAQuery("TEXT:\"???????o\"", 1);
        this.assertAQuery("TEXT:\"???res?o\"", 1);
        this.assertAQuery("TEXT:\"????e?co\"", 1);
        this.assertAQuery("TEXT:\"????e?c?\"", 1);
        this.assertAQuery("TEXT:\"???re???\"", 1);
        this.assertAQuery("TEXT:\"alfresc*\"", 1);
        this.assertAQuery("TEXT:\"alfres*\"", 1);
        this.assertAQuery("TEXT:\"alfre*\"", 1);
        this.assertAQuery("TEXT:\"alfr*\"", 1);
        this.assertAQuery("TEXT:\"alf*\"", 1);
        this.assertAQuery("TEXT:\"al*\"", 1);
        this.assertAQuery("TEXT:\"a*\"", 1);
        this.assertAQuery("TEXT:\"a****\"", 1);
        this.assertAQuery("TEXT:\"*lfresco\"", 1);
        this.assertAQuery("TEXT:\"*fresco\"", 1);
        this.assertAQuery("TEXT:\"*resco\"", 1);
        this.assertAQuery("TEXT:\"*esco\"", 1);
        this.assertAQuery("TEXT:\"*sco\"", 1);
        this.assertAQuery("TEXT:\"*co\"", 1);
        this.assertAQuery("TEXT:\"*o\"", 2);
        this.assertAQuery("TEXT:\"****lf**sc***\"", 1);
        this.assertAQuery("TEXT:\"??lf**sc***\"", 0);
        this.assertAQuery("TEXT:\"alfresc*tutorial\"", 0);
        this.assertAQuery("TEXT:\"alf* tut*\"", 1);
        this.assertAQuery("TEXT:\"*co *al\"", 1);
        this.assertAQuery("TEXT:\"cab*\"", 15, null, new String[]{"@" + String.valueOf(ORDER_TEXT)}, null, new String[0]);
        String descriptionFieldName = this.escape(ContentModel.PROP_DESCRIPTION);
        this.assertAQuery("@" + descriptionFieldName + ":\"alfresco\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"alfresc?\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"alfres??\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"alfre???\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"alfr????\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"alf?????\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"al??????\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"a???????\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"????????\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"a??re???\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"?lfresco\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"??fresco\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"???resco\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"????esco\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"?????sco\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"??????co\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"???????o\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"???resco\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"???res?o\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"????e?co\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"????e?c?\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"???re???\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"alfresc*\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"alfres*\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"alfre*\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"alfr*\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"alf*\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"al*\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"a*\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"a*****\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"*lfresco\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"*fresco\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"*resco\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"*esco\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"*sco\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"*co\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"*o\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"****lf**sc***\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"*??*lf**sc***\"", 0);
        this.assertAQuery("@" + descriptionFieldName + ":\"Alfresc*tutorial\"", 0);
        this.assertAQuery("@" + descriptionFieldName + ":\"Alf* tut*\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"*co *al\"", 1);
    }

    @Test
    public void accents() {
        this.assertAQuery("TEXT:\"\u00e0\u00ea\u00ee\u00f0\u00f1\u00f6\u00fb\u00ff\"", 1);
    }

    @Test
    public void mlText() {
        String contentFieldName = this.escape(ContentModel.PROP_CONTENT);
        this.assertAQuery("@" + contentFieldName + ".locale:en_*", 1);
        this.assertAQuery("@" + contentFieldName + ".locale:e*_GB", 1);
        String fieldName = this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"ml"));
        this.assertAQuery("@" + fieldName + ":and", 0);
        this.assertAQuery("@" + fieldName + ":\"and\"", 0);
        this.assertAQuery("@" + fieldName + ":banana", 1);
        this.assertAQuery("@" + fieldName + ":banana", 1, Locale.UK, null, null, new String[0]);
        this.assertAQuery("@" + fieldName + ":banana", 1, Locale.ENGLISH, null, null, new String[0]);
        this.assertAQuery("@" + fieldName + ":banane", 1, Locale.FRENCH, null, null, new String[0]);
        this.assertAQuery("@" + fieldName + ":\u9999\u8549", 1, Locale.CHINESE, null, null, new String[0]);
        this.assertAQuery("@" + fieldName + ":banaan", 1, new Locale("nl"), null, null, new String[0]);
        this.assertAQuery("@" + fieldName + ":banane", 1, Locale.GERMAN, null, null, new String[0]);
        this.assertAQuery("@" + fieldName + ":\u03bc\u03c0\u03b1\u03bd\u03ac\u03bd\u03b1", 1, new Locale("el"), null, null, new String[0]);
        this.assertAQuery("@" + fieldName + ":banana", 1, Locale.ITALIAN, null, null, new String[0]);
        this.assertAQuery("@" + fieldName + ":\u30d0\u30ca\u30ca", 1, Locale.JAPANESE, null, null, new String[0]);
        this.assertAQuery("@" + fieldName + ":\ubc14\ub098\ub098", 1, new Locale("ko"), null, null, new String[0]);
        this.assertAQuery("@" + fieldName + ":banana", 1, new Locale("pt"), null, null, new String[0]);
        this.assertAQuery("@" + fieldName + ":\u0431\u0430\u043d\u0430\u043d", 1, new Locale("ru"), null, null, new String[0]);
        this.assertAQuery("@" + fieldName + ":pl\u00e1tano", 1, new Locale("es"), null, null, new String[0]);
    }

    @Test
    public void textRanges() {
        this.assertAQuery("\\@" + this.escape(ORDER_TEXT) + ":[a TO b]", 1);
        this.assertAQuery("\\@" + this.escape(ORDER_TEXT) + ":[a TO \uffff]", 14);
        this.assertAQuery("\\@" + this.escape(ORDER_TEXT) + ":[* TO b]", 2);
        this.assertAQuery("\\@" + this.escape(ORDER_TEXT) + ":[\u0000 TO b]", 2);
        this.assertAQuery("\\@" + this.escape(ORDER_TEXT) + ":[d TO \uffff]", 12);
        this.assertAQuery("\\@" + this.escape(ORDER_TEXT) + ":[d TO *]", 12);
    }

    @Test
    public void nonFields() {
        this.assertAQuery("TEXT:fox", 1);
        this.assertAQuery("TEXT:fo*", 2);
        this.assertAQuery("TEXT:f*x", 1);
        this.assertAQuery("TEXT:*ox", 1);
        String contentFieldName = this.escape(ContentModel.PROP_CONTENT);
        this.assertAQuery("@" + contentFieldName + ":fox", 1);
        this.assertAQuery("@" + contentFieldName + ":fo*", 1);
        this.assertAQuery("@" + contentFieldName + ":f*x", 1);
        this.assertAQuery("@" + contentFieldName + ":*ox", 1);
        this.assertAQuery("@" + this.escape(ContentModel.PROP_CONTENT.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO())) + ":fox", 1);
        this.assertAQuery("@" + this.escape(ContentModel.PROP_CONTENT.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO())) + ":fo*", 1);
        this.assertAQuery("@" + this.escape(ContentModel.PROP_CONTENT.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO())) + ":f*x", 1);
        this.assertAQuery("@" + this.escape(ContentModel.PROP_CONTENT.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO())) + ":*ox", 1);
    }

    @Test
    public void nullAndUnsetFields() {
        this.assertAQuery("ISUNSET:\"" + String.valueOf(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"null")) + "\"", 0);
        this.assertAQuery("ISNULL:\"" + String.valueOf(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"null")) + "\"", 1);
        this.assertAQuery("EXISTS:\"" + String.valueOf(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"null")) + "\"", 1);
        this.assertAQuery("ISNOTNULL:\"" + String.valueOf(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"null")) + "\"", 0);
        this.assertAQuery("ISUNSET:\"" + String.valueOf(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"path-ista")) + "\"", 0);
        this.assertAQuery("ISNULL:\"" + String.valueOf(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"path-ista")) + "\"", 0);
        this.assertAQuery("ISNOTNULL:\"" + String.valueOf(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"path-ista")) + "\"", 1);
        this.assertAQuery("EXISTS:\"" + String.valueOf(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"path-ista")) + "\"", 1);
        this.assertAQuery("ISUNSET:\"" + String.valueOf(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"aspectProperty")) + "\"", 0);
        this.assertAQuery("ISNULL:\"" + String.valueOf(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"aspectProperty")) + "\"", 0);
        this.assertAQuery("ISNOTNULL:\"" + String.valueOf(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"aspectProperty")) + "\"", 1);
        this.assertAQuery("EXISTS:\"" + String.valueOf(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"aspectProperty")) + "\"", 1);
    }

    @Test
    public void intPropertyType() {
        String intFieldName = this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"int-ista"));
        this.assertAQuery("\\@" + intFieldName + ":\"1\"", 1);
        this.assertAQuery("\\@" + intFieldName + ":1", 1);
        this.assertAQuery("\\@" + intFieldName + ":\"01\"", 1);
        this.assertAQuery("\\@" + intFieldName + ":01", 1);
        this.assertAQuery("\\@" + intFieldName + ":\"001\"", 1);
        this.assertAQuery("\\@" + intFieldName + ":\"0001\"", 1);
        this.assertAQuery("\\@" + intFieldName + ":[A TO 2]", 1);
        this.assertAQuery("\\@" + intFieldName + ":[0 TO 2]", 1);
        this.assertAQuery("\\@" + intFieldName + ":[0 TO A]", 1);
        this.assertAQuery("\\@" + intFieldName + ":{A TO 1}", 0);
        this.assertAQuery("\\@" + intFieldName + ":{0 TO 1}", 0);
        this.assertAQuery("\\@" + intFieldName + ":{0 TO A}", 1);
        this.assertAQuery("\\@" + intFieldName + ":{A TO 2}", 1);
        this.assertAQuery("\\@" + intFieldName + ":{1 TO 2}", 0);
        this.assertAQuery("\\@" + intFieldName + ":{1 TO A}", 0);
    }

    @Test
    public void longPropertyType() {
        String longFieldName = this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"long-ista"));
        this.assertAQuery("\\@" + longFieldName + ":\"2\"", 1);
        this.assertAQuery("\\@" + longFieldName + ":\"02\"", 1);
        this.assertAQuery("\\@" + longFieldName + ":\"002\"", 1);
        this.assertAQuery("\\@" + longFieldName + ":\"0002\"", 1);
        this.assertAQuery("\\@" + longFieldName + ":[A TO 2]", 1);
        this.assertAQuery("\\@" + longFieldName + ":[0 TO 2]", 1);
        this.assertAQuery("\\@" + longFieldName + ":[0 TO A]", 1);
        this.assertAQuery("\\@" + longFieldName + ":{A TO 2}", 0);
        this.assertAQuery("\\@" + longFieldName + ":{0 TO 2}", 0);
        this.assertAQuery("\\@" + longFieldName + ":{0 TO A}", 1);
        this.assertAQuery("\\@" + longFieldName + ":{A TO 3}", 1);
        this.assertAQuery("\\@" + longFieldName + ":{2 TO 3}", 0);
        this.assertAQuery("\\@" + longFieldName + ":{2 TO A}", 0);
    }

    @Test
    public void floatPropertyType() {
        String floatFieldName = this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"float-ista"));
        this.assertAQuery("\\@" + floatFieldName + ":\"3.4\"", 1);
        this.assertAQuery("\\@" + floatFieldName + ":[A TO 4]", 1);
        this.assertAQuery("\\@" + floatFieldName + ":[3 TO 4]", 1);
        this.assertAQuery("\\@" + floatFieldName + ":[3 TO A]", 1);
        this.assertAQuery("\\@" + floatFieldName + ":[A TO 3.4]", 1);
        this.assertAQuery("\\@" + floatFieldName + ":[3.3 TO 3.4]", 1);
        this.assertAQuery("\\@" + floatFieldName + ":[3.3 TO A]", 1);
        this.assertAQuery("\\@" + floatFieldName + ":{A TO 3.4}", 0);
        this.assertAQuery("\\@" + floatFieldName + ":{3.3 TO 3.4}", 0);
        this.assertAQuery("\\@" + floatFieldName + ":{3.3 TO A}", 1);
        this.assertAQuery("\\@" + floatFieldName + ":\"3.40\"", 1);
        this.assertAQuery("\\@" + floatFieldName + ":\"03.4\"", 1);
        this.assertAQuery("\\@" + floatFieldName + ":\"03.40\"", 1);
    }

    @Test
    public void missingProperty() {
        this.assertAQuery("\\@" + this.escape("My-funny&MissingProperty:woof"), 0);
    }

    @Test
    public void doublePropertyType() {
        String doubleFieldName = this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"double-ista"));
        this.assertAQuery("\\@" + doubleFieldName + ":\"5.6\"", 1);
        this.assertAQuery("\\@" + doubleFieldName + ":\"05.6\"", 1);
        this.assertAQuery("\\@" + doubleFieldName + ":\"5.60\"", 1);
        this.assertAQuery("\\@" + doubleFieldName + ":\"05.60\"", 1);
        this.assertAQuery("\\@" + doubleFieldName + ":[A TO 5.7]", 1);
        this.assertAQuery("\\@" + doubleFieldName + ":[5.5 TO 5.7]", 1);
        this.assertAQuery("\\@" + doubleFieldName + ":[5.5 TO A]", 1);
        this.assertAQuery("\\@" + doubleFieldName + ":{A TO 5.6}", 0);
        this.assertAQuery("\\@" + doubleFieldName + ":{5.5 TO 5.6}", 0);
        this.assertAQuery("\\@" + doubleFieldName + ":{5.6 TO A}", 0);
    }

    @Test
    public void dateLiterals() {
        Arrays.stream(CachingDateFormat.getLenientFormatters()).filter(formatter -> formatter.getResolution() < 5).map(CachingDateFormat.SimpleDateFormatAndResolution::getSimpleDateFormat).peek(simpleDateFormat -> simpleDateFormat.setTimeZone(UTC)).map(simpleDateFormat -> simpleDateFormat.format(FTS_TEST_DATE)).filter(date -> date.length() >= 9).forEach(date -> this.assertAQuery("\\@" + this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"date-ista")) + ":\"" + date + "\"", 1));
    }

    @Test
    public void dateTimeLiterals() {
        Arrays.stream(CachingDateFormat.getLenientFormatters()).filter(formatter -> formatter.getResolution() > 5).map(formatter -> formatter.getSimpleDateFormat().format(FTS_TEST_DATE)).forEach(date -> this.assertAQuery("\\@" + this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"datetime-ista")) + ":\"" + date + "\"", 1));
    }

    @Test
    public void fieldNamesAreCaseInsensitive() {
        Date now = new Date();
        Arrays.stream(CachingDateFormat.getLenientFormatters()).filter(formatter -> formatter.getResolution() > 5).map(formatter -> formatter.getSimpleDateFormat().format(now)).forEach(date -> {
            this.assertAQuery("\\@cM\\:CrEaTeD:[MIN TO " + date + "]", 1);
            this.assertAQuery("\\@cM\\:CrEaTeD:[MIN TO " + date + "]", 1);
            this.assertAQuery("\\@CM\\:CrEaTeD:[MIN TO " + date + "]", 1);
            this.assertAQuery("\\@cm\\:created:[MIN TO NOW]", 1);
            this.assertAQuery("\\@" + this.escape(ContentModel.PROP_CREATED) + ":[MIN TO " + date + "]", 1);
        });
    }

    @Test
    public void dateRanges() {
        String fieldName = this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"date-ista"));
        Arrays.stream(CachingDateFormat.getLenientFormatters()).filter(formatter -> formatter.getResolution() > 5).map(formatter -> formatter.getSimpleDateFormat().format(FTS_TEST_DATE)).filter(date -> date.length() >= 9).forEach(date -> {
            this.assertAQuery("\\@" + fieldName + ":[" + date + " TO " + date + "]", 1);
            this.assertAQuery("\\@" + fieldName + ":[MIN  TO " + date + "]", 1);
            this.assertAQuery("\\@" + fieldName + ":[" + date + " TO MAX]", 1);
        });
    }

    @Test
    public void dateTimeRanges() {
        String fieldName = this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"datetime-ista"));
        Arrays.stream(CachingDateFormat.getLenientFormatters()).filter(formatter -> formatter.getResolution() > 5).forEach(formatter -> {
            String date = formatter.getSimpleDateFormat().format(FTS_TEST_DATE);
            Arrays.stream(this.msecs).forEach(milliseconds -> {
                String startDate = formatter.getSimpleDateFormat().format(new Date(FTS_TEST_DATE.getTime() - milliseconds));
                String endDate = formatter.getSimpleDateFormat().format(new Date(FTS_TEST_DATE.getTime() + milliseconds));
                this.assertAQuery("\\@" + fieldName + ":[" + startDate + " TO " + endDate + "]", 1);
                this.assertAQuery("\\@" + fieldName + ":[" + date + " TO " + endDate + "]", 1);
                this.assertAQuery("\\@" + fieldName + ":[" + startDate + " TO " + date + "]", 1);
                this.assertAQuery("\\@" + fieldName + ":{" + date + " TO " + endDate + "}", 0);
                this.assertAQuery("\\@" + fieldName + ":{" + startDate + " TO " + date + "}", 0);
            });
        });
    }

    @Test
    public void booleanPropertyType() {
        String booleanFieldName = this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"boolean-ista"));
        this.assertAQuery("\\@" + booleanFieldName + ":\"true\"", 1);
        this.assertAQuery("\\@" + booleanFieldName + ":\"false\"", 0);
    }

    @Test
    public void anyPropertyType() {
        String anyFieldName = this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"any-many-ista"));
        this.assertAQuery("\\@" + anyFieldName + ":\"100\"", 1);
        this.assertAQuery("\\@" + anyFieldName + ":\"anyValueAsString\"", 1);
    }

    @Test
    public void proximity() {
        this.assertAQuery("TEXT:\"Tutorial Alfresco\"~0", 0);
        this.assertAQuery("TEXT:\"Tutorial Alfresco\"~1", 0);
        this.assertAQuery("TEXT:\"Tutorial Alfresco\"~2", 1);
        this.assertAQuery("TEXT:\"Tutorial Alfresco\"~3", 1);
        String descriptionFieldName = this.escape(ContentModel.PROP_DESCRIPTION);
        this.assertAQuery("@" + descriptionFieldName + ":\"Alfresco Tutorial\"", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"Tutorial Alfresco\"", 0);
        this.assertAQuery("@" + descriptionFieldName + ":\"Tutorial Alfresco\"~0", 0);
        this.assertAQuery("@" + descriptionFieldName + ":\"Tutorial Alfresco\"~1", 0);
        this.assertAQuery("@" + descriptionFieldName + ":\"Tutorial Alfresco\"~2", 1);
        this.assertAQuery("@" + descriptionFieldName + ":\"Tutorial Alfresco\"~3", 1);
    }

    @Test
    public void mlPropertyType() {
        String mlTextFieldName = this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"mltext-many-ista"));
        this.assertAQuery("@" + mlTextFieldName + ":\u043b\u0435\u043c\u0443\u0440", 1, new Locale("ru"), null, null, new String[0]);
        this.assertAQuery("@" + mlTextFieldName + ":lemur", 1, new Locale("en"), null, null, new String[0]);
        this.assertAQuery("@" + mlTextFieldName + ":chou", 1, new Locale("fr"), null, null, new String[0]);
        this.assertAQuery("@" + mlTextFieldName + ":cabbage", 1, new Locale("en"), null, null, new String[0]);
        this.assertAQuery("@" + mlTextFieldName + ":cabba*", 1, new Locale("en"), null, null, new String[0]);
        this.assertAQuery("@" + mlTextFieldName + ":ca*ge", 1, new Locale("en"), null, null, new String[0]);
        this.assertAQuery("@" + mlTextFieldName + ":*bage", 1, new Locale("en"), null, null, new String[0]);
        this.assertAQuery("@" + mlTextFieldName + ":cabage~", 1, new Locale("en"), null, null, new String[0]);
        this.assertAQuery("@" + mlTextFieldName + ":*b?ag?", 1, new Locale("en"), null, null, new String[0]);
        this.assertAQuery("@" + mlTextFieldName + ":cho*", 1, new Locale("fr"), null, null, new String[0]);
        String localeFieldName = this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"locale-ista"));
        this.assertAQuery("@" + localeFieldName + ":\"en_GB_\"", 1);
        this.assertAQuery("@" + localeFieldName + ":en_GB_", 1);
        this.assertAQuery("@" + localeFieldName + ":en_*", 1);
        this.assertAQuery("@" + localeFieldName + ":*_GB_*", 1);
        this.assertAQuery("@" + localeFieldName + ":*_gb_*", 1);
        this.assertAQuery("@" + this.escape(QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"period-ista")) + ":\"period|12\"", 1);
    }
}

