/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.stream.IntStream;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.tracker.DocRouter;
import org.alfresco.solr.tracker.DocRouterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AclModCountRouterIT {
    private DocRouter router;
    @Mock
    private Acl acl;
    @Mock
    private Node node;

    @Before
    public void setUp() {
        this.router = DocRouterFactory.getRouter((Properties)new Properties(), (ShardMethodEnum)ShardMethodEnum.MOD_ACL_ID);
    }

    @Test
    public void negativeShardCount_shouldAlwaysReturnTrue() {
        int negativeShardCount = -14;
        Assert.assertTrue((boolean)this.router.routeAcl(negativeShardCount, 1, this.acl));
        Assert.assertTrue((boolean)this.router.routeNode(negativeShardCount, 1, this.node));
    }

    @Test
    public void zeroShardCount_shouldAlwaysReturnTrue() {
        int zeroShardCount = 0;
        Assert.assertTrue((boolean)this.router.routeAcl(zeroShardCount, 1, this.acl));
        Assert.assertTrue((boolean)this.router.routeNode(zeroShardCount, 1, this.node));
    }

    @Test
    public void oneShardInTheCluster_shouldAlwaysReturnTrue() {
        int zeroShardCount = 0;
        Assert.assertTrue((boolean)this.router.routeAcl(zeroShardCount, 1, this.acl));
        Assert.assertTrue((boolean)this.router.routeNode(zeroShardCount, 1, this.node));
    }

    @Test
    public void sevenShardsInTheCluster_shouldBalanceNodesAndAcls() {
        int[] shardIdentifiers = IntStream.range(0, 7).toArray();
        int shardCount = shardIdentifiers.length;
        int howManyDocumentsPerShard = 100;
        HashMap<Integer, Integer> aclDistributionMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> nodeDistributionMap = new HashMap<Integer, Integer>();
        IntStream.range(0, shardCount * howManyDocumentsPerShard).mapToLong(Long::valueOf).forEach(id -> {
            Mockito.when((Object)this.acl.getId()).thenReturn((Object)id);
            Mockito.when((Object)this.node.getAclId()).thenReturn((Object)id);
            Arrays.stream(shardIdentifiers).forEach(shardId -> {
                if (this.router.routeAcl(shardCount, shardId, this.acl).booleanValue()) {
                    aclDistributionMap.merge(shardId, 1, Integer::sum);
                }
                if (this.router.routeNode(shardCount, shardId, this.node).booleanValue()) {
                    nodeDistributionMap.merge(shardId, 1, Integer::sum);
                }
            });
            Mockito.reset((Object[])new Object[]{this.acl, this.node});
        });
        Assert.assertEquals((long)shardIdentifiers.length, (long)aclDistributionMap.size());
        aclDistributionMap.forEach((k, v) -> Assert.assertEquals((long)howManyDocumentsPerShard, (long)v.intValue()));
        Assert.assertEquals((long)shardIdentifiers.length, (long)nodeDistributionMap.size());
        nodeDistributionMap.forEach((k, v) -> Assert.assertEquals((long)howManyDocumentsPerShard, (long)v.intValue()));
    }
}

