/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DistributedDbidRangeAlfrescoSolrTrackerIT
extends AbstractAlfrescoDistributedIT {
    @BeforeClass
    public static void initData() throws Throwable {
        DistributedDbidRangeAlfrescoSolrTrackerIT.initSolrServers(3, DistributedDbidRangeAlfrescoSolrTrackerIT.getSimpleClassName(), DistributedDbidRangeAlfrescoSolrTrackerIT.getShardMethod());
    }

    @AfterClass
    public static void destroyData() {
        DistributedDbidRangeAlfrescoSolrTrackerIT.dismissSolrServers();
    }

    @After
    public void deleteDataFromIndex() throws Exception {
        SOLRAPIQueueClient.TRANSACTION_QUEUE.clear();
        SOLRAPIQueueClient.NODE_MAP.clear();
        DistributedDbidRangeAlfrescoSolrTrackerIT.deleteByQueryAllClients("*:*");
        DistributedDbidRangeAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 0, AlfrescoSolrUtils.MAX_WAIT_TIME);
    }

    private List<Acl> createAcls(int numAcls) {
        AclChangeSet bulkAclChangeSet = AlfrescoSolrUtils.getAclChangeSet(numAcls);
        ArrayList<Acl> bulkAcls = new ArrayList<Acl>();
        ArrayList<AclReaders> bulkAclReaders = new ArrayList<AclReaders>();
        for (int i = 0; i < numAcls; ++i) {
            Acl bulkAcl = AlfrescoSolrUtils.getAcl(bulkAclChangeSet);
            bulkAcls.add(bulkAcl);
            bulkAclReaders.add(AlfrescoSolrUtils.getAclReaders(bulkAclChangeSet, bulkAcl, Collections.singletonList("joel" + bulkAcl.getId()), Collections.singletonList("phil" + bulkAcl.getId()), null));
        }
        AlfrescoSolrUtils.indexAclChangeSet(bulkAclChangeSet, bulkAcls, bulkAclReaders);
        return bulkAcls;
    }

    @Test
    public void testDbIdRange() throws Exception {
        DistributedDbidRangeAlfrescoSolrTrackerIT.putHandleDefaults();
        int numAcls = 250;
        List<Acl> bulkAcls = this.createAcls(numAcls);
        int numNodes = 150;
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<NodeMetaData> nodeMetaDatas = new ArrayList<NodeMetaData>();
        Transaction bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        for (int i = 0; i < numNodes; ++i) {
            int aclIndex = i % numAcls;
            Node node = AlfrescoSolrUtils.getNode(i, bigTxn, bulkAcls.get(aclIndex), Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node);
            NodeMetaData nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn, bulkAcls.get(aclIndex), "mike", null, false);
            nodeMetaDatas.add(nodeMetaData);
        }
        DistributedDbidRangeAlfrescoSolrTrackerIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        DistributedDbidRangeAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), numNodes, AlfrescoSolrUtils.MAX_WAIT_TIME);
        DistributedDbidRangeAlfrescoSolrTrackerIT.waitForDocCountAllCores((Query)new TermQuery(new Term("DOC_TYPE", "Acl")), numAcls, 80000L);
        DistributedDbidRangeAlfrescoSolrTrackerIT.assertShardCount(0, (Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 100);
        DistributedDbidRangeAlfrescoSolrTrackerIT.assertShardCount(1, (Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 50);
    }

    @Test
    public void testIndexLastTransaction() throws Exception {
        List<Acl> acls = this.createAcls(1);
        int latestIndexedTransactionId = 0;
        for (int shardIndex = 0; shardIndex < 3; ++shardIndex) {
            for (int nodeNumber = 0; nodeNumber < 50; ++nodeNumber) {
                Transaction trx = AlfrescoSolrUtils.getTransaction(0, 1);
                trx.setId((long)latestIndexedTransactionId++);
                Node node = AlfrescoSolrUtils.getNode(shardIndex * 100 + 10 + nodeNumber, trx, acls.get(0), Node.SolrApiNodeStatus.UPDATED);
                DistributedDbidRangeAlfrescoSolrTrackerIT.indexTransaction(trx, List.of(node), List.of(AlfrescoSolrUtils.getNodeMetaData(node, trx, acls.get(0), "mike", null, false)));
            }
        }
        DistributedDbidRangeAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 150, AlfrescoSolrUtils.MAX_WAIT_TIME);
        DistributedDbidRangeAlfrescoSolrTrackerIT.assertShardCount(0, (Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 50);
        DistributedDbidRangeAlfrescoSolrTrackerIT.assertShardCount(1, (Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 50);
        DistributedDbidRangeAlfrescoSolrTrackerIT.assertShardCount(2, (Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 50);
        String latestIndexedTransactionIdAsString = String.valueOf(latestIndexedTransactionId - 1);
        DistributedDbidRangeAlfrescoSolrTrackerIT.assertShardCount(0, (Query)new TermQuery(new Term("S_TXID", latestIndexedTransactionIdAsString)), 1);
        DistributedDbidRangeAlfrescoSolrTrackerIT.assertShardCount(1, (Query)new TermQuery(new Term("S_TXID", latestIndexedTransactionIdAsString)), 1);
        DistributedDbidRangeAlfrescoSolrTrackerIT.assertShardCount(2, (Query)new TermQuery(new Term("S_TXID", latestIndexedTransactionIdAsString)), 1);
    }

    protected static Properties getShardMethod() {
        Properties prop = new Properties();
        prop.put("shard.method", "DB_ID_RANGE");
        return prop;
    }
}

