/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Properties;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.solr.tracker.DBIDRangeRouter;
import org.alfresco.solr.tracker.DocRouter;
import org.alfresco.solr.tracker.DocRouterFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DocRouterFactoryTest {
    @Test
    public void testDBIDRANGEWithShardRangeKey() {
        Properties mockProperties = (Properties)Mockito.mock(Properties.class);
        Mockito.when((Object)mockProperties.containsKey("shard.range")).thenReturn((Object)true);
        Mockito.when((Object)mockProperties.getProperty("shard.range")).thenReturn((Object)"100000000-150000000");
        DocRouter docRouter = DocRouterFactory.getRouter((Properties)mockProperties, (ShardMethodEnum)ShardMethodEnum.DB_ID_RANGE);
        Assert.assertTrue((String)"Expected to get a DBIDRangeRouter.", (boolean)(docRouter instanceof DBIDRangeRouter));
        DBIDRangeRouter dbidRangeRouter = (DBIDRangeRouter)docRouter;
        Assert.assertEquals((String)"Unexpected start of range.", (long)dbidRangeRouter.getStartRange(), (long)100000000L);
        Assert.assertEquals((String)"Unexpected end of range.", (long)dbidRangeRouter.getEndRange(), (long)150000000L);
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testDBIDRANGEWithoutShardRangeKey() {
        Properties mockProperties = (Properties)Mockito.mock(Properties.class);
        DocRouterFactory.getRouter((Properties)mockProperties, (ShardMethodEnum)ShardMethodEnum.DB_ID_RANGE);
    }
}

