/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jasypt.contrib.org.apache.commons.codec_1_3.binary.Base64;
import org.jasypt.encryption.StringEncryptor;

public class PublicPrivateKeyShareStringEncryptor
implements StringEncryptor {
    protected static final int DEFAULT_KEY_SIZE = 512;
    protected static final String DEFAULT_KEY_ALGORITHM = "RSA";
    protected static final String DEFAULT_ENCRYPTION_ALGORITHM = "RSA/ECB/PKCS1PADDING";
    protected static final int IV_SIZE_64 = 8;
    protected static final int IV_SIZE_128 = 16;
    private static final String CONFIG_SEPARATOR = ";";
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected SecretKey secretKey;
    public static final String KEYNAME = "alfrescoSpringKey";
    static final String PUBKEYNAME = "alfrescoSpringKey.pub";
    static final String PRIKEYNAME = "alfrescoSpringKey.pri";
    static final String SECKEYNAME = "alfrescoSpringKey.key";
    static final String KEY_PACKAGE = "/alfresco/web-extension";
    static final String PRIKEYPATH = "/alfresco/web-extension/alfrescoSpringKey.pri";
    static final String PUBKEYPATH = "/alfresco/web-extension/alfrescoSpringKey.pub";
    static final String SECKEYPATH = "/alfresco/web-extension/alfrescoSpringKey.key";
    public int keySize = 512;
    protected String keyAlgorithm = "RSA";
    protected String encryptionAlgorithm = "RSA/ECB/PKCS1PADDING";
    protected boolean legacyMode;
    protected boolean symmetricKey;
    private String keyLocation = "/alfresco/web-extension";
    private int ivSize;

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setIsSymmetricKey(boolean symmetricKey) {
        this.symmetricKey = symmetricKey;
    }

    public void setKeyLocation(String keyLocation) {
        this.keyLocation = keyLocation;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public void setIvSize(int ivSize) {
        this.ivSize = ivSize;
    }

    public void setLegacyMode(boolean legacyMode) {
        this.legacyMode = legacyMode;
    }

    void info(String msg) {
        System.out.println(msg);
    }

    public void init() {
        URL privateKeyURL = this.getClass().getResource(PRIKEYPATH);
        URL secretKeyURL = this.getClass().getResource(SECKEYPATH);
        if (privateKeyURL == null && secretKeyURL == null) {
            return;
        }
        this.setKeyLocation(this.getClass().getResource(KEY_PACKAGE).getPath());
        if (privateKeyURL == null) {
            return;
        }
        try {
            File privateKeyFile = new File(privateKeyURL.toURI());
            this.initPrivateKeyFile(privateKeyFile);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not instantiate Private Key", e);
        }
    }

    @Override
    public String encrypt(String message) {
        byte[] cipherText = new byte[]{};
        String retval = message;
        try {
            int chunkSize;
            Cipher cipher = this.getCipher(1);
            byte[] messageBytes = message.getBytes("UTF-8");
            int n = chunkSize = !this.symmetricKey ? this.getChunkSize() : messageBytes.length;
            if (messageBytes.length > chunkSize) {
                byte[] cipherChunk = new byte[]{};
                byte[] buffer = new byte[chunkSize];
                for (int i = 0; i < messageBytes.length; ++i) {
                    if (i > 0 && i % chunkSize == 0) {
                        cipherChunk = cipher.doFinal(buffer);
                        cipherText = PublicPrivateKeyShareStringEncryptor.append(cipherText, cipherChunk);
                        int newlength = chunkSize;
                        if (i + chunkSize > messageBytes.length) {
                            newlength = messageBytes.length - i;
                        }
                        buffer = new byte[newlength];
                    }
                    buffer[i % chunkSize] = messageBytes[i];
                }
                cipherChunk = cipher.doFinal(buffer);
                cipherText = PublicPrivateKeyShareStringEncryptor.append(cipherText, cipherChunk);
            } else {
                cipherText = cipher.doFinal(messageBytes);
            }
            if (this.legacyMode) {
                this.info("Legacy Mode Enabled, cipher text will not contain config preprended ");
                return new String(Base64.encodeBase64(cipherText));
            }
            retval = new String(Base64.encodeBase64(this.prependCipherConfig(cipherText, cipher.getIV())));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not encrypt value", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("Could not encrypt value", e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("Could not encrypt value", e);
        }
        return retval;
    }

    @Override
    public String decrypt(String encryptedMessage) {
        String retval = encryptedMessage;
        byte[] plainText = new byte[]{};
        try {
            byte[] decrypted;
            Cipher cipher;
            IvParameterSpec ivParams = null;
            byte[] completeMessage = Base64.decodeBase64(encryptedMessage.getBytes("UTF-8"));
            byte[] encryptedIvAndTextBytes = this.extractMessage(completeMessage);
            byte[] iv = new byte[this.ivSize];
            byte[] messageBytes = new byte[encryptedIvAndTextBytes.length - iv.length];
            if (iv.length > 0) {
                System.arraycopy(encryptedIvAndTextBytes, 0, iv, 0, iv.length);
                ivParams = new IvParameterSpec(iv);
                System.arraycopy(encryptedIvAndTextBytes, iv.length, messageBytes, 0, messageBytes.length);
            } else {
                messageBytes = encryptedIvAndTextBytes;
            }
            int chunkSize = this.keySize / 8;
            try {
                cipher = Cipher.getInstance(this.encryptionAlgorithm);
                cipher.init(2, this.symmetricKey ? this.secretKey : this.privateKey, ivParams);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new RuntimeException("Could not decrypt value", e);
            }
            if (!this.symmetricKey) {
                byte[] buffer = new byte[chunkSize];
                for (int i = 0; i < messageBytes.length; ++i) {
                    if (i > 0 && i % chunkSize == 0) {
                        byte[] cipherChunk = cipher.doFinal(buffer);
                        plainText = PublicPrivateKeyShareStringEncryptor.append(plainText, cipherChunk);
                        int newlength = chunkSize;
                        if (i + chunkSize > messageBytes.length) {
                            newlength = messageBytes.length - i;
                        }
                        buffer = new byte[newlength];
                    }
                    buffer[i % chunkSize] = messageBytes[i];
                }
                decrypted = cipher.doFinal(buffer);
            } else {
                decrypted = cipher.doFinal(messageBytes);
            }
            plainText = PublicPrivateKeyShareStringEncryptor.append(plainText, decrypted);
            retval = new String(plainText, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not encrypt value", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("Could not decrypt value", e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("Could not decrypt value", e);
        }
        return retval;
    }

    public void initPublic() {
        this.initPublic(this.keyLocation);
    }

    public void initPublic(String alfrescoSharedDir) {
        block10: {
            File publicKeyFile;
            File webExtensionDir = this.getWebExtensionDir(alfrescoSharedDir);
            if (!webExtensionDir.exists()) {
                webExtensionDir = new File(alfrescoSharedDir);
            }
            if ((publicKeyFile = new File(webExtensionDir, PUBKEYNAME)).canRead()) {
                try (ObjectInputStream is = new ObjectInputStream(new FileInputStream(publicKeyFile));){
                    this.publicKey = (PublicKey)is.readObject();
                    break block10;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not instantiate Public Key", e);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not open Public Key", e);
                }
            }
            throw new RuntimeException("Public Key File Not Found :" + publicKeyFile.getPath());
        }
    }

    public void initPrivate() {
        this.initPrivate(this.keyLocation);
    }

    public void initPrivate(String alfrescoSharedDir) {
        File privateKeyFile;
        File webExtension = this.getWebExtensionDir(alfrescoSharedDir);
        if (!webExtension.exists()) {
            webExtension = new File(alfrescoSharedDir);
        }
        if ((privateKeyFile = new File(webExtension, PRIKEYNAME)).canRead()) {
            ObjectInputStream is = null;
            try {
                is = new ObjectInputStream(new FileInputStream(privateKeyFile));
                this.privateKey = (PrivateKey)is.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not instantiate Private Key", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not find Private Key", e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new RuntimeException("BBB Private Key File Not Found :" + privateKeyFile.getPath());
    }

    public void initSecret() {
        block11: {
            File secretKeyFile;
            if (this.secretKey != null) {
                return;
            }
            File enterpriseDir = this.getWebExtensionDir(this.keyLocation);
            if (!enterpriseDir.exists()) {
                enterpriseDir = new File(this.keyLocation);
            }
            if ((secretKeyFile = new File(enterpriseDir, SECKEYNAME)).canRead()) {
                try (InputStream is = Files.newInputStream(Paths.get(secretKeyFile.getPath(), new String[0]), new OpenOption[0]);){
                    byte[] keyBytes = is.readAllBytes();
                    this.secretKey = new SecretKeySpec(keyBytes, this.keyAlgorithm);
                    break block11;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not find Secret Key", e);
                }
            }
            throw new RuntimeException("Secret Key File Not Found :" + secretKeyFile.getPath());
        }
    }

    public void createKeyFiles() {
        this.createKeyFiles(this.keyLocation);
    }

    public void createKeyFiles(String alfrescoSharedDir) {
        File sharedDir = new File(alfrescoSharedDir);
        File webExtensionDir = this.getWebExtensionDir(alfrescoSharedDir);
        if (!sharedDir.exists()) {
            throw new RuntimeException("alfresco shared dir does not exist : " + String.valueOf(sharedDir));
        }
        if (!webExtensionDir.exists()) {
            webExtensionDir = new File(alfrescoSharedDir);
            this.info("Keys will be created in folder " + alfrescoSharedDir);
        }
        File publicKeyFile = new File(webExtensionDir, PUBKEYNAME);
        File privateKeyFile = new File(webExtensionDir, PRIKEYNAME);
        this.setKeyLocation(alfrescoSharedDir);
        try {
            this.setKeyAlgorithm();
            if (this.symmetricKey) {
                File secretKeyFile = new File(webExtensionDir, SECKEYNAME);
                KeyGenerator keyGenerator = KeyGenerator.getInstance(this.keyAlgorithm);
                keyGenerator.init(this.keySize);
                SecretKey key = keyGenerator.generateKey();
                try (OutputStream fos = Files.newOutputStream(Paths.get(secretKeyFile.getPath(), new String[0]), new OpenOption[0]);){
                    fos.write(key.getEncoded());
                    this.info("secret key created file: " + secretKeyFile.getPath());
                }
                catch (IOException e) {
                    throw new RuntimeException("unable to create secret key file", e);
                }
                return;
            }
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(this.keyAlgorithm);
            keyGen.initialize(this.keySize);
            KeyPair key = keyGen.generateKeyPair();
            try (ObjectOutputStream publicKeyOS = new ObjectOutputStream(new FileOutputStream(publicKeyFile));){
                publicKeyOS.writeObject(key.getPublic());
            }
            catch (IOException e) {
                throw new RuntimeException("unable to create public key file", e);
            }
            try (ObjectOutputStream privateKeyOS = new ObjectOutputStream(new FileOutputStream(privateKeyFile));){
                privateKeyOS.writeObject(key.getPrivate());
            }
            catch (IOException e) {
                throw new RuntimeException("unable to create private key file", e);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to generate public/private key", e);
        }
    }

    public String getPasswordFromConsole() {
        String enteredPassword = null;
        String verifyPassword = null;
        boolean firstOne = true;
        do {
            if (!firstOne) {
                System.console().writer().println("Please enter the same value twice to verify your encrypted value");
                System.console().writer().flush();
            }
            firstOne = false;
            System.console().writer().print("Please Enter Value: ");
            System.console().writer().flush();
            enteredPassword = new String(System.console().readPassword());
            System.console().writer().print("Please Repeat Value: ");
            System.console().writer().flush();
            verifyPassword = new String(System.console().readPassword());
        } while (enteredPassword == null || enteredPassword.length() < 1 || !enteredPassword.equals(verifyPassword));
        return enteredPassword;
    }

    public void initConfig(String shareDir) {
        this.setKeyLocation(shareDir);
        File privateKeyFile = new File(this.getWebExtensionDir(shareDir), PRIKEYNAME);
        this.initPrivateKeyFile(privateKeyFile);
    }

    protected void setKeyAlgorithm() {
        String[] encryptionAlgorithmArray = this.encryptionAlgorithm.split("/", 3);
        if (encryptionAlgorithmArray.length != 3) {
            this.setEncryptionAlgorithm(DEFAULT_ENCRYPTION_ALGORITHM);
            this.setKeySize(512);
            this.setKeyAlgorithm();
            return;
        }
        this.setKeyAlgorithm(encryptionAlgorithmArray[0].toUpperCase(Locale.ROOT).trim());
        String mode = encryptionAlgorithmArray[1];
        switch (this.keyAlgorithm) {
            case "AES": {
                this.setIsSymmetricKey(true);
                this.setIvSize(mode.equals("ECB") ? 0 : 16);
                break;
            }
            case "DESEDE": {
                this.setIsSymmetricKey(true);
                this.setIvSize(mode.equals("ECB") ? 0 : 8);
                break;
            }
            case "RSA": {
                this.setIsSymmetricKey(false);
                this.setIvSize(0);
                break;
            }
            default: {
                throw new RuntimeException("Key algorithm not supported: " + this.keyAlgorithm);
            }
        }
    }

    private File getWebExtensionDir(String alfrescoSharedDir) {
        File sharedDir = new File(alfrescoSharedDir);
        File alfrescoDir = new File(sharedDir, "alfresco");
        File webExtensionDir = new File(alfrescoDir, "web-extension");
        return webExtensionDir;
    }

    private static byte[] append(byte[] prefix, byte[] suffix) {
        int i;
        byte[] toReturn = new byte[prefix.length + suffix.length];
        for (i = 0; i < prefix.length; ++i) {
            toReturn[i] = prefix[i];
        }
        for (i = 0; i < suffix.length; ++i) {
            toReturn[i + prefix.length] = suffix[i];
        }
        return toReturn;
    }

    private void initPrivateKeyFile(File privateKeyFile) {
        if (privateKeyFile.canRead()) {
            ObjectInputStream is = null;
            try {
                is = new ObjectInputStream(new FileInputStream(privateKeyFile));
                this.privateKey = (PrivateKey)is.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not instantiate Private Key", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not instantiate Private Key", e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException error) {
                        throw new RuntimeException("Problem while closing stream.", error);
                    }
                }
            }
        }
        throw new RuntimeException("Private Key File: " + privateKeyFile.getAbsolutePath() + " Cannot be read");
    }

    private Cipher getCipher(int mode) {
        try {
            IvParameterSpec ivParams = null;
            if (this.ivSize > 0) {
                byte[] iv = new byte[this.ivSize];
                SecureRandom random = new SecureRandom(iv);
                random.nextBytes(iv);
                ivParams = new IvParameterSpec(iv);
            }
            Cipher cipher = Cipher.getInstance(this.encryptionAlgorithm);
            cipher.init(mode, this.symmetricKey ? this.secretKey : this.publicKey, ivParams);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("Could not create cipher", e);
        }
    }

    private byte[] prependCipherConfig(byte[] cipherText, byte[] iv) {
        byte[] prepend = this.getCipherConfig();
        if (iv != null) {
            byte[] pair = new byte[prepend.length + iv.length + cipherText.length];
            ByteBuffer buffer = ByteBuffer.wrap(pair);
            buffer.put(prepend);
            buffer.put(iv);
            buffer.put(cipherText);
            return buffer.array();
        }
        byte[] pair = new byte[prepend.length + cipherText.length];
        ByteBuffer buffer = ByteBuffer.wrap(pair);
        buffer.put(prepend);
        buffer.put(cipherText);
        return buffer.array();
    }

    private byte[] getCipherConfig() {
        return this.encryptionAlgorithm.concat(CONFIG_SEPARATOR).concat(String.valueOf(this.keySize)).concat(CONFIG_SEPARATOR).getBytes();
    }

    private int extractCipherConfig(byte[] encryptedMessageByteArray) {
        String encryptedMessageString = new String(encryptedMessageByteArray);
        int messageComponents = 3;
        String[] config = encryptedMessageString.split(CONFIG_SEPARATOR, messageComponents);
        if (this.isValidConfig(config, messageComponents)) {
            String encAlg = config[0];
            int keyS = Integer.valueOf(config[1]);
            this.setEncryptionAlgorithm(encAlg);
            this.setKeySize(keyS);
            this.setKeyAlgorithm();
            this.loadPrivateKeys();
            return this.getCipherConfig().length;
        }
        this.loadPrivateKeys();
        return 0;
    }

    private boolean isValidConfig(String[] config, int messageComponents) {
        if (config.length != messageComponents) {
            return false;
        }
        try {
            Cipher.getInstance(config[0]);
            if (Integer.valueOf(config[1]) < 128) {
                return false;
            }
        }
        catch (NumberFormatException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            return false;
        }
        return true;
    }

    private byte[] extractMessage(byte[] encryptedMessageByteArray) {
        int cipherConfigPosition = this.extractCipherConfig(encryptedMessageByteArray);
        return Arrays.copyOfRange(encryptedMessageByteArray, cipherConfigPosition, encryptedMessageByteArray.length);
    }

    private void loadPrivateKeys() {
        if (this.symmetricKey) {
            this.initSecret();
            return;
        }
        this.initPrivate();
    }

    private int getChunkSize() {
        String paddingScheme = this.encryptionAlgorithm.split("/", 3)[2].toUpperCase(Locale.ROOT);
        int padding = 0;
        if (paddingScheme.endsWith("PKCS1PADDING")) {
            padding = 11;
        } else if (paddingScheme.endsWith("MD5ANDMGF1PADDING")) {
            padding = 34;
        } else if (paddingScheme.endsWith("1ANDMGF1PADDING")) {
            padding = 42;
        } else if (paddingScheme.endsWith("224ANDMGF1PADDING")) {
            padding = 58;
        } else if (paddingScheme.endsWith("256ANDMGF1PADDING")) {
            padding = 66;
        } else if (paddingScheme.endsWith("384ANDMGF1PADDING")) {
            padding = 98;
        } else if (paddingScheme.endsWith("512ANDMGF1PADDING")) {
            padding = 130;
        }
        return this.keySize / 8 - padding;
    }
}

