/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key.pbe.swing;

import de.schlichtherle.truezip.key.pbe.SafePbeParameters;
import de.schlichtherle.truezip.key.pbe.swing.AuthenticationPanel;
import de.schlichtherle.truezip.key.pbe.swing.KeyPanel;
import de.schlichtherle.truezip.key.pbe.swing.SwingSafePbeParametersView;
import de.schlichtherle.truezip.key.pbe.swing.WeakKeyException;
import de.schlichtherle.truezip.swing.EnhancedPanel;
import de.schlichtherle.truezip.swing.PanelEvent;
import de.schlichtherle.truezip.swing.PanelListener;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.zip.Deflater;
import javax.annotation.CheckForNull;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class WriteKeyPanel
extends KeyPanel {
    private static final long serialVersionUID = 6416529465492387235L;
    private static final String CLASS_NAME = WriteKeyPanel.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private static final int MIN_PASSWD_LEN = 8;
    private final Color defaultForeground;
    private JComponent extraDataUI;
    private AuthenticationPanel authenticationPanel;
    private JLabel error;
    private JPasswordField newPasswd1Field;
    private JLabel newPasswd1Label;
    private JPasswordField newPasswd2Field;
    private JLabel newPasswd2Label;
    private EnhancedPanel passwdPanel;
    private JTextPane resource;

    public WriteKeyPanel() {
        this.initComponents();
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                WriteKeyPanel.this.setError(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                WriteKeyPanel.this.setError(null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                WriteKeyPanel.this.setError(null);
            }
        };
        this.newPasswd1Field.getDocument().addDocumentListener(dl);
        this.newPasswd2Field.getDocument().addDocumentListener(dl);
        this.authenticationPanel.getKeyFileDocument().addDocumentListener(dl);
        this.defaultForeground = this.resource.getForeground();
    }

    @Override
    public URI getResource() {
        return URI.create(this.resource.getText());
    }

    @Override
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void setResource(URI resource) {
        URI lastResource = SwingSafePbeParametersView.lastResource;
        if (!lastResource.equals(resource) && !lastResource.equals(SwingSafePbeParametersView.INITIAL_RESOURCE)) {
            this.resource.setForeground(Color.RED);
        } else {
            this.resource.setForeground(this.defaultForeground);
        }
        this.resource.setText(resource.toString());
        SwingSafePbeParametersView.lastResource = resource;
    }

    @Override
    public String getError() {
        String error = this.error.getText();
        return error.trim().length() > 0 ? error : null;
    }

    @Override
    public void setError(String error) {
        this.error.setText(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    boolean updateParam(SafePbeParameters<?, ?> param) {
        try {
            switch (this.authenticationPanel.getAuthenticationMethod()) {
                case 0: {
                    char[] newPasswd1 = this.newPasswd1Field.getPassword();
                    char[] newPasswd2 = this.newPasswd2Field.getPassword();
                    try {
                        if (Arrays.equals(newPasswd1, newPasswd2)) {
                            this.checkPasswdKey(newPasswd1);
                            this.setError(null);
                            param.setPassword(newPasswd1);
                            boolean bl = true;
                            return bl;
                        }
                        this.setError(resources.getString("passwd.noMatch"));
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        Arrays.fill(newPasswd1, '\u0000');
                        Arrays.fill(newPasswd2, '\u0000');
                    }
                }
                case 1: {
                    byte[] key;
                    File keyFile = this.authenticationPanel.getKeyFile();
                    if (keyFile.canWrite()) {
                        this.setError(resources.getString("keyFile.canWrite"));
                        return false;
                    }
                    try {
                        key = SwingSafePbeParametersView.readKeyFile(keyFile);
                    }
                    catch (EOFException ex) {
                        this.setError(resources.getString("keyFile.eofException"));
                        return false;
                    }
                    catch (FileNotFoundException ex) {
                        this.setError(resources.getString("keyFile.fileNotFoundException"));
                        return false;
                    }
                    catch (IOException ex) {
                        this.setError(resources.getString("keyFile.ioException"));
                        return false;
                    }
                    this.checkKeyFileKey(key);
                    this.setError(null);
                    param.setKeyFileBytes(key);
                    Arrays.fill(key, (byte)0);
                    return true;
                }
            }
            throw new AssertionError((Object)"Unsupported authentication method!");
        }
        catch (WeakKeyException failure) {
            this.setError(failure.getLocalizedMessage());
            return false;
        }
    }

    protected void checkKeyFileKey(byte[] key) throws WeakKeyException {
        Deflater def = new Deflater();
        def.setInput(key);
        def.finish();
        assert (def.getTotalOut() == 0);
        int n = def.deflate(new byte[key.length * 2]);
        assert (def.getTotalOut() == n);
        def.end();
        if (n < 64) {
            throw new WeakKeyException(WriteKeyPanel.localizedMessage(resources, "keyFile.badEntropy", null));
        }
    }

    protected void checkPasswdKey(char[] key) throws WeakKeyException {
        if (8 > key.length) {
            throw new WeakKeyException(WriteKeyPanel.localizedMessage(resources, "passwd.tooShort", 8));
        }
    }

    private static String localizedMessage(ResourceBundle resources, String key, @CheckForNull Object param) {
        return param != null ? MessageFormat.format(resources.getString(key), param) : resources.getString(key);
    }

    public JComponent getExtraDataUI() {
        return this.extraDataUI;
    }

    public void setExtraDataUI(JComponent extraDataUI) {
        if (this.extraDataUI == extraDataUI) {
            return;
        }
        if (this.extraDataUI != null) {
            this.remove(this.extraDataUI);
        }
        if (extraDataUI != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            this.add((Component)extraDataUI, gridBagConstraints);
        }
        this.extraDataUI = extraDataUI;
        this.revalidate();
    }

    private void initComponents() {
        this.passwdPanel = new EnhancedPanel();
        this.newPasswd1Label = new JLabel();
        this.newPasswd1Field = new JPasswordField();
        this.newPasswd2Label = new JLabel();
        this.newPasswd2Field = new JPasswordField();
        JLabel prompt = new JLabel();
        this.resource = new JTextPane();
        this.authenticationPanel = new AuthenticationPanel();
        this.error = new JLabel();
        this.passwdPanel.addPanelListener(new PanelListener(){

            @Override
            public void ancestorWindowShown(PanelEvent evt) {
                WriteKeyPanel.this.passwdPanelAncestorWindowShown(evt);
            }

            @Override
            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        this.passwdPanel.setLayout(new GridBagLayout());
        this.newPasswd1Label.setDisplayedMnemonic(resources.getString("newPasswd1").charAt(0));
        this.newPasswd1Label.setLabelFor(this.newPasswd1Field);
        this.newPasswd1Label.setText(resources.getString("newPasswd1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.passwdPanel.add((Component)this.newPasswd1Label, gridBagConstraints);
        this.newPasswd1Field.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.passwdPanel.add((Component)this.newPasswd1Field, gridBagConstraints);
        this.newPasswd2Label.setDisplayedMnemonic(resources.getString("newPasswd2").charAt(0));
        this.newPasswd2Label.setLabelFor(this.newPasswd2Field);
        this.newPasswd2Label.setText(resources.getString("newPasswd2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.passwdPanel.add((Component)this.newPasswd2Label, gridBagConstraints);
        this.newPasswd2Field.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.passwdPanel.add((Component)this.newPasswd2Field, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        prompt.setLabelFor(this.resource);
        prompt.setText(resources.getString("prompt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)prompt, gridBagConstraints);
        this.resource.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.resource.setEditable(false);
        this.resource.setFont(this.resource.getFont().deriveFont(this.resource.getFont().getStyle() | 1));
        this.resource.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.resource, gridBagConstraints);
        this.authenticationPanel.setPasswdPanel(this.passwdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.authenticationPanel, gridBagConstraints);
        this.error.setForeground(new Color(255, 0, 0));
        this.error.setName("error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.error, gridBagConstraints);
    }

    private void passwdPanelAncestorWindowShown(PanelEvent evt) {
        final Window window = evt.getSource().getAncestorWindow();
        window.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (WriteKeyPanel.this.newPasswd1Field.requestFocusInWindow()) {
                            WriteKeyPanel.this.newPasswd1Field.selectAll();
                            WriteKeyPanel.this.newPasswd2Field.selectAll();
                        }
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
    }
}

