/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryptor;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import junit.framework.TestCase;
import org.alfresco.encryptor.PublicPrivateKeyShareStringEncryptor;
import org.jasypt.contrib.org.apache.commons.codec_1_3.binary.Base64;
import org.junit.Before;
import org.junit.Test;

public class PublicPrivateKeyShareStringEncryptorTest
extends TestCase {
    private static String PATH = null;

    @Before
    public void setUp() throws Exception {
        ClassLoader cl = PublicPrivateKeyShareStringEncryptorTest.class.getClassLoader();
        URL uri = cl.getResource("keystore");
        PATH = uri.getPath();
    }

    public void tearDown() throws Exception {
        File dir = new File(PATH);
        for (File file : dir.listFiles()) {
            if (!file.getName().startsWith("alfrescoSpringKey")) continue;
            file.delete();
        }
    }

    @Test
    public void testOne() throws Exception {
        PublicPrivateKeyShareStringEncryptor encryptor = new PublicPrivateKeyShareStringEncryptor();
        encryptor.createKeyFiles(PATH);
        encryptor.init();
        encryptor.initPublic(PATH);
        encryptor.initPrivate(PATH);
        String message = "qwerty123";
        String encrypted = encryptor.encrypt(message);
        String decrypted = encryptor.decrypt(encrypted);
        PublicPrivateKeyShareStringEncryptorTest.assertEquals((String)message, (String)decrypted);
    }

    @Test
    public void testVeryLongStrings() throws Exception {
        PublicPrivateKeyShareStringEncryptor encryptor = new PublicPrivateKeyShareStringEncryptor();
        encryptor.createKeyFiles(PATH);
        encryptor.init();
        encryptor.initPublic(PATH);
        encryptor.initPrivate(PATH);
        String message = "a horribly long string, considerably longer than can be encrypted by RSA in one chunk";
        PublicPrivateKeyShareStringEncryptorTest.assertTrue((String)"test not valid, test message too small", (message.length() > 60 ? 1 : 0) != 0);
        String encrypted = encryptor.encrypt(message);
        String decrypted = encryptor.decrypt(encrypted);
        PublicPrivateKeyShareStringEncryptorTest.assertEquals((String)message, (String)decrypted);
    }

    @Test
    public void testMultiplesOf53() throws Exception {
        PublicPrivateKeyShareStringEncryptor encryptor = new PublicPrivateKeyShareStringEncryptor();
        encryptor.createKeyFiles(PATH);
        encryptor.init();
        encryptor.initPublic(PATH);
        encryptor.initPrivate(PATH);
        String message = "12345678901234567890123456789012345678901234567890123";
        PublicPrivateKeyShareStringEncryptorTest.assertEquals((String)"test not valid, test message not 53 bytes", (int)message.length(), (int)53);
        String encrypted = encryptor.encrypt(message);
        String decrypted = encryptor.decrypt(encrypted);
        PublicPrivateKeyShareStringEncryptorTest.assertEquals((String)message, (String)decrypted);
        String message2 = message + message;
        PublicPrivateKeyShareStringEncryptorTest.assertEquals((String)"test not valid, test message not 106 bytes", (int)message2.length(), (int)106);
        encrypted = encryptor.encrypt(message2);
        decrypted = encryptor.decrypt(encrypted);
        PublicPrivateKeyShareStringEncryptorTest.assertEquals((String)message2, (String)decrypted);
    }

    @Test
    public void testLegacyMode() throws UnsupportedEncodingException {
        PublicPrivateKeyShareStringEncryptor encryptor = this.setupAsyncKeyEncryptor();
        encryptor.setLegacyMode(true);
        this.assertEncryptionForMultipleStrings(encryptor);
    }

    @Test
    public void testLegacyModeWithSeparator() throws UnsupportedEncodingException {
        PublicPrivateKeyShareStringEncryptor encryptor = this.setupAsyncKeyEncryptor();
        encryptor.setLegacyMode(true);
        this.assertEncryptionForString(encryptor, "this;is;notAPasswordWithConfig");
        this.assertEncryptionForString(encryptor, "this;1024;notAPasswordWithConfig");
    }

    @Test
    public void testDefaultMode() throws UnsupportedEncodingException {
        PublicPrivateKeyShareStringEncryptor encryptor = this.setupAsyncKeyEncryptor();
        this.assertEncryptionForMultipleStrings(encryptor);
    }

    @Test
    public void testRSA() throws UnsupportedEncodingException {
        this.assertEncryptionForMultipleAsyncKeySizes("RSA/ECB/PKCS1Padding", 512, 1024, 2048);
        this.assertEncryptionForMultipleAsyncKeySizes("RSA/ECB/OAEPWithMD5AndMGF1Padding", 512, 1024, 2048);
        this.assertEncryptionForMultipleAsyncKeySizes("RSA/ECB/OAEPWithSHA-224AndMGF1Padding", 1024, 2048);
        this.assertEncryptionForMultipleAsyncKeySizes("RSA/ECB/OAEPWithSHA-256AndMGF1Padding", 1024, 2048);
        this.assertEncryptionForMultipleAsyncKeySizes("RSA/ECB/OAEPWithSHA-384AndMGF1Padding", 1024, 2048);
        this.assertEncryptionForMultipleAsyncKeySizes("RSA/ECB/OAEPWithSHA-512AndMGF1Padding", 2048);
    }

    @Test
    public void testAES() throws UnsupportedEncodingException {
        this.assertEncryptionForMultipleSyncKeySizes("AES/CBC/PKCS5Padding", 128, 192, 256);
        this.assertEncryptionForMultipleSyncKeySizes("AES/ECB/PKCS5Padding", 128, 192, 256);
    }

    @Test
    public void testDESede() throws UnsupportedEncodingException {
        this.assertEncryptionForMultipleSyncKeySizes("DESede/CBC/PKCS5Padding", 168);
        this.assertEncryptionForMultipleSyncKeySizes("DESede/ECB/PKCS5Padding ", 168);
    }

    private void assertEncryptionForMultipleAsyncKeySizes(String encryptionAlgorithm, int ... keySizes) throws UnsupportedEncodingException {
        for (int keySize : keySizes) {
            PublicPrivateKeyShareStringEncryptor encryptor = this.setupAsyncKeyEncryptor(encryptionAlgorithm, keySize);
            this.assertEncryptionForMultipleStrings(encryptor);
        }
    }

    private void assertEncryptionForMultipleSyncKeySizes(String encryptionAlgorithm, int ... keySizes) throws UnsupportedEncodingException {
        for (int keySize : keySizes) {
            PublicPrivateKeyShareStringEncryptor encryptor = this.setupSyncKeyEncryptor(encryptionAlgorithm, keySize);
            this.assertEncryptionForMultipleStrings(encryptor);
        }
    }

    private PublicPrivateKeyShareStringEncryptor setupAsyncKeyEncryptor() {
        return this.setupAsyncKeyEncryptor(null, 0);
    }

    private PublicPrivateKeyShareStringEncryptor setupAsyncKeyEncryptor(String encryptionAlgorithm, int keySize) {
        PublicPrivateKeyShareStringEncryptor encryptor = new PublicPrivateKeyShareStringEncryptor();
        if (encryptionAlgorithm != null) {
            encryptor.setEncryptionAlgorithm(encryptionAlgorithm);
        }
        if (keySize > 0) {
            encryptor.setKeySize(keySize);
        }
        encryptor.setKeyLocation(PATH);
        encryptor.createKeyFiles();
        encryptor.initPublic();
        encryptor.initPrivate();
        return encryptor;
    }

    private PublicPrivateKeyShareStringEncryptor setupSyncKeyEncryptor(String encryptionAlgorithm, int keySize) {
        PublicPrivateKeyShareStringEncryptor encryptor = new PublicPrivateKeyShareStringEncryptor();
        if (encryptionAlgorithm != null) {
            encryptor.setEncryptionAlgorithm(encryptionAlgorithm);
        }
        if (keySize > 0) {
            encryptor.setKeySize(keySize);
        }
        encryptor.setKeyLocation(PATH);
        encryptor.createKeyFiles();
        encryptor.initSecret();
        return encryptor;
    }

    private void assertEncryptionForMultipleStrings(PublicPrivateKeyShareStringEncryptor encryptor) throws UnsupportedEncodingException {
        this.assertEncryptionForString(encryptor, this.generateString(15));
        this.assertEncryptionForString(encryptor, this.generateString(53));
        this.assertEncryptionForString(encryptor, this.generateString(150));
        this.assertEncryptionForString(encryptor, this.generateString(250));
    }

    private void assertEncryptionForString(PublicPrivateKeyShareStringEncryptor encryptor, String text) throws UnsupportedEncodingException {
        String encrypted = encryptor.encrypt(text);
        int encryptedLength = this.getEncriptedLength(encrypted);
        PublicPrivateKeyShareStringEncryptorTest.assertTrue((encryptedLength >= encryptor.keySize / 8 ? 1 : 0) != 0);
        PublicPrivateKeyShareStringEncryptor dencryptor = new PublicPrivateKeyShareStringEncryptor();
        dencryptor.setKeyLocation(PATH);
        String decrypted = dencryptor.decrypt(encrypted);
        PublicPrivateKeyShareStringEncryptorTest.assertEquals((String)text, (String)decrypted);
    }

    private int getEncriptedLength(String encryptedMessage) throws UnsupportedEncodingException {
        byte[] message = Base64.decodeBase64((byte[])encryptedMessage.getBytes(StandardCharsets.UTF_8));
        return message.length;
    }

    private String generateString(int length) {
        byte[] array = new byte[length];
        new Random().nextBytes(array);
        return new String(array, StandardCharsets.UTF_8);
    }
}

