/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.slingshot.web.scripts;

import java.io.IOException;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.content.ContentGet;
import org.alfresco.service.cmr.activities.ActivityPoster;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.sync.repo.Client;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class SlingshotContentGet
extends ContentGet {
    protected SiteService siteService;
    private ActivityPoster poster;
    private RetryingTransactionHelper transactionHelper;

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setPoster(ActivityPoster poster) {
        this.poster = poster;
    }

    public void setTransactionHelper(RetryingTransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        if (Boolean.valueOf(req.getParameter("a")).booleanValue()) {
            Map templateVars = req.getServiceMatch().getTemplateVars();
            String storeType = (String)templateVars.get("store_type");
            String storeId = (String)templateVars.get("store_id");
            String nodeId = (String)templateVars.get("id");
            if (storeType != null && storeId != null && nodeId != null) {
                String nodeIdTmp = nodeId;
                if (nodeId.contains("/")) {
                    nodeIdTmp = nodeId.substring(0, nodeId.indexOf(47));
                }
                final NodeRef nodeRef = new NodeRef(storeType, storeId, nodeIdTmp);
                SiteInfo site = null;
                try {
                    site = this.siteService.getSite(nodeRef);
                }
                catch (AccessDeniedException accessDeniedException) {
                    // empty catch block
                }
                if (site != null) {
                    String filename = (String)templateVars.get("filename");
                    if (filename == null || filename.length() == 0) {
                        filename = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                        if (nodeId.contains("/")) {
                            filename = nodeId.substring(nodeId.lastIndexOf("/") + 1);
                        }
                    }
                    final String strFilename = filename;
                    final String siteName = site.getShortName();
                    this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        public Void execute() throws Throwable {
                            SlingshotContentGet.this.poster.postFileFolderActivity("org.alfresco.documentlibrary.file-downloaded", null, null, siteName, null, nodeRef, strFilename, "documentlibrary", Client.asType((Client.ClientType)Client.ClientType.webclient), null);
                            return null;
                        }
                    }, false, true);
                }
            }
        }
        super.execute(req, res);
    }
}

