/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.datalist;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.alfresco.model.ContentModel;
import org.alfresco.model.DataListModel;
import org.alfresco.repo.web.scripts.DeclarativeSpreadsheetWebScript;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.Pair;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class DataListDownloadWebScript
extends DeclarativeSpreadsheetWebScript
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(DataListDownloadWebScript.class);
    private static final QName DATA_LIST_ITEM_TYPE = DataListModel.PROP_DATALIST_ITEM_TYPE;
    private NodeService nodeService;
    private SiteService siteService;
    private NamespaceService namespaceService;
    private Map<QName, List<QName>> modelOrder;
    private Map<String, String> rawModelOrder;

    public DataListDownloadWebScript() {
        this.filenameBase = "DataListExport";
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setModelOrder(Map<String, String> rawModelOrder) {
        this.rawModelOrder = rawModelOrder;
    }

    public void afterPropertiesSet() throws Exception {
        this.modelOrder = new HashMap<QName, List<QName>>();
        for (String key : this.rawModelOrder.keySet()) {
            QName model;
            ArrayList<QName> order = new ArrayList<QName>();
            try {
                model = QName.createQName((String)key, (NamespacePrefixResolver)this.namespaceService);
            }
            catch (InvalidQNameException e) {
                logger.warn((Object)("Skipping invalid model type " + key));
                continue;
            }
            StringTokenizer st = new StringTokenizer(this.rawModelOrder.get(key), ",");
            while (st.hasMoreTokens()) {
                order.add(QName.createQName((String)st.nextToken(), (NamespacePrefixResolver)this.namespaceService));
            }
            this.modelOrder.put(model, order);
        }
    }

    protected Object identifyResource(String format, WebScriptRequest req) {
        NodeRef list;
        Map args = req.getServiceMatch().getTemplateVars();
        if (args.get("store_type") != null) {
            list = new NodeRef((String)args.get("store_type"), (String)args.get("store_id"), (String)args.get("id"));
        } else {
            SiteInfo site = this.siteService.getSite((String)args.get("site"));
            if (site == null) {
                throw new WebScriptException(404, "Site not found with supplied name");
            }
            NodeRef container = this.nodeService.getChildByName(site.getNodeRef(), ContentModel.ASSOC_CONTAINS, (String)args.get("container"));
            if (container == null) {
                throw new WebScriptException(404, "Container not found within site");
            }
            list = this.nodeService.getChildByName(container, ContentModel.ASSOC_CONTAINS, (String)args.get("list"));
        }
        if (list == null || !this.nodeService.exists(list)) {
            throw new WebScriptException(404, "The Data List could not be found");
        }
        return list;
    }

    protected boolean allowHtmlFallback() {
        return false;
    }

    protected List<Pair<QName, Boolean>> buildPropertiesForHeader(Object resource, String format, WebScriptRequest req) {
        List<QName> props;
        NodeRef list = (NodeRef)resource;
        QName type = this.buildType(list);
        if (this.modelOrder.containsKey(type)) {
            props = this.modelOrder.get(type);
        } else {
            TypeDefinition typeDef = this.dictionaryService.getType(type);
            Map allProps = typeDef.getProperties();
            props = new ArrayList<QName>();
            for (QName prop : allProps.keySet()) {
                if (!"http://www.alfresco.org/model/datalist/1.0".equals(prop.getNamespaceURI())) continue;
                props.add(prop);
            }
        }
        ArrayList<Pair<QName, Boolean>> properties = new ArrayList<Pair<QName, Boolean>>();
        for (QName qname : props) {
            properties.add((Pair<QName, Boolean>)new Pair((Object)qname, (Object)true));
        }
        return properties;
    }

    private QName buildType(NodeRef list) {
        String typeS = (String)((Object)this.nodeService.getProperty(list, DATA_LIST_ITEM_TYPE));
        if (!typeS.startsWith("dl:")) {
            throw new WebScriptException(501, "Unexpected list type " + typeS);
        }
        QName type = QName.createQName((String)"http://www.alfresco.org/model/datalist/1.0", (String)typeS.substring(typeS.indexOf(58) + 1));
        return type;
    }

    private List<NodeRef> getItems(NodeRef list) {
        HashSet<QName> typeSet = new HashSet<QName>(Arrays.asList(this.buildType(list)));
        ArrayList<NodeRef> items = new ArrayList<NodeRef>();
        for (ChildAssociationRef ca : this.nodeService.getChildAssocs(list, typeSet)) {
            items.add(ca.getChildRef());
        }
        return items;
    }

    protected void populateBody(Object resource, CSVPrinter csv, List<QName> properties) throws IOException {
        throw new WebScriptException(400, "CSV not currently supported");
    }

    protected void populateBody(Object resource, Workbook workbook, Sheet sheet, List<QName> properties) throws IOException {
        NodeRef list = (NodeRef)resource;
        List<NodeRef> items = this.getItems(list);
        DataFormat formatter = workbook.createDataFormat();
        CellStyle styleInt = workbook.createCellStyle();
        styleInt.setDataFormat(formatter.getFormat("0"));
        CellStyle styleDate = workbook.createCellStyle();
        styleDate.setDataFormat(formatter.getFormat("yyyy-mm-dd"));
        CellStyle styleDouble = workbook.createCellStyle();
        styleDouble.setDataFormat(formatter.getFormat("General"));
        CellStyle styleNewLines = workbook.createCellStyle();
        styleNewLines.setWrapText(true);
        int rowNum = 1;
        int colNum = 0;
        for (NodeRef item : items) {
            Row r = sheet.createRow(rowNum);
            colNum = 0;
            for (QName prop : properties) {
                Cell c = r.createCell(colNum);
                Serializable val = this.nodeService.getProperty(item, prop);
                if (val == null) {
                    List assocs = this.nodeService.getTargetAssocs(item, (QNamePattern)prop);
                    if (assocs.size() > 0) {
                        StringBuffer text = new StringBuffer();
                        int lines = 1;
                        for (AssociationRef ref : assocs) {
                            NodeRef child = ref.getTargetRef();
                            QName type = this.nodeService.getType(child);
                            if (ContentModel.TYPE_PERSON.equals((Object)type)) {
                                if (text.length() > 0) {
                                    text.append('\n');
                                    ++lines;
                                }
                                text.append(this.nodeService.getProperty(child, ContentModel.PROP_USERNAME));
                                continue;
                            }
                            if (ContentModel.TYPE_CONTENT.equals((Object)type)) {
                                if (text.length() > 0) {
                                    text.append('\n');
                                    ++lines;
                                }
                                text.append(this.nodeService.getProperty(child, ContentModel.PROP_TITLE));
                                continue;
                            }
                            System.err.println("TODO: handle " + String.valueOf(type) + " for " + String.valueOf(child));
                        }
                        String v = text.toString();
                        c.setCellValue(v);
                        if (lines > 1) {
                            c.setCellStyle(styleNewLines);
                            r.setHeightInPoints((float)lines * sheet.getDefaultRowHeightInPoints());
                        }
                    } else {
                        c.setCellType(CellType.BLANK);
                    }
                } else if (val instanceof String) {
                    c.setCellValue((String)((Object)val));
                } else if (val instanceof Date) {
                    c.setCellValue((Date)val);
                    c.setCellStyle(styleDate);
                } else if (val instanceof Integer || val instanceof Long) {
                    double v = 0.0;
                    if (val instanceof Long) {
                        v = ((Long)val).longValue();
                    }
                    if (val instanceof Integer) {
                        v = ((Integer)val).intValue();
                    }
                    c.setCellValue(v);
                    c.setCellStyle(styleInt);
                } else if (val instanceof Float || val instanceof Double) {
                    double v = 0.0;
                    if (val instanceof Float) {
                        v = ((Float)val).floatValue();
                    }
                    if (val instanceof Double) {
                        v = (Double)val;
                    }
                    c.setCellValue(v);
                    c.setCellStyle(styleDouble);
                } else {
                    System.err.println("TODO: handle " + val.getClass().getName() + " - " + String.valueOf(val));
                }
                ++colNum;
            }
            ++rowNum;
        }
        colNum = 0;
        for (QName prop : properties) {
            sheet.autoSizeColumn(colNum);
            ++colNum;
        }
    }
}

