/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.wiki;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.web.scripts.wiki.AbstractWikiWebScript;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.wiki.WikiPageInfo;
import org.apache.commons.lang3.StringEscapeUtils;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class WikiPageGet
extends AbstractWikiWebScript {
    private static final String MSG_NOT_FOUND = "page-not-found";
    private static final Pattern LINK_PATTERN = Pattern.compile("\\[\\[([^\\|#\\]]+)");

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String pageTitle, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        String strMinWikiData = req.getParameter("minWikiData");
        boolean minWikiData = strMinWikiData != null ? Boolean.parseBoolean(strMinWikiData) : false;
        ResourceBundle rb = this.getResources();
        HashMap<String, Object> model = new HashMap<String, Object>();
        WikiPageInfo page = this.wikiService.getWikiPage(site.getShortName(), pageTitle);
        if (page == null) {
            String message = "The Wiki Page could not be found";
            status.setCode(404);
            status.setMessage(message);
            status.setRedirect(true);
            model.put("container", site.getNodeRef());
            model.put("error", rb.getString(MSG_NOT_FOUND));
            return model;
        }
        ArrayList<String> links = new ArrayList<String>();
        ArrayList<String> pageTitles = new ArrayList<String>();
        if (page.getContents() != null) {
            Matcher m = LINK_PATTERN.matcher(page.getContents());
            while (m.find()) {
                String link = m.group(1);
                if (links.contains(link)) continue;
                links.add(link);
                WikiPageInfo wikiPage = this.wikiService.getWikiPage(site.getShortName(), StringEscapeUtils.unescapeHtml4((String)link));
                if (wikiPage == null) continue;
                pageTitles.add(wikiPage.getTitle());
            }
        }
        model.put("page", page);
        model.put("node", page.getNodeRef());
        model.put("container", page.getContainerNodeRef());
        model.put("links", links);
        model.put("pageList", pageTitles);
        model.put("tags", page.getTags());
        model.put("siteId", site.getShortName());
        model.put("site", site);
        model.put("minWikiData", minWikiData);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", model);
        return result;
    }
}

