/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.alfresco.solr.client.AclChangeSet;

public class AclChangeSets {
    private final List<AclChangeSet> aclChangeSets;
    private Long maxChangeSetCommitTime;
    private Long maxChangeSetId;

    public AclChangeSets(List<AclChangeSet> aclChangeSets, Long maxChangeSetCommitTime, Long maxChangeSetId) {
        this.aclChangeSets = aclChangeSets == null ? null : new ArrayList<AclChangeSet>(aclChangeSets);
        this.maxChangeSetCommitTime = maxChangeSetCommitTime;
        this.maxChangeSetId = maxChangeSetId;
    }

    public AclChangeSets(List<AclChangeSet> aclChangeSets) {
        this.aclChangeSets = aclChangeSets;
        if (!aclChangeSets.isEmpty()) {
            this.maxChangeSetCommitTime = aclChangeSets.stream().max(Comparator.comparing(AclChangeSet::getCommitTimeMs)).get().getCommitTimeMs();
            this.maxChangeSetId = aclChangeSets.stream().max(Comparator.comparing(AclChangeSet::getId)).get().getId();
        }
    }

    public List<AclChangeSet> getAclChangeSets() {
        return Collections.unmodifiableList(this.aclChangeSets);
    }

    public Long getMaxChangeSetCommitTime() {
        return this.maxChangeSetCommitTime;
    }

    public Long getMaxChangeSetId() {
        return this.maxChangeSetId;
    }
}

