/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.client;

import java.util.Comparator;
import java.util.List;
import org.alfresco.solr.client.Transaction;

public class Transactions {
    private List<Transaction> transactions;
    private Long maxTxnCommitTime;
    private Long maxTxnId;

    public Transactions(List<Transaction> transactions, Long maxTxnCommitTime, Long maxTxnId) {
        this.transactions = transactions;
        this.maxTxnCommitTime = maxTxnCommitTime;
        this.maxTxnId = maxTxnId;
    }

    public Transactions(List<Transaction> transactions) {
        this.transactions = transactions;
        if (!transactions.isEmpty()) {
            this.maxTxnCommitTime = transactions.stream().max(Comparator.comparing(Transaction::getCommitTimeMs)).get().getCommitTimeMs();
            this.maxTxnId = transactions.stream().max(Comparator.comparing(Transaction::getId)).get().getId();
        }
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public Long getMaxTxnCommitTime() {
        return this.maxTxnCommitTime;
    }

    public Long getMaxTxnId() {
        return this.maxTxnId;
    }
}

