/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.imagemagick;

import java.io.File;
import java.util.Map;
import org.alfresco.transform.imagemagick.transformers.ImageMagickCommandExecutor;
import org.alfresco.transform.imagemagick.transformers.ImageMagickCommandOptions;
import org.alfresco.transform.imagemagick.transformers.ImageMagickTransformer;
import org.alfresco.transform.imagemagick.transformers.page.PageRangeFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ImageMagickTransformerTest {
    private ImageMagickCommandExecutor imageMagickCommandExecutor;
    private ImageMagickCommandOptions imageMagickCommandOptions;
    private ImageMagickTransformer imageMagickTransformer;

    @BeforeEach
    void setUp() {
        this.imageMagickCommandExecutor = (ImageMagickCommandExecutor)Mockito.mock(ImageMagickCommandExecutor.class);
        PageRangeFactory pageRangeFactory = (PageRangeFactory)Mockito.mock(PageRangeFactory.class);
        this.imageMagickCommandOptions = (ImageMagickCommandOptions)Mockito.mock(ImageMagickCommandOptions.class);
        this.imageMagickTransformer = new ImageMagickTransformer(this.imageMagickCommandExecutor, pageRangeFactory, this.imageMagickCommandOptions);
    }

    @Test
    void shouldNotAllowArgumentInjectionThroughCommandOptionsWhenDisabled() {
        Mockito.when((Object)this.imageMagickCommandOptions.isCommandOptionsEnabled()).thenReturn((Object)false);
        Map<String, String> transformOptions = Map.of("commandOptions", "( horrible command / );");
        this.imageMagickTransformer.transform(null, null, transformOptions, null, null, null);
        ArgumentCaptor optionsCaptor = ArgumentCaptor.forClass(String.class);
        ((ImageMagickCommandExecutor)Mockito.verify((Object)this.imageMagickCommandExecutor)).run((String)optionsCaptor.capture(), (File)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Long)ArgumentMatchers.any());
        Assertions.assertThat((String)((String)optionsCaptor.getValue())).doesNotContain(new CharSequence[]{"horrible", "horrible command", "( horrible command / );"});
    }

    @Test
    void shouldAllowArgumentInjectionThroughCommandOptionsWhenEnabled() {
        Mockito.when((Object)this.imageMagickCommandOptions.isCommandOptionsEnabled()).thenReturn((Object)true);
        Map<String, String> transformOptions = Map.of("commandOptions", "( horrible command / );");
        this.imageMagickTransformer.transform(null, null, transformOptions, null, null, null);
        ArgumentCaptor optionsCaptor = ArgumentCaptor.forClass(String.class);
        ((ImageMagickCommandExecutor)Mockito.verify((Object)this.imageMagickCommandExecutor)).run((String)optionsCaptor.capture(), (File)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Long)ArgumentMatchers.any());
        Assertions.assertThat((String)((String)optionsCaptor.getValue())).contains(new CharSequence[]{"horrible", "horrible command", "( horrible command / );"});
    }
}

