/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.libreoffice.transformers;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XRefreshable;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.artofsolving.jodconverter.office.OfficeContext;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeTask;
import org.artofsolving.jodconverter.office.OfficeUtils;

@Deprecated
public class LibreOfficeExtractMetadataTask
implements OfficeTask {
    private static final String KEY_AUTHOR = "author";
    private static final String KEY_TITLE = "title";
    private static final String KEY_DESCRIPTION = "description";
    private File inputFile;
    private Map<String, Serializable> metadata = new HashMap();

    public LibreOfficeExtractMetadataTask(File inputFile) {
        this.inputFile = inputFile;
    }

    public Map<String, Serializable> getMetadata() {
        return this.metadata;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(OfficeContext context) {
        XComponent document = null;
        try {
            if (!this.inputFile.exists()) {
                throw new OfficeException("input document not found");
            }
            XComponentLoader loader = (XComponentLoader)OfficeUtils.cast(XComponentLoader.class, (Object)context.getService("com.sun.star.frame.Desktop"));
            PropertyValue hiddenOOo = new PropertyValue();
            hiddenOOo.Name = "Hidden";
            hiddenOOo.Value = Boolean.TRUE;
            PropertyValue readOnly = new PropertyValue();
            readOnly.Name = "ReadOnly";
            readOnly.Value = Boolean.TRUE;
            try {
                document = loader.loadComponentFromURL(OfficeUtils.toUrl((File)this.inputFile), "_blank", 0, new PropertyValue[]{hiddenOOo, readOnly});
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OfficeException("could not load document: " + this.inputFile.getName(), (Throwable)illegalArgumentException);
            }
            catch (ErrorCodeIOException errorCodeIOException) {
                throw new OfficeException("could not load document: " + this.inputFile.getName() + "; errorCode: " + errorCodeIOException.ErrCode, (Throwable)errorCodeIOException);
            }
            catch (IOException ioException) {
                throw new OfficeException("could not load document: " + this.inputFile.getName(), (Throwable)ioException);
            }
            if (document == null) {
                throw new OfficeException("could not load document: " + this.inputFile.getName());
            }
            XRefreshable refreshable = (XRefreshable)OfficeUtils.cast(XRefreshable.class, (Object)document);
            if (refreshable != null) {
                refreshable.refresh();
            }
            XDocumentInfoSupplier docInfoSupplier = (XDocumentInfoSupplier)OfficeUtils.cast(XDocumentInfoSupplier.class, (Object)document);
            XPropertySet propSet = (XPropertySet)OfficeUtils.cast(XPropertySet.class, (Object)docInfoSupplier.getDocumentInfo());
            Object author = this.getPropertyValueIfAvailable(propSet, "Author");
            Object description = this.getPropertyValueIfAvailable(propSet, "Subject");
            Object title = this.getPropertyValueIfAvailable(propSet, "Title");
            this.metadata = new HashMap(3);
            this.metadata.put(KEY_AUTHOR, author == null ? null : author.toString());
            this.metadata.put(KEY_DESCRIPTION, description == null ? null : description.toString());
            this.metadata.put(KEY_TITLE, title == null ? null : title.toString());
            if (document == null) return;
        }
        catch (OfficeException officeException) {
            try {
                throw officeException;
                catch (Exception exception) {
                    throw new OfficeException("conversion failed", (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                if (document == null) throw throwable;
                XCloseable closeable2 = (XCloseable)OfficeUtils.cast(XCloseable.class, document);
                if (closeable2 == null) {
                    document.dispose();
                    throw throwable;
                }
                try {
                    closeable2.close(true);
                    throw throwable;
                }
                catch (CloseVetoException closeVetoException) {
                    throw throwable;
                }
            }
        }
        XCloseable closeable = (XCloseable)OfficeUtils.cast(XCloseable.class, (Object)document);
        if (closeable == null) {
            document.dispose();
            return;
        }
        try {
            closeable.close(true);
            return;
        }
        catch (CloseVetoException closeVetoException) {
            return;
        }
    }

    private Object getPropertyValueIfAvailable(XPropertySet propSet, String propertyName) throws UnknownPropertyException, WrappedTargetException {
        if (propSet.getPropertySetInfo().hasPropertyByName(propertyName)) {
            return propSet.getPropertyValue(propertyName);
        }
        return null;
    }
}

