/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.libreoffice.transformers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.star.task.ErrorCodeIOException;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.executors.JavaExecutor;
import org.alfresco.transform.base.util.CustomTransformerFileAdaptor;
import org.alfresco.transform.exceptions.TransformException;
import org.alfresco.transform.libreoffice.patch.LibreOfficeProfileManager;
import org.alfresco.transform.libreoffice.transformers.JodConverter;
import org.alfresco.transform.libreoffice.transformers.JodConverterSharedInstance;
import org.alfresco.transform.libreoffice.transformers.LibreOfficeExtractMetadataTask;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.artofsolving.jodconverter.office.OfficeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class LibreOfficeTransformer
implements JavaExecutor,
CustomTransformerFileAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(LibreOfficeTransformer.class);
    private static final int JODCONVERTER_TRANSFORMATION_ERROR_CODE = 3088;
    @Value(value="${transform.core.libreoffice.path}")
    private String path;
    @Value(value="${transform.core.libreoffice.maxTasksPerProcess}")
    private String maxTasksPerProcess;
    @Value(value="${transform.core.libreoffice.timeout}")
    private String timeout;
    @Value(value="${transform.core.libreoffice.portNumbers}")
    private String portNumbers;
    @Value(value="${transform.core.libreoffice.templateProfileDir}")
    private String templateProfileDir;
    @Value(value="${transform.core.libreoffice.isEnabled}")
    private String isEnabled;
    private JodConverter jodconverter;
    private final ObjectMapper jsonObjectMapper = new ObjectMapper();

    @PostConstruct
    private void createJodConverter() {
        if (this.path == null || this.path.isEmpty()) {
            throw new IllegalArgumentException("LibreOfficeTransformer LIBREOFFICE_HOME cannot be null or empty");
        }
        if (this.maxTasksPerProcess == null || this.maxTasksPerProcess.isEmpty() || !StringUtils.isNumeric((CharSequence)this.maxTasksPerProcess)) {
            throw new IllegalArgumentException("LibreOfficeTransformer LIBREOFFICE_MAX_TASKS_PER_PROCESS must have a numeric value");
        }
        if (this.timeout == null || this.timeout.isEmpty() || !StringUtils.isNumeric((CharSequence)this.timeout)) {
            throw new IllegalArgumentException("LibreOfficeTransformer LIBREOFFICE_TIMEOUT must have a numeric value");
        }
        if (this.portNumbers == null || this.portNumbers.isEmpty()) {
            throw new IllegalArgumentException("LibreOfficeTransformer LIBREOFFICE_PORT_NUMBERS variable cannot be null or empty");
        }
        if (this.templateProfileDir == null) {
            throw new IllegalArgumentException("LibreOfficeTransformer LIBREOFFICE_TEMPLATE_PROFILE_DIR variable cannot be null");
        }
        if (this.isEnabled == null || this.isEnabled.isEmpty() || !this.isEnabled.equalsIgnoreCase("true") && !this.isEnabled.equalsIgnoreCase("false")) {
            throw new IllegalArgumentException("LibreOfficeTransformer LIBREOFFICE_IS_ENABLED variable must be set to true/false");
        }
        LibreOfficeProfileManager profileManager = new LibreOfficeProfileManager(this.templateProfileDir);
        String effectiveTemplateProfileDir = profileManager.getEffectiveTemplateProfileDir();
        JodConverterSharedInstance sharedInstance = new JodConverterSharedInstance();
        this.jodconverter = sharedInstance;
        sharedInstance.setOfficeHome(this.path);
        sharedInstance.setMaxTasksPerProcess(this.maxTasksPerProcess);
        sharedInstance.setTaskExecutionTimeout(this.timeout);
        sharedInstance.setTaskQueueTimeout(this.timeout);
        sharedInstance.setConnectTimeout(this.timeout);
        sharedInstance.setPortNumbers(this.portNumbers);
        sharedInstance.setEnabled(this.isEnabled);
        sharedInstance.setTemplateProfileDir(effectiveTemplateProfileDir);
        sharedInstance.afterPropertiesSet();
    }

    public String getTransformerName() {
        return "libreoffice";
    }

    public void transform(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile, TransformManager transformManager) {
        this.call(sourceFile, targetFile, new String[0]);
    }

    public void call(File sourceFile, File targetFile, String ... args) {
        try {
            this.convert(sourceFile, targetFile);
        }
        catch (OfficeException e) {
            throw new TransformException(HttpStatus.BAD_REQUEST, "LibreOffice server conversion failed: \n   from file: " + String.valueOf(sourceFile) + "\n   to file: " + String.valueOf(targetFile), (Throwable)e);
        }
        catch (Throwable throwable) {
            if (throwable.getCause() instanceof ErrorCodeIOException && ((ErrorCodeIOException)throwable.getCause()).ErrCode == 3088) {
                logger.warn("Transformation failed: \nfrom file: " + String.valueOf(sourceFile) + "\nto file: " + String.valueOf(targetFile) + "Source file " + String.valueOf(sourceFile) + " has no content");
                LibreOfficeTransformer.produceEmptyPdfFile((File)targetFile);
            }
            throw throwable;
        }
        if (!targetFile.exists() || targetFile.length() == 0L) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, "Transformer failed to create an output file");
        }
    }

    public void convert(File sourceFile, File targetFile) {
        OfficeManager officeManager = this.jodconverter.getOfficeManager();
        OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
        converter.convert(sourceFile, targetFile);
    }

    private static void produceEmptyPdfFile(File targetFile) {
        PDPage pdfPage = new PDPage();
        try (PDDocument pdfDoc = new PDDocument();
             PDPageContentStream ignore = new PDPageContentStream(pdfDoc, pdfPage);){
            pdfDoc.addPage(pdfPage);
            pdfDoc.save(targetFile.getAbsolutePath());
        }
        catch (IOException iox) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, "Error creating empty PDF file", (Throwable)iox);
        }
    }

    public void extractMetadata(String transformName, String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile) {
        OfficeManager officeManager = this.jodconverter.getOfficeManager();
        LibreOfficeExtractMetadataTask extractMetadataTask = new LibreOfficeExtractMetadataTask(sourceFile);
        try {
            officeManager.execute((OfficeTask)extractMetadataTask);
        }
        catch (OfficeException e) {
            throw new TransformException(HttpStatus.BAD_REQUEST, "LibreOffice metadata extract failed: \n   from file: " + String.valueOf(sourceFile), (Throwable)e);
        }
        Map metadata = extractMetadataTask.getMetadata();
        if (logger.isDebugEnabled()) {
            metadata.forEach((k, v) -> logger.debug(k + "=" + String.valueOf(v)));
        }
        this.writeMetadataIntoTargetFile(targetFile, metadata);
    }

    private void writeMetadataIntoTargetFile(File targetFile, Map<String, Serializable> results) {
        try {
            this.jsonObjectMapper.writeValue(targetFile, results);
        }
        catch (IOException e) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, "Failed to write metadata to targetFile", (Throwable)e);
        }
    }
}

