/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.libreoffice;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.UUID;
import org.alfresco.transform.base.AbstractBaseTest;
import org.alfresco.transform.base.CustomTransformer;
import org.alfresco.transform.base.executors.RuntimeExec;
import org.alfresco.transform.base.model.FileRefEntity;
import org.alfresco.transform.base.model.FileRefResponse;
import org.alfresco.transform.base.registry.CustomTransformers;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.alfresco.transform.libreoffice.transformers.LibreOfficeTransformer;
import org.artofsolving.jodconverter.office.OfficeException;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.webmvc.test.autoconfigure.AutoConfigureMockMvc;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.context.bean.override.mockito.MockitoSpyBean;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.util.StringUtils;

@AutoConfigureMockMvc
public class LibreOfficeTest
extends AbstractBaseTest {
    protected static String targetMimetype = "application/pdf";
    @MockitoSpyBean
    private LibreOfficeTransformer libreOfficeTransformer;
    @Autowired
    private CustomTransformers customTransformers;
    @Autowired
    private LibreOfficeTransformer spyLibreOfficeTransformer;
    @MockitoBean
    protected RuntimeExec.ExecutionResult mockExecutionResult;
    @Value(value="${transform.core.libreoffice.path}")
    private String execPath;
    @Value(value="${transform.core.libreoffice.maxTasksPerProcess}")
    private String maxTasksPerProcess;
    @Value(value="${transform.core.libreoffice.timeout}")
    private String timeout;
    @Value(value="${transform.core.libreoffice.portNumbers}")
    private String portNumbers;
    @Value(value="${transform.core.libreoffice.templateProfileDir}")
    private String templateProfileDir;
    @Value(value="${transform.core.libreoffice.isEnabled}")
    private String isEnabled;

    @BeforeEach
    public void before() throws IOException {
        this.customTransformers.put("libreoffice", (CustomTransformer)this.spyLibreOfficeTransformer);
        this.sourceExtension = "doc";
        this.targetExtension = "pdf";
        this.sourceMimetype = "application/msword";
        this.sourceFileBytes = Files.readAllBytes(this.getTestFile("quick." + this.sourceExtension, true).toPath());
        this.expectedTargetFileBytes = Files.readAllBytes(this.getTestFile("quick." + this.targetExtension, true).toPath());
        this.sourceFile = new MockMultipartFile("file", "quick." + this.sourceExtension, this.sourceMimetype, this.sourceFileBytes);
        ((LibreOfficeTransformer)Mockito.doAnswer(invocation -> {
            File sourceFile = (File)invocation.getArgument(0);
            File targetFile = (File)invocation.getArgument(1);
            String actualTargetExtension = StringUtils.getFilenameExtension((String)targetFile.getAbsolutePath());
            Assertions.assertNotNull((Object)sourceFile);
            Assertions.assertNotNull((Object)targetFile);
            String actualTarget = targetFile.getAbsolutePath();
            int i = actualTarget.lastIndexOf(95);
            if (i >= 0) {
                String testFilename = actualTarget.substring(i + 1);
                File testFile = this.getTestFile(testFilename, false);
                this.generateTargetFileFromResourceFile(actualTargetExtension, testFile, targetFile);
            }
            byte[] actualSourceFileBytes = Files.readAllBytes(sourceFile.toPath());
            Assertions.assertTrue((boolean)Arrays.equals(this.sourceFileBytes, actualSourceFileBytes), (String)"Source file is not the same");
            return null;
        }).when((Object)this.spyLibreOfficeTransformer)).convert((File)ArgumentMatchers.any(), (File)ArgumentMatchers.any());
    }

    @AfterEach
    public void after() throws IOException {
        this.customTransformers.put("libreoffice", (CustomTransformer)this.libreOfficeTransformer);
    }

    protected MockMultipartHttpServletRequestBuilder mockMvcRequest(String url, MockMultipartFile sourceFile, String ... params) {
        MockMultipartHttpServletRequestBuilder builder = (MockMultipartHttpServletRequestBuilder)((MockMultipartHttpServletRequestBuilder)super.mockMvcRequest(url, sourceFile, params).param("targetMimetype", new String[]{targetMimetype})).param("sourceMimetype", new String[]{this.sourceMimetype});
        return builder;
    }

    @Test
    public void badExitCodeTest() throws Exception {
        ((LibreOfficeTransformer)Mockito.doThrow(OfficeException.class).when((Object)this.spyLibreOfficeTransformer)).convert((File)ArgumentMatchers.any(), (File)ArgumentMatchers.any());
        this.mockMvc.perform((RequestBuilder)((MockMultipartHttpServletRequestBuilder)((MockMultipartHttpServletRequestBuilder)((MockMultipartHttpServletRequestBuilder)MockMvcRequestBuilders.multipart((String)"/transform", (Object[])new Object[0]).file(this.sourceFile)).param("targetExtension", new String[]{"xxx"})).param("sourceMimetype", new String[]{this.sourceMimetype})).param("targetMimetype", new String[]{targetMimetype})).andExpect(MockMvcResultMatchers.status().is(400)).andExpect(MockMvcResultMatchers.status().reason(Matchers.containsString((String)"LibreOffice server conversion failed:")));
    }

    protected void updateTransformRequestWithSpecificOptions(TransformRequest transformRequest) {
        transformRequest.setSourceExtension("doc");
        transformRequest.setTargetExtension("pdf");
        transformRequest.setSourceMediaType("application/msword");
        transformRequest.setTargetMediaType(targetMimetype);
    }

    @Test
    public void testPojoTransform() throws Exception {
        String sourceFileRef = UUID.randomUUID().toString();
        File sourceFile = this.getTestFile("quick." + this.sourceExtension, true);
        String targetFileRef = UUID.randomUUID().toString();
        TransformRequest transformRequest = this.createTransformRequest(sourceFileRef, sourceFile);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Disposition", "attachment; filename=quick." + this.sourceExtension);
        ResponseEntity response = new ResponseEntity((Object)new FileSystemResource(sourceFile), headers, (HttpStatusCode)HttpStatus.OK);
        Mockito.when((Object)this.sharedFileStoreClient.retrieveFile(sourceFileRef)).thenReturn((Object)response);
        Mockito.when((Object)this.sharedFileStoreClient.saveFile((File)ArgumentMatchers.any())).thenReturn((Object)new FileRefResponse(new FileRefEntity(targetFileRef)));
        Mockito.when((Object)this.mockExecutionResult.getExitValue()).thenReturn((Object)0);
        this.updateTransformRequestWithSpecificOptions(transformRequest);
        String tr = this.objectMapper.writeValueAsString((Object)transformRequest);
        String transformationReplyAsString = this.mockMvc.perform((RequestBuilder)((MockHttpServletRequestBuilder)((MockHttpServletRequestBuilder)MockMvcRequestBuilders.post((String)"/transform", (Object[])new Object[0]).header("Accept", new Object[]{"application/json"})).header("Content-Type", new Object[]{"application/json"})).content(tr)).andExpect(MockMvcResultMatchers.status().is(HttpStatus.CREATED.value())).andReturn().getResponse().getContentAsString();
        TransformReply transformReply = (TransformReply)this.objectMapper.readValue(transformationReplyAsString, TransformReply.class);
        Assertions.assertEquals((Object)transformRequest.getRequestId(), (Object)transformReply.getRequestId());
        Assertions.assertEquals((Object)transformRequest.getClientData(), (Object)transformReply.getClientData());
        Assertions.assertEquals((int)transformRequest.getSchema(), (int)transformReply.getSchema());
    }

    @Test
    public void testOverridingExecutorPaths() {
        Assertions.assertEquals((Object)this.execPath, (Object)System.getProperty("LIBREOFFICE_HOME"));
    }

    @Test
    public void testOverridingExecutorMaxTasksPerProcess() {
        Assertions.assertEquals((Object)this.maxTasksPerProcess, (Object)System.getProperty("LIBREOFFICE_MAX_TASKS_PER_PROCESS"));
    }

    @Test
    public void testOverridingExecutorTimeout() {
        Assertions.assertEquals((Object)this.timeout, (Object)System.getProperty("LIBREOFFICE_TIMEOUT"));
    }

    @Test
    public void testOverridingExecutorPortNumbers() {
        Assertions.assertEquals((Object)this.portNumbers, (Object)System.getProperty("LIBREOFFICE_PORT_NUMBERS"));
    }

    @Test
    public void testOverridingExecutorTemplateProfileDir() {
        Assertions.assertEquals((Object)this.templateProfileDir, (Object)System.getProperty("LIBREOFFICE_TEMPLATE_PROFILE_DIR"));
    }

    @Test
    public void testOverridingExecutorIsEnabled() {
        Assertions.assertEquals((Object)this.isEnabled, (Object)System.getProperty("LIBREOFFICE_IS_ENABLED"));
    }

    @Test
    public void testInvalidExecutorMaxTasksPerProcess() {
        this.testInvalidValue("maxTasksPerProcess", "INVALID", "LibreOfficeTransformer LIBREOFFICE_MAX_TASKS_PER_PROCESS must have a numeric value");
    }

    @Test
    public void testInvalidExecutorTimeout() {
        this.testInvalidValue("timeout", "INVALID", "LibreOfficeTransformer LIBREOFFICE_TIMEOUT must have a numeric value");
    }

    @Test
    public void testInvalidExecutorPortNumbers() {
        this.testInvalidValue("portNumbers", null, "LibreOfficeTransformer LIBREOFFICE_PORT_NUMBERS variable cannot be null or empty");
    }

    @Test
    public void testInvalidExecutorIsEnabled() {
        this.testInvalidValue("isEnabled", "INVALID", "LibreOfficeTransformer LIBREOFFICE_IS_ENABLED variable must be set to true/false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInvalidValue(String fieldName, String invalidValue, String expectedErrorMessage) {
        String validValue = (String)ReflectionTestUtils.getField((Object)this.libreOfficeTransformer, (String)fieldName);
        String errorMessage = "";
        try {
            ReflectionTestUtils.setField((Object)this.libreOfficeTransformer, (String)fieldName, (Object)invalidValue);
            ReflectionTestUtils.invokeMethod((Object)this.libreOfficeTransformer, (String)"createJodConverter", (Object[])new Object[0]);
        }
        catch (IllegalArgumentException e) {
            errorMessage = e.getMessage();
        }
        finally {
            ReflectionTestUtils.setField((Object)this.libreOfficeTransformer, (String)fieldName, (Object)validValue);
        }
        Assertions.assertEquals((Object)expectedErrorMessage, (Object)errorMessage);
    }
}

