/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.misc.transformers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.util.HashMap;
import org.alfresco.transform.misc.transformers.HtmlParserContentTransformer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class HtmlParserContentTransformerTest {
    private static final String SOURCE_MIMETYPE = "text/html";
    private static final String TARGET_MIMETYPE = "text/plain";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodingHandling() throws Exception {
        HtmlParserContentTransformer transformer = new HtmlParserContentTransformer();
        String newline = System.getProperty("line.separator");
        String title = "Testing!";
        String textp1 = "This is some text in English";
        String textp2 = "This is more text in English";
        String textp3 = "C'est en Fran\u00e7ais et Espa\u00f1ol";
        String partA = "<html><head><title>Testing!</title></head>" + newline;
        String partB = "<body><p>This is some text in English</p>" + newline + "<p>This is more text in English</p>" + newline + "<p>C'est en Fran\u00e7ais et Espa\u00f1ol</p>" + newline;
        String partC = "</body></html>";
        String expected = "Testing!" + newline + "This is some text in English" + newline + "This is more text in English" + newline + "C'est en Fran\u00e7ais et Espa\u00f1ol";
        File tmpS = null;
        File tmpD = null;
        try {
            tmpS = File.createTempFile("AlfrescoTestSource_", ".html");
            this.writeToFile(tmpS, partA + partB + partC, "ISO-8859-1");
            tmpD = File.createTempFile("AlfrescoTestTarget_", ".txt");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("sourceEncoding", "ISO-8859-1");
            parameters.put("collapseHtml", String.valueOf(true));
            transformer.transform(SOURCE_MIMETYPE, TARGET_MIMETYPE, parameters, tmpS, tmpD, null);
            Assertions.assertEquals((Object)expected, (Object)this.readFromFile(tmpD, "UTF-8"));
            tmpS.delete();
            tmpD.delete();
            tmpS = File.createTempFile("AlfrescoTestSource_", ".html");
            this.writeToFile(tmpS, partA + partB + partC, "UTF-8");
            tmpD = File.createTempFile("AlfrescoTestTarget_", ".txt");
            parameters = new HashMap();
            parameters.put("sourceEncoding", "UTF-8");
            parameters.put("collapseHtml", String.valueOf(true));
            transformer.transform(SOURCE_MIMETYPE, TARGET_MIMETYPE, parameters, tmpS, tmpD, null);
            Assertions.assertEquals((Object)expected, (Object)this.readFromFile(tmpD, "UTF-8"));
            tmpS.delete();
            tmpD.delete();
            tmpS = File.createTempFile("AlfrescoTestSource_", ".html");
            this.writeToFile(tmpS, partA + partB + partC, "UTF-16");
            tmpD = File.createTempFile("AlfrescoTestTarget_", ".txt");
            parameters = new HashMap();
            parameters.put("collapseHtml", String.valueOf(true));
            parameters.put("sourceEncoding", "UTF-16");
            transformer.transform(SOURCE_MIMETYPE, TARGET_MIMETYPE, parameters, tmpS, tmpD, null);
            Assertions.assertEquals((Object)expected, (Object)this.readFromFile(tmpD, "UTF-8"));
            tmpS.delete();
            tmpD.delete();
            tmpS = File.createTempFile("AlfrescoTestSource_", ".html");
            String str = partA + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">" + partB + partC;
            this.writeToFile(tmpS, str, "UTF-8");
            tmpD = File.createTempFile("AlfrescoTestTarget_", ".txt");
            parameters = new HashMap();
            parameters.put("sourceEncoding", "ISO-8859-1");
            parameters.put("collapseHtml", String.valueOf(true));
            transformer.transform(SOURCE_MIMETYPE, TARGET_MIMETYPE, parameters, tmpS, tmpD, null);
            Assertions.assertEquals((Object)expected, (Object)this.readFromFile(tmpD, "UTF-8"));
            tmpS.delete();
            tmpD.delete();
        }
        catch (Exception e) {
            Assertions.fail((String)("Test Failed: " + e.getMessage()));
        }
        finally {
            if (tmpS != null && tmpS.exists()) {
                tmpS.delete();
            }
            if (tmpD != null && tmpD.exists()) {
                tmpD.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTransformerWithDifferentCollapsingMethods(boolean shouldCollapse) {
        HtmlParserContentTransformer transformer = new HtmlParserContentTransformer();
        String newline = System.getProperty("line.separator");
        String title = "Testing!";
        String textp1 = "This is some text in English";
        String textp2 = "This is more text in English";
        String textp3 = "C'est en Fran\u00e7ais et Espa\u00f1ol";
        String partA = "<html><head><title>Testing!</title></head>" + newline;
        String partB = "<body><p>This is some text in English</p>" + newline + "<p>This is more text in English</p>" + newline + "<p>C'est en Fran\u00e7ais et Espa\u00f1ol</p>" + newline;
        String partC = "</body></html>";
        String expected = "Testing!" + newline + "This is some text in English" + newline + "This is more text in English" + newline + "C'est en Fran\u00e7ais et Espa\u00f1ol" + (shouldCollapse ? "" : newline);
        File tmpS = null;
        File tmpD = null;
        try {
            tmpS = File.createTempFile("AlfrescoTestSource_", ".html");
            this.writeToFile(tmpS, partA + partB + partC, "UTF-8");
            tmpD = File.createTempFile("AlfrescoTestTarget_", ".txt");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("sourceEncoding", "UTF-8");
            parameters.put("collapseHtml", String.valueOf(shouldCollapse));
            transformer.transform(SOURCE_MIMETYPE, TARGET_MIMETYPE, parameters, tmpS, tmpD, null);
            Assertions.assertEquals((Object)expected, (Object)this.readFromFile(tmpD, "UTF-8"));
            tmpS.delete();
            tmpD.delete();
        }
        catch (Exception e) {
            Assertions.fail((String)("Test Failed: " + e.getMessage()));
        }
        finally {
            if (tmpS != null && tmpS.exists()) {
                tmpS.delete();
            }
            if (tmpD != null && tmpD.exists()) {
                tmpD.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(strings={"cat", "dog", "", "1234abcd", "@#$%"})
    public void testTransformerWithWrongBooleanValues(String booleanValues) {
        HtmlParserContentTransformer transformer = new HtmlParserContentTransformer();
        String newline = System.getProperty("line.separator");
        String title = "Testing!";
        String textp1 = "This is some text in English";
        String textp2 = "This is more text in English";
        String textp3 = "C'est en Fran\u00e7ais et Espa\u00f1ol";
        String partA = "<html><head><title>Testing!</title></head>" + newline;
        String partB = "<body><p>This is some text in English</p>" + newline + "<p>This is more text in English</p>" + newline + "<p>C'est en Fran\u00e7ais et Espa\u00f1ol</p>" + newline;
        String partC = "</body></html>";
        String expected = "Testing!" + newline + "This is some text in English" + newline + "This is more text in English" + newline + "C'est en Fran\u00e7ais et Espa\u00f1ol";
        File tmpS = null;
        File tmpD = null;
        try {
            tmpS = File.createTempFile("AlfrescoTestSource_", ".html");
            this.writeToFile(tmpS, partA + partB + partC, "UTF-8");
            tmpD = File.createTempFile("AlfrescoTestTarget_", ".txt");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("sourceEncoding", "UTF-8");
            parameters.put("collapseHtml", booleanValues);
            transformer.transform(SOURCE_MIMETYPE, TARGET_MIMETYPE, parameters, tmpS, tmpD, null);
            Assertions.assertEquals((Object)expected, (Object)this.readFromFile(tmpD, "UTF-8"));
            tmpS.delete();
            tmpD.delete();
        }
        catch (Exception e) {
            Assertions.fail((String)("Test Failed: " + e.getMessage()));
        }
        finally {
            if (tmpS != null && tmpS.exists()) {
                tmpS.delete();
            }
            if (tmpD != null && tmpD.exists()) {
                tmpD.delete();
            }
        }
    }

    private void writeToFile(File file, String content, String encoding) {
        try (OutputStreamWriter ow = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);){
            ow.append(content);
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to write to file: " + e.getMessage()));
        }
    }

    private String readFromFile(File file, String encoding) {
        try {
            return new String(Files.readAllBytes(file.toPath()), encoding);
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to read from file: " + e.getMessage()));
            return null;
        }
    }
}

