/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.misc.transformers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Map;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.util.CustomTransformerFileAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StringExtractingContentTransformer
implements CustomTransformerFileAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(StringExtractingContentTransformer.class);

    public String getTransformerName() {
        return "string";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile, TransformManager transformManager) throws Exception {
        String sourceEncoding = transformOptions.get("sourceEncoding");
        String targetEncoding = transformOptions.get("targetEncoding");
        if (logger.isDebugEnabled()) {
            logger.debug("Performing text to text transform with sourceEncoding=" + sourceEncoding + " targetEncoding=" + targetEncoding);
        }
        Reader charReader = null;
        Writer charWriter = null;
        try {
            if (sourceEncoding == null) {
                charReader = new BufferedReader(new InputStreamReader(new FileInputStream(sourceFile)));
            } else {
                this.checkEncodingParameter(sourceEncoding, "sourceEncoding");
                charReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceFile), sourceEncoding));
            }
            if (targetEncoding == null) {
                charWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(targetFile)));
            } else {
                this.checkEncodingParameter(targetEncoding, "targetEncoding");
                charWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), targetEncoding));
            }
            char[] buffer = new char[8192];
            int readCount = 0;
            while (readCount > -1) {
                charWriter.write(buffer, 0, readCount);
                readCount = charReader.read(buffer);
            }
        }
        finally {
            if (charReader != null) {
                try {
                    charReader.close();
                }
                catch (Throwable e) {
                    logger.error("Failed to close charReader", e);
                }
            }
            if (charWriter != null) {
                try {
                    charWriter.close();
                }
                catch (Throwable e) {
                    logger.error("Failed to close charWriter", e);
                }
            }
        }
    }

    private void checkEncodingParameter(String encoding, String paramterName) {
        try {
            if (!Charset.isSupported(encoding)) {
                throw new IllegalArgumentException(paramterName + "=" + encoding + " is not supported by the JVM.");
            }
        }
        catch (IllegalCharsetNameException e) {
            throw new IllegalArgumentException(paramterName + "=" + encoding + " is not a valid encoding.");
        }
    }
}

