/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.misc.transformers;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.util.CustomTransformerFileAdaptor;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ImageToPdfTransformer
implements CustomTransformerFileAdaptor {
    private static final Logger log = LoggerFactory.getLogger(ImageToPdfTransformer.class);
    private static final String NEGATIVE_START_PAGE_ERROR_MESSAGE = "Start page number cannot be a negative number.";
    private static final String NEGATIVE_END_PAGE_ERROR_MESSAGE = "End page number cannot be a negative number.";
    private static final String START_PAGE_GREATER_THAN_END_PAGE_ERROR_MESSAGE = "Start page number cannot be greater than end page.";
    private static final String INVALID_OPTION_ERROR_MESSAGE = "Parameter '%s' is invalid: \"%s\" - it must be an integer.";
    private static final String INVALID_IMAGE_ERROR_MESSAGE = "Image file (%s) format (%s) not supported by ImageIO.";
    private static final String DEFAULT_PDF_FORMAT_STRING = "DEFAULT";
    private static final String DEFAULT_PDF_ORIENTATION_STRING = "DEFAULT";
    private static final Boolean DEFAULT_IMPROVE_GRAYSCALE_FLAG = true;
    private static final float PDFBOX_POINTS_PER_INCH = 72.0f;
    private static final int MIN_REASONABLE_DPI = 30;
    private static final int MAX_REASONABLE_DPI = 600;
    private static final List<String> DENY_LIST = List.of("com.github.jaiimageio.impl.plugins.tiff.TIFFImageReader");
    private static final Set<Integer> GRAYSCALE_TYPES = Set.of(Integer.valueOf(10), Integer.valueOf(11));

    public String getTransformerName() {
        return "imageToPdf";
    }

    public void transform(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File imageFile, File pdfFile, TransformManager transformManager) throws Exception {
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(imageFile);
             PDDocument pdfDocument = new PDDocument();){
            Integer startPage = ImageToPdfTransformer.parseOptionIfPresent(transformOptions, (String)"startPage", Integer.class).orElse(null);
            Integer endPage = ImageToPdfTransformer.parseOptionIfPresent(transformOptions, (String)"endPage", Integer.class).orElse(null);
            String pdfFormat = ImageToPdfTransformer.parseOptionIfPresent(transformOptions, (String)"pdfFormat", String.class).orElse("DEFAULT");
            String pdfOrientation = ImageToPdfTransformer.parseOptionIfPresent(transformOptions, (String)"pdfOrientation", String.class).orElse("DEFAULT");
            Boolean improveGrayscale = ImageToPdfTransformer.parseOptionIfPresent(transformOptions, (String)"improveGrayscale", Boolean.class).orElse(DEFAULT_IMPROVE_GRAYSCALE_FLAG);
            ImageToPdfTransformer.verifyOptions((Integer)startPage, (Integer)endPage);
            Map resolution = ImageToPdfTransformer.determineImageResolution((File)imageFile);
            ImageReader imageReader = this.findImageReader(imageInputStream, imageFile.getName(), sourceMimetype);
            for (int i = 0; i < imageReader.getNumImages(true); ++i) {
                if (startPage != null && i < startPage) continue;
                if (endPage != null && i > endPage) break;
                this.scaleAndDrawImage(pdfDocument, imageReader.read(i), pdfFormat, pdfOrientation, improveGrayscale.booleanValue(), resolution);
            }
            pdfDocument.save(pdfFile);
        }
    }

    private ImageReader findImageReader(ImageInputStream imageInputStream, String imageName, String mimetype) throws IOException {
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageInputStream);
        if (imageReaders == null || !imageReaders.hasNext()) {
            throw new IOException(String.format("Image file (%s) format (%s) not supported by ImageIO.", imageName, mimetype));
        }
        while (imageReaders.hasNext()) {
            ImageReader reader = imageReaders.next();
            if (DENY_LIST.contains(reader.getClass().getName())) continue;
            reader.setInput(imageInputStream);
            return reader;
        }
        throw new IOException(String.format("Image file (%s) format (%s) not supported by ImageIO.", imageName, mimetype));
    }

    private int effectiveDpi(Integer dpi) {
        if (dpi == null || dpi < 30 || dpi > 600) {
            return 72;
        }
        return dpi;
    }

    private void scaleAndDrawImage(PDDocument pdfDocument, BufferedImage bufferedImage, String pdfFormat, String pdfOrientation, boolean improveGrayscale, Map<String, Integer> resolution) throws IOException {
        BufferedImage processedImage = this.convertGrayscaleImageIfNeeded(bufferedImage, improveGrayscale);
        PDImageXObject image = LosslessFactory.createFromImage((PDDocument)pdfDocument, (BufferedImage)processedImage);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (resolution.get("X") > 0 && (float)resolution.get("X").intValue() != 72.0f && resolution.get("Y") > 0 && (float)resolution.get("Y").intValue() != 72.0f) {
            int xRes = this.effectiveDpi(resolution.get("X"));
            int yRes = this.effectiveDpi(resolution.get("Y"));
            imageWidth = (int)((float)imageWidth / (float)xRes * 72.0f);
            imageHeight = (int)((float)imageHeight / (float)yRes * 72.0f);
        }
        PDPage pdfPage = new PDPage(this.resolvePdfFormat(pdfFormat, pdfOrientation, imageWidth, imageHeight));
        pdfDocument.addPage(pdfPage);
        try (PDPageContentStream pdfPageContent = new PDPageContentStream(pdfDocument, pdfPage);){
            PDRectangle pageSize = pdfPage.getMediaBox();
            float widthRatio = image.getWidth() > 0 ? pageSize.getWidth() / (float)image.getWidth() : 0.0f;
            float heightRatio = image.getHeight() > 0 ? pageSize.getHeight() / (float)image.getHeight() : 0.0f;
            float ratio = Stream.of(Float.valueOf(widthRatio), Float.valueOf(heightRatio), Float.valueOf(1.0f)).min(Comparator.naturalOrder()).get().floatValue();
            float y = pageSize.getHeight() - (float)image.getHeight() * ratio;
            pdfPageContent.drawImage(image, 0.0f, y, (float)image.getWidth() * ratio, (float)image.getHeight() * ratio);
        }
    }

    private BufferedImage convertGrayscaleImageIfNeeded(BufferedImage originalImage, boolean improveGrayscale) {
        if (!improveGrayscale || !GRAYSCALE_TYPES.contains(originalImage.getType())) {
            return originalImage;
        }
        BufferedImage improvedImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 1);
        Graphics2D graphics = improvedImage.createGraphics();
        graphics.drawImage((Image)originalImage, 0, 0, null);
        graphics.dispose();
        return improvedImage;
    }

    private PDRectangle resolvePdfFormat(String pdfFormat, String pdfOrientation, int defaultWidth, int defaultHeight) {
        PDRectangle pdRectangle = switch (pdfFormat.toUpperCase()) {
            case "DEFAULT" -> new PDRectangle((float)defaultWidth, (float)defaultHeight);
            case "A4" -> PDRectangle.A4;
            case "LETTER" -> PDRectangle.LETTER;
            case "A0" -> PDRectangle.A0;
            case "A1" -> PDRectangle.A1;
            case "A2" -> PDRectangle.A2;
            case "A3" -> PDRectangle.A3;
            case "A5" -> PDRectangle.A5;
            case "A6" -> PDRectangle.A6;
            case "LEGAL" -> PDRectangle.LEGAL;
            default -> {
                log.warn("PDF format: '{}' not supported. Maintaining the default one.", (Object)pdfFormat);
                yield new PDRectangle((float)defaultWidth, (float)defaultHeight);
            }
        };
        switch (pdfOrientation.toUpperCase()) {
            case "DEFAULT": {
                break;
            }
            case "PORTRAIT": {
                if (!(pdRectangle.getWidth() > pdRectangle.getHeight())) break;
                pdRectangle = new PDRectangle(pdRectangle.getHeight(), pdRectangle.getWidth());
                break;
            }
            case "LANDSCAPE": {
                if (!(pdRectangle.getHeight() > pdRectangle.getWidth())) break;
                pdRectangle = new PDRectangle(pdRectangle.getHeight(), pdRectangle.getWidth());
                break;
            }
            default: {
                log.warn("PDF orientation: '{}' not supported. Maintaining the default one.", (Object)pdfOrientation);
            }
        }
        return pdRectangle;
    }

    private static <T> Optional<T> parseOptionIfPresent(Map<String, String> transformOptions, String parameter, Class<T> targetType) {
        if (transformOptions.containsKey(parameter)) {
            String option = transformOptions.get(parameter);
            if (targetType == Integer.class) {
                try {
                    return Optional.of(targetType.cast(Integer.parseInt(option)));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Parameter '%s' is invalid: \"%s\" - it must be an integer.", parameter, option));
                }
            }
            if (targetType == Boolean.class) {
                try {
                    return Optional.of(targetType.cast(Boolean.parseBoolean(option)));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Parameter '%s' is invalid: \"%s\" - it must be an integer.", parameter, option));
                }
            }
            return Optional.of(targetType.cast(option));
        }
        return Optional.empty();
    }

    private static void verifyOptions(Integer startPage, Integer endPage) {
        if (startPage != null && startPage < 0) {
            throw new IllegalArgumentException("Start page number cannot be a negative number.");
        }
        if (endPage != null && endPage < 0) {
            throw new IllegalArgumentException("End page number cannot be a negative number.");
        }
        if (startPage != null && endPage != null && startPage > endPage) {
            throw new IllegalArgumentException("Start page number cannot be greater than end page.");
        }
    }

    private static Map<String, Integer> determineImageResolution(File imageFile) {
        int xResolution = 0;
        int yResolution = 0;
        try {
            ImageMetadata metadata = Imaging.getMetadata((File)imageFile);
            if (metadata instanceof TiffImageMetadata) {
                TiffImageMetadata tiffImageMetadata = (TiffImageMetadata)metadata;
                xResolution = ImageToPdfTransformer.findMetadataField((TiffImageMetadata)tiffImageMetadata, (TagInfo)TiffTagConstants.TIFF_TAG_XRESOLUTION);
                yResolution = ImageToPdfTransformer.findMetadataField((TiffImageMetadata)tiffImageMetadata, (TagInfo)TiffTagConstants.TIFF_TAG_YRESOLUTION);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Map.of("X", xResolution, "Y", yResolution);
    }

    private static int findMetadataField(TiffImageMetadata tiffImageMetadata, TagInfo tagInfo) {
        int value = 0;
        try {
            TiffField field = tiffImageMetadata.findField(tagInfo);
            if (field != null) {
                value = field.getIntValue();
            }
        }
        catch (ImagingException imagingException) {
            // empty catch block
        }
        return value;
    }
}

