/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.common;

import java.io.File;
import java.util.Map;
import org.alfresco.transform.client.model.InternalContext;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.alfresco.transform.common.ExtensionService;
import org.alfresco.transform.common.RepositoryClientData;
import org.alfresco.transform.messages.TransformStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerDebug {
    public static final Logger logger = LoggerFactory.getLogger(TransformerDebug.class);
    private static final int REFERENCE_SIZE = 15;
    private static final String TRANSFORM_NAMESPACE = "transform:";
    public static final String MIMETYPE_METADATA_EXTRACT = "alfresco-metadata-extract";
    public static final String MIMETYPE_METADATA_EMBED = "alfresco-metadata-embed";
    private static final String TIMEOUT = "timeout";
    private static final int MAX_OPTION_VALUE = 60;
    private static final int MAX_OPTION_END_CHARS = 5;
    private static final String MAX_OPTION_DOTS = "...";
    private boolean isTRouter = false;

    public void pushTransform(TransformRequest request) {
        RepositoryClientData repositoryClientData = new RepositoryClientData(request.getClientData());
        if (this.isEnabled(repositoryClientData)) {
            TransformStack.Step step = TransformStack.currentStep(request.getInternalContext());
            String reference = TransformStack.getReference(request.getInternalContext());
            boolean isTopLevel = this.isTopLevel(reference);
            String message = this.getPaddedReference(reference) + this.getMimetypeExt(step.getSourceMediaType()) + this.getTargetMimetypeExt(step.getTargetMediaType(), step.getSourceMediaType()) + " " + (String)(isTopLevel || !this.isTRouter() ? TransformerDebug.fileSize(request.getSourceSize()) + " " + this.getRenditionName(new RepositoryClientData(request.getClientData()).getRenditionName()) : "") + step.getTransformerName();
            if (this.isDebugToBeReturned(repositoryClientData)) {
                repositoryClientData.appendDebug(message);
                request.setClientData(repositoryClientData.toString());
            }
            logger.debug(message);
        }
    }

    @Deprecated
    public void pushTransform(String reference, String sourceMimetype, String targetMimetype, File sourceFile, String transformerName) {
        long sourceSizeInBytes = sourceFile.length();
        this.pushTransform(reference, sourceMimetype, targetMimetype, sourceSizeInBytes, transformerName);
    }

    public void pushTransform(String reference, String sourceMimetype, String targetMimetype, long sourceSizeInBytes, String transformerName) {
        if (logger.isDebugEnabled() && !this.isTRouter) {
            String message = this.getPaddedReference(reference) + this.getMimetypeExt(sourceMimetype) + this.getTargetMimetypeExt(targetMimetype, sourceMimetype) + " " + TransformerDebug.fileSize(sourceSizeInBytes) + " " + transformerName;
            logger.debug(message);
        }
    }

    public void popTransform(TransformReply reply) {
        if (logger.isDebugEnabled()) {
            InternalContext internalContext = reply.getInternalContext();
            String reference = TransformStack.getReference(internalContext);
            long elapsedTime = TransformStack.getElapsedTime(internalContext);
            this.popTransformWithDebugForEnginesOrAtTopForRouter(reference, elapsedTime);
        }
    }

    public void popTransform(String reference, long elapsedTime) {
        if (logger.isDebugEnabled() && !this.isTRouter) {
            this.popTransformWithDebugForEnginesOrAtTopForRouter(reference, elapsedTime);
        }
    }

    private void popTransformWithDebugForEnginesOrAtTopForRouter(String reference, long elapsedTime) {
        String message = this.getPaddedReference(reference) + "Finished in " + this.ms(elapsedTime);
        if (this.isTopLevel(reference) || !this.isTRouter()) {
            logger.debug(message);
        } else {
            logger.trace(message);
        }
    }

    public void logOptions(TransformRequest request) {
        Map<String, String> options;
        RepositoryClientData repositoryClientData = new RepositoryClientData(request.getClientData());
        if (this.isEnabled(repositoryClientData) && (options = request.getTransformRequestOptions()) != null && !options.isEmpty()) {
            String reference = TransformStack.getReference(request.getInternalContext());
            for (Map.Entry<String, String> option : options.entrySet()) {
                String key = option.getKey();
                if (TIMEOUT.equals(key)) continue;
                String value = option.getValue();
                String message = this.getOptionAndValue(reference, key, value);
                logger.debug(message);
                if (!this.isDebugToBeReturned(repositoryClientData)) continue;
                repositoryClientData.appendDebug(message);
            }
            request.setClientData(repositoryClientData.toString());
        }
    }

    public void logOptions(String reference, Map<String, String> options) {
        if (logger.isDebugEnabled() && !this.isTRouter && options != null && !options.isEmpty()) {
            for (Map.Entry<String, String> option : options.entrySet()) {
                String key = option.getKey();
                if (TIMEOUT.equals(key)) continue;
                String value = option.getValue();
                String message = this.getOptionAndValue(reference, key, value);
                logger.debug(message);
            }
        }
    }

    String getOptionAndValue(String reference, String key, String value) {
        int len = ((String)value).length();
        if (len > 60) {
            value = ((String)value).substring(0, 60 - MAX_OPTION_DOTS.length() - 5) + MAX_OPTION_DOTS + ((String)value).substring(len - 5);
        }
        return this.getPaddedReference(reference) + "  " + key + "=\"" + ((String)value).replaceAll("\"", "\\\"") + "\"";
    }

    public void logFragment(String reference, int index, long size) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}  fragment[{}]{}", new Object[]{this.getPaddedReference(reference), index, TransformerDebug.fileSize(size)});
        }
    }

    public void logFailure(TransformReply reply) {
        RepositoryClientData repositoryClientData = new RepositoryClientData(reply.getClientData());
        if (this.isEnabled(repositoryClientData)) {
            String reference = TransformStack.getReference(reply.getInternalContext());
            String message = this.getPaddedReference(reference) + reply.getErrorDetails();
            logger.debug(message);
            if (this.isDebugToBeReturned(repositoryClientData)) {
                repositoryClientData.appendDebug(message);
                reply.setClientData(repositoryClientData.toString());
            }
        }
    }

    public void logFailure(String reference, String message) {
        if (logger.isDebugEnabled()) {
            logger.debug(this.getPaddedReference(reference) + message);
        }
    }

    public TransformerDebug setIsTRouter(boolean isTRouter) {
        this.isTRouter = isTRouter;
        return this;
    }

    private boolean isEnabled(RepositoryClientData repositoryClientData) {
        return logger.isDebugEnabled() || this.isDebugToBeReturned(repositoryClientData);
    }

    private boolean isDebugToBeReturned(RepositoryClientData repositoryClientData) {
        return this.isTRouter() && repositoryClientData.isDebugRequested();
    }

    private boolean isTRouter() {
        return this.isTRouter;
    }

    private boolean isTopLevel(String reference) {
        return !reference.contains(".");
    }

    private String getPaddedReference(String reference) {
        return reference + this.spaces(18 - reference.length());
    }

    private String getMimetypeExt(String mimetype) {
        return this.padExt(ExtensionService.getExtensionForMimetype(mimetype), mimetype);
    }

    public String getTargetMimetypeExt(String targetMimetype, String sourceMimetype) {
        return this.padExt(ExtensionService.getExtensionForTargetMimetype(targetMimetype, sourceMimetype), targetMimetype);
    }

    private String padExt(String mimetypeExt, String mimetype) {
        StringBuilder sb = new StringBuilder("");
        if (mimetypeExt == null) {
            sb.append(mimetype);
        } else {
            sb.append(mimetypeExt);
            sb.append(this.spaces(4 - mimetypeExt.length()));
        }
        sb.append(' ');
        return sb.toString();
    }

    private String getRenditionName(String renditionName) {
        return !renditionName.isEmpty() ? "-- " + TransformerDebug.replaceWithMetadataRenditionNameIfEmbedOrExtract(renditionName) + " -- " : "";
    }

    private static String replaceWithMetadataRenditionNameIfEmbedOrExtract(String renditionName) {
        String transformName = TransformerDebug.getTransformName(renditionName);
        return transformName.startsWith(MIMETYPE_METADATA_EXTRACT) ? "metadataExtract" : (transformName.startsWith(MIMETYPE_METADATA_EMBED) ? "metadataEmbed" : renditionName);
    }

    private static String getTransformName(String renditionName) {
        return !renditionName.startsWith(TRANSFORM_NAMESPACE) ? "" : renditionName.substring(TRANSFORM_NAMESPACE.length());
    }

    private String spaces(int i) {
        StringBuilder sb = new StringBuilder("");
        while (--i >= 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private String ms(long time) {
        return String.format("%,d ms", time);
    }

    public static String fileSize(long size) {
        if (size < 0L) {
            return "unlimited";
        }
        if (size == 1L) {
            return "1 byte";
        }
        String[] units = new String[]{"bytes", "KB", "MB", "GB", "TB"};
        long divider = 1L;
        for (int i = 0; i < units.length - 1; ++i) {
            long nextDivider = divider * 1024L;
            if (size < nextDivider) {
                return TransformerDebug.fileSizeFormat(size, divider, units[i]);
            }
            divider = nextDivider;
        }
        return TransformerDebug.fileSizeFormat(size, divider, units[units.length - 1]);
    }

    private static String fileSizeFormat(long size, long divider, String unit) {
        size = size * 10L / divider;
        int decimalPoint = (int)size % 10;
        StringBuilder sb = new StringBuilder();
        sb.append(size / 10L);
        if (decimalPoint != 0) {
            sb.append(".");
            sb.append(decimalPoint);
        }
        sb.append(' ');
        sb.append(unit);
        return sb.toString();
    }
}

