/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.messages;

import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.alfresco.transform.client.model.InternalContext;
import org.alfresco.transform.client.model.MultiStep;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.common.TransformerDebug;
import org.alfresco.transform.messages.TransformStack;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class TransformStackTest {
    private static long START = System.currentTimeMillis();
    private static String STEP = "\u23d0name\u23d0source\u23d0target";
    @Mock
    private TransformerDebug transformerDebug;
    @Mock
    private TransformReply reply;
    public static final ImmutableMap<String, TransformStack.LevelBuilder> TEST_LEVELS = ImmutableMap.of((Object)"top", (Object)TransformStack.levelBuilder((String)"P").withStep("pipeline 1-N", "type1", "typeN"), (Object)"pipeline 1-N", (Object)TransformStack.levelBuilder((String)"P").withStep("transform1-2", "type1", "type2").withStep("pipeline 2-3", "type2", "type3").withStep("failover 3-N", "type3", "typeN"), (Object)"pipeline 2-3", (Object)TransformStack.levelBuilder((String)"P").withStep("transform2-4", "type2", "type4").withStep("transform4-3", "type4", "type3"), (Object)"failover 3-N", (Object)TransformStack.levelBuilder((String)"F").withStep("transform3-Na", "type3", "typeN").withStep("transform3-Nb", "type3", "typeN").withStep("pipeline 3-Nc", "type3", "typeN"), (Object)"pipeline 3-Nc", (Object)TransformStack.levelBuilder((String)"P").withStep("transform3-5", "type3", "type5").withStep("pipeline 5-N", "type5", "typeN"), (Object)"pipeline 5-N", (Object)TransformStack.levelBuilder((String)"P").withStep("transform5-6", "type5", "type6").withStep("transform6-N", "type6", "typeN"));
    private final InternalContext internalContext = new InternalContext();
    private final Map<String, String> options = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"", (Object)"key3", (Object)"value3");
    private final String sourceReference = UUID.randomUUID().toString();

    TransformStackTest() {
    }

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        this.internalContext.setMultiStep(new MultiStep());
        this.internalContext.getMultiStep().setTransformsToBeDone(new ArrayList());
        TransformStack.setInitialTransformRequestOptions((InternalContext)this.internalContext, this.options);
        TransformStack.setInitialSourceReference((InternalContext)this.internalContext, (String)this.sourceReference);
        ((TransformReply)Mockito.doReturn((Object)this.internalContext).when((Object)this.reply)).getInternalContext();
    }

    @Test
    public void testOptions() {
        Assertions.assertEquals(this.options, (Object)TransformStack.getInitialTransformRequestOptions((InternalContext)this.internalContext));
    }

    @Test
    public void testOptionsEmpty() {
        ImmutableMap options = ImmutableMap.of();
        TransformStack.setInitialTransformRequestOptions((InternalContext)this.internalContext, (Map)options);
        Assertions.assertEquals((Object)options, (Object)TransformStack.getInitialTransformRequestOptions((InternalContext)this.internalContext));
    }

    @Test
    public void testOptionsEmptyLastValue() {
        ImmutableMap options = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"");
        TransformStack.setInitialTransformRequestOptions((InternalContext)this.internalContext, (Map)options);
        Assertions.assertEquals((Object)options, (Object)TransformStack.getInitialTransformRequestOptions((InternalContext)this.internalContext));
    }

    @Test
    public void testSourceReference() {
        Assertions.assertEquals((Object)this.sourceReference, (Object)TransformStack.getInitialSourceReference((InternalContext)this.internalContext));
    }

    @Test
    public void testSourceReferenceNull() {
        TransformStack.setInitialSourceReference((InternalContext)this.internalContext, null);
        Assertions.assertEquals(null, (Object)TransformStack.getInitialSourceReference((InternalContext)this.internalContext));
    }

    @Test
    public void testSourceReferenceBlank() {
        TransformStack.setInitialSourceReference((InternalContext)this.internalContext, (String)"");
        Assertions.assertEquals((Object)"", (Object)TransformStack.getInitialSourceReference((InternalContext)this.internalContext));
    }

    @Test
    public void testLevelBuilder() {
        Assertions.assertEquals((Object)"P\u23d01\u23d00\u23d00\u23d0pipeline 1-N\u23d0type1\u23d0typeN", (Object)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"top")).build());
        Assertions.assertEquals((Object)"P\u23d01\u23d00\u23d00\u23d0failover 3-N\u23d0type3\u23d0typeN\u23d0pipeline 2-3\u23d0type2\u23d0type3\u23d0transform1-2\u23d0type1\u23d0type2", (Object)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"pipeline 1-N")).build());
        Assertions.assertEquals((Object)"F\u23d01\u23d00\u23d00\u23d0pipeline 3-Nc\u23d0type3\u23d0typeN\u23d0transform3-Nb\u23d0type3\u23d0typeN\u23d0transform3-Na\u23d0type3\u23d0typeN", (Object)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"failover 3-N")).build());
    }

    @Test
    public void testAttemptedRetries() {
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"top")));
        Assertions.assertEquals((int)0, (int)TransformStack.getAttemptedRetries((InternalContext)this.internalContext));
        TransformStack.incrementAttemptedRetries((InternalContext)this.internalContext);
        Assertions.assertEquals((int)1, (int)TransformStack.getAttemptedRetries((InternalContext)this.internalContext));
        TransformStack.incrementAttemptedRetries((InternalContext)this.internalContext);
        Assertions.assertEquals((int)2, (int)TransformStack.getAttemptedRetries((InternalContext)this.internalContext));
        TransformStack.resetAttemptedRetries((InternalContext)this.internalContext);
        Assertions.assertEquals((int)0, (int)TransformStack.getAttemptedRetries((InternalContext)this.internalContext));
    }

    @Test
    public void testReference() {
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"top")));
        Assertions.assertEquals((Object)"1", (Object)TransformStack.getReference((InternalContext)this.internalContext));
        TransformStack.setReference((InternalContext)this.internalContext, (String)"123");
        Assertions.assertEquals((Object)"123", (Object)TransformStack.getReference((InternalContext)this.internalContext));
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"pipeline 1-N")));
        Assertions.assertEquals((Object)"123.1", (Object)TransformStack.getReference((InternalContext)this.internalContext));
        TransformStack.incrementReference((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"123.2", (Object)TransformStack.getReference((InternalContext)this.internalContext));
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"pipeline 2-3")));
        Assertions.assertEquals((Object)"123.2.1", (Object)TransformStack.getReference((InternalContext)this.internalContext));
        TransformStack.removeTransformLevel((InternalContext)this.internalContext);
        TransformStack.incrementReference((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"123.3", (Object)TransformStack.getReference((InternalContext)this.internalContext));
        TransformStack.removeTransformLevel((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"123", (Object)TransformStack.getReference((InternalContext)this.internalContext));
    }

    @Test
    public void testSetReferenceInADummyTopLevelIfUnset() {
        this.internalContext.getMultiStep().setTransformsToBeDone(new ArrayList());
        TransformStack.setReferenceInADummyTopLevelIfUnset((InternalContext)this.internalContext, (String)"23");
        Assertions.assertEquals((Object)"23", (Object)TransformStack.getReference((InternalContext)this.internalContext));
    }

    @Test
    public void testReplicateWorkflowWithSuccess() {
        this.replicateWorkflowStepsPriorToFailureOrSuccess();
        TransformStack.removeSuccessfulStep((TransformReply)this.reply, (TransformerDebug)this.transformerDebug);
        Assertions.assertTrue((boolean)TransformStack.isFinished((InternalContext)this.internalContext));
    }

    @Test
    public void testReplicateWorkflowWithFailure() {
        this.replicateWorkflowStepsPriorToFailureOrSuccess();
        int removedLevels = 0;
        while (!TransformStack.isParentAFailover((InternalContext)this.internalContext)) {
            ++removedLevels;
            TransformStack.removeTransformLevel((InternalContext)this.internalContext);
        }
        Assertions.assertEquals((int)2, (int)removedLevels);
        Assertions.assertTrue((boolean)TransformStack.isLastStepInTransformLevel((InternalContext)this.internalContext));
        TransformStack.removeFailedStep((TransformReply)this.reply, (TransformerDebug)this.transformerDebug);
        Assertions.assertTrue((boolean)TransformStack.isFinished((InternalContext)this.internalContext));
    }

    private void replicateWorkflowStepsPriorToFailureOrSuccess() {
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"top")));
        Assertions.assertFalse((boolean)TransformStack.isFinished((InternalContext)this.internalContext));
        TransformStack.Step step = TransformStack.currentStep((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"pipeline 1-N", (Object)step.getTransformerName());
        Assertions.assertEquals((Object)"type1", (Object)step.getSourceMediaType());
        Assertions.assertEquals((Object)"typeN", (Object)step.getTargetMediaType());
        Assertions.assertEquals(null, (Object)TransformStack.getParentName((InternalContext)this.internalContext));
        Assertions.assertFalse((boolean)TransformStack.isParentAFailover((InternalContext)this.internalContext));
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"pipeline 1-N")));
        Assertions.assertFalse((boolean)TransformStack.isFinished((InternalContext)this.internalContext));
        step = TransformStack.currentStep((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"transform1-2", (Object)step.getTransformerName());
        Assertions.assertEquals((Object)"type1", (Object)step.getSourceMediaType());
        Assertions.assertEquals((Object)"type2", (Object)step.getTargetMediaType());
        Assertions.assertEquals((Object)"pipeline 1-N", (Object)TransformStack.getParentName((InternalContext)this.internalContext));
        Assertions.assertFalse((boolean)TransformStack.isParentAFailover((InternalContext)this.internalContext));
        TransformStack.removeSuccessfulStep((TransformReply)this.reply, (TransformerDebug)this.transformerDebug);
        Assertions.assertFalse((boolean)TransformStack.isFinished((InternalContext)this.internalContext));
        step = TransformStack.currentStep((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"pipeline 2-3", (Object)step.getTransformerName());
        Assertions.assertEquals((Object)"type2", (Object)step.getSourceMediaType());
        Assertions.assertEquals((Object)"type3", (Object)step.getTargetMediaType());
        Assertions.assertEquals((Object)"pipeline 1-N", (Object)TransformStack.getParentName((InternalContext)this.internalContext));
        Assertions.assertFalse((boolean)TransformStack.isParentAFailover((InternalContext)this.internalContext));
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"pipeline 2-3")));
        Assertions.assertFalse((boolean)TransformStack.isFinished((InternalContext)this.internalContext));
        step = TransformStack.currentStep((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"transform2-4", (Object)step.getTransformerName());
        Assertions.assertEquals((Object)"type2", (Object)step.getSourceMediaType());
        Assertions.assertEquals((Object)"type4", (Object)step.getTargetMediaType());
        Assertions.assertEquals((Object)"pipeline 2-3", (Object)TransformStack.getParentName((InternalContext)this.internalContext));
        Assertions.assertFalse((boolean)TransformStack.isParentAFailover((InternalContext)this.internalContext));
        TransformStack.removeSuccessfulStep((TransformReply)this.reply, (TransformerDebug)this.transformerDebug);
        Assertions.assertFalse((boolean)TransformStack.isFinished((InternalContext)this.internalContext));
        step = TransformStack.currentStep((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"transform4-3", (Object)step.getTransformerName());
        Assertions.assertEquals((Object)"type4", (Object)step.getSourceMediaType());
        Assertions.assertEquals((Object)"type3", (Object)step.getTargetMediaType());
        Assertions.assertEquals((Object)"pipeline 2-3", (Object)TransformStack.getParentName((InternalContext)this.internalContext));
        Assertions.assertFalse((boolean)TransformStack.isParentAFailover((InternalContext)this.internalContext));
        TransformStack.removeSuccessfulStep((TransformReply)this.reply, (TransformerDebug)this.transformerDebug);
        Assertions.assertFalse((boolean)TransformStack.isFinished((InternalContext)this.internalContext));
        step = TransformStack.currentStep((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"failover 3-N", (Object)step.getTransformerName());
        Assertions.assertEquals((Object)"type3", (Object)step.getSourceMediaType());
        Assertions.assertEquals((Object)"typeN", (Object)step.getTargetMediaType());
        Assertions.assertEquals((Object)"pipeline 1-N", (Object)TransformStack.getParentName((InternalContext)this.internalContext));
        Assertions.assertFalse((boolean)TransformStack.isParentAFailover((InternalContext)this.internalContext));
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"failover 3-N")));
        step = TransformStack.currentStep((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"transform3-Na", (Object)step.getTransformerName());
        Assertions.assertEquals((Object)"type3", (Object)step.getSourceMediaType());
        Assertions.assertEquals((Object)"typeN", (Object)step.getTargetMediaType());
        Assertions.assertEquals((Object)"failover 3-N", (Object)TransformStack.getParentName((InternalContext)this.internalContext));
        Assertions.assertTrue((boolean)TransformStack.isParentAFailover((InternalContext)this.internalContext));
        while (!TransformStack.isParentAFailover((InternalContext)this.internalContext)) {
            TransformStack.removeTransformLevel((InternalContext)this.internalContext);
        }
        Assertions.assertFalse((boolean)TransformStack.isLastStepInTransformLevel((InternalContext)this.internalContext));
        TransformStack.removeFailedStep((TransformReply)this.reply, (TransformerDebug)this.transformerDebug);
        Assertions.assertFalse((boolean)TransformStack.isFinished((InternalContext)this.internalContext));
        step = TransformStack.currentStep((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"transform3-Nb", (Object)step.getTransformerName());
        Assertions.assertEquals((Object)"type3", (Object)step.getSourceMediaType());
        Assertions.assertEquals((Object)"typeN", (Object)step.getTargetMediaType());
        Assertions.assertEquals((Object)"failover 3-N", (Object)TransformStack.getParentName((InternalContext)this.internalContext));
        Assertions.assertTrue((boolean)TransformStack.isParentAFailover((InternalContext)this.internalContext));
        while (!TransformStack.isParentAFailover((InternalContext)this.internalContext)) {
            TransformStack.removeTransformLevel((InternalContext)this.internalContext);
        }
        Assertions.assertFalse((boolean)TransformStack.isLastStepInTransformLevel((InternalContext)this.internalContext));
        TransformStack.removeFailedStep((TransformReply)this.reply, (TransformerDebug)this.transformerDebug);
        Assertions.assertFalse((boolean)TransformStack.isFinished((InternalContext)this.internalContext));
        step = TransformStack.currentStep((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"pipeline 3-Nc", (Object)step.getTransformerName());
        Assertions.assertEquals((Object)"type3", (Object)step.getSourceMediaType());
        Assertions.assertEquals((Object)"typeN", (Object)step.getTargetMediaType());
        Assertions.assertEquals((Object)"failover 3-N", (Object)TransformStack.getParentName((InternalContext)this.internalContext));
        Assertions.assertTrue((boolean)TransformStack.isParentAFailover((InternalContext)this.internalContext));
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"pipeline 3-Nc")));
        Assertions.assertFalse((boolean)TransformStack.isFinished((InternalContext)this.internalContext));
        step = TransformStack.currentStep((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"transform3-5", (Object)step.getTransformerName());
        Assertions.assertEquals((Object)"type3", (Object)step.getSourceMediaType());
        Assertions.assertEquals((Object)"type5", (Object)step.getTargetMediaType());
        Assertions.assertEquals((Object)"pipeline 3-Nc", (Object)TransformStack.getParentName((InternalContext)this.internalContext));
        Assertions.assertFalse((boolean)TransformStack.isParentAFailover((InternalContext)this.internalContext));
        TransformStack.removeSuccessfulStep((TransformReply)this.reply, (TransformerDebug)this.transformerDebug);
        Assertions.assertFalse((boolean)TransformStack.isFinished((InternalContext)this.internalContext));
        step = TransformStack.currentStep((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"pipeline 5-N", (Object)step.getTransformerName());
        Assertions.assertEquals((Object)"type5", (Object)step.getSourceMediaType());
        Assertions.assertEquals((Object)"typeN", (Object)step.getTargetMediaType());
        Assertions.assertEquals((Object)"pipeline 3-Nc", (Object)TransformStack.getParentName((InternalContext)this.internalContext));
        Assertions.assertFalse((boolean)TransformStack.isParentAFailover((InternalContext)this.internalContext));
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"pipeline 5-N")));
        Assertions.assertFalse((boolean)TransformStack.isFinished((InternalContext)this.internalContext));
        step = TransformStack.currentStep((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"transform5-6", (Object)step.getTransformerName());
        Assertions.assertEquals((Object)"type5", (Object)step.getSourceMediaType());
        Assertions.assertEquals((Object)"type6", (Object)step.getTargetMediaType());
        Assertions.assertEquals((Object)"pipeline 5-N", (Object)TransformStack.getParentName((InternalContext)this.internalContext));
        Assertions.assertFalse((boolean)TransformStack.isParentAFailover((InternalContext)this.internalContext));
        TransformStack.removeSuccessfulStep((TransformReply)this.reply, (TransformerDebug)this.transformerDebug);
        Assertions.assertFalse((boolean)TransformStack.isFinished((InternalContext)this.internalContext));
        step = TransformStack.currentStep((InternalContext)this.internalContext);
        Assertions.assertEquals((Object)"transform6-N", (Object)step.getTransformerName());
        Assertions.assertEquals((Object)"type6", (Object)step.getSourceMediaType());
        Assertions.assertEquals((Object)"typeN", (Object)step.getTargetMediaType());
        Assertions.assertEquals((Object)"pipeline 5-N", (Object)TransformStack.getParentName((InternalContext)this.internalContext));
        Assertions.assertFalse((boolean)TransformStack.isParentAFailover((InternalContext)this.internalContext));
    }

    @Test
    public void testWorkflowWithLoop() {
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"top")));
        int transformStepCount = 0;
        do {
            TransformStack.Step step = TransformStack.currentStep((InternalContext)this.internalContext);
            String transformerName = step.getTransformerName();
            int depth = this.internalContext.getMultiStep().getTransformsToBeDone().size() - 2;
            System.out.println(++transformStepCount + "           ".substring(0, depth * 2 + 1) + transformerName);
            TransformStack.LevelBuilder nextLevel = (TransformStack.LevelBuilder)TEST_LEVELS.get((Object)transformerName);
            if (nextLevel == null) {
                TransformStack.removeSuccessfulStep((TransformReply)this.reply, (TransformerDebug)this.transformerDebug);
            } else {
                TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)nextLevel);
            }
            if (transformStepCount < 25) continue;
            Assertions.fail((String)"Appear to be in an infinite loop");
        } while (!TransformStack.isFinished((InternalContext)this.internalContext));
        Assertions.assertEquals((int)7, (int)transformStepCount);
    }

    @Test
    public void testCheckStructureNoOptions() {
        this.internalContext.getMultiStep().setTransformsToBeDone(new ArrayList());
        Assertions.assertEquals((Object)"T-Reply InternalContext did not have the Stack set", (Object)TransformStack.checkStructure((InternalContext)this.internalContext, (String)"T-Reply"));
    }

    @Test
    public void testCheckStructureNoSourceRef() {
        this.internalContext.getMultiStep().setTransformsToBeDone(new ArrayList());
        TransformStack.setInitialTransformRequestOptions((InternalContext)this.internalContext, this.options);
        Assertions.assertEquals((Object)"T-Request InternalContext did not have the Stack set", (Object)TransformStack.checkStructure((InternalContext)this.internalContext, (String)"T-Request"));
    }

    @Test
    public void testCheckStructureNoStack() {
        this.internalContext.getMultiStep().setTransformsToBeDone(new ArrayList());
        TransformStack.setInitialTransformRequestOptions((InternalContext)this.internalContext, this.options);
        TransformStack.setInitialSourceReference((InternalContext)this.internalContext, (String)this.sourceReference);
        Assertions.assertEquals((Object)"T-something InternalContext did not have the Stack set", (Object)TransformStack.checkStructure((InternalContext)this.internalContext, (String)"T-something"));
    }

    @Test
    public void testCheckStructureOptionsOk() {
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"top")));
        for (String value : Arrays.asList("", "key1\u23d0value1", "key1\u23d0value1\u23d0key2\u23d0value2")) {
            System.out.println("TransformOptions   value: " + value);
            this.internalContext.getMultiStep().getTransformsToBeDone().set(0, value);
            Assertions.assertNull((Object)TransformStack.checkStructure((InternalContext)this.internalContext, (String)"T-Reply"));
            TransformStack.getInitialTransformRequestOptions((InternalContext)this.internalContext);
        }
    }

    @Test
    public void testCheckStructureOptionsBad() {
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"top")));
        for (String value : Arrays.asList(null, "noValue", "\u23d0noKey", "key\u23d0value\u23d0noKey")) {
            System.out.println("TransformOptions   value: " + value);
            this.internalContext.getMultiStep().getTransformsToBeDone().set(0, value);
            Assertions.assertEquals((Object)"T-Reply InternalContext did not have the TransformOptions set correctly", (Object)TransformStack.checkStructure((InternalContext)this.internalContext, (String)"T-Reply"));
        }
    }

    @Test
    public void testCheckStructureStackLevelsOk() {
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"top")));
        for (String value : Arrays.asList("P\u23d020\u23d0" + START + "\u23d01" + STEP, "P\u23d04\u23d0123\u23d012" + STEP + STEP)) {
            System.out.println("TransformLevel   value: " + value);
            this.internalContext.getMultiStep().getTransformsToBeDone().set(2, value);
            Assertions.assertNull((Object)TransformStack.checkStructure((InternalContext)this.internalContext, (String)"T-Reply"));
            TransformStack.currentStep((InternalContext)this.internalContext);
        }
    }

    @Test
    public void testCheckStructureStackLevelsOkWithLeadingE() {
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"top")));
        for (String value : Arrays.asList("P\u23d0e20\u23d0" + START + "\u23d01" + STEP)) {
            System.out.println("TransformLevel   value: " + value);
            this.internalContext.getMultiStep().getTransformsToBeDone().set(2, value);
            Assertions.assertNull((Object)TransformStack.checkStructure((InternalContext)this.internalContext, (String)"T-Reply"));
        }
    }

    @Test
    public void testCheckStructureStackLevelsFailWithLeadingX() {
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"top")));
        for (String value : Arrays.asList("P\u23d0x20\u23d0" + START + "\u23d01" + STEP)) {
            System.out.println("TransformLevel   value: " + value);
            this.internalContext.getMultiStep().getTransformsToBeDone().set(2, value);
            Assertions.assertEquals((Object)"T-Reply InternalContext did not have levels set correctly", (Object)TransformStack.checkStructure((InternalContext)this.internalContext, (String)"T-Reply"));
        }
    }

    @Test
    public void testCheckStructureStackLevelsBad() {
        TransformStack.addTransformLevel((InternalContext)this.internalContext, (TransformStack.LevelBuilder)((TransformStack.LevelBuilder)TEST_LEVELS.get((Object)"top")));
        String MAX_INT_PLUS_1 = BigInteger.valueOf(Integer.MIN_VALUE).toString();
        String MAX_LONG_PLUS_1 = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE).toString();
        for (String value : Arrays.asList(null, "", "F\u23d012\u23d0" + START + "\u23d02", "F\u23d0-1\u23d0" + START + "\u23d02" + STEP, "F\u23d01\u23d0-3\u23d02" + STEP, "F\u23d01\u23d0" + START + "\u23d0-2" + STEP, "F\u23d0a\u23d0" + START + "\u23d0-2" + STEP, "F\u23d01\u23d0" + START + "\u23d0b" + STEP, "P\u23d00\u23d0" + START + "\u23d012\u23d0name", "P\u23d00\u23d0" + START + "\u23d012\u23d0name\u23d0source", "P\u23d00\u23d0" + START + "\u23d012\u23d0name\u23d0source\u23d0", "P\u23d00\u23d0" + START + "\u23d012\u23d0name\u23d0\u23d0target", "F\u23d0" + MAX_INT_PLUS_1 + "\u23d0" + START + "\u23d02" + STEP, "F\u23d01\u23d0" + MAX_LONG_PLUS_1 + "\u23d02" + STEP, "F\u23d01\u23d0" + START + "\u23d0" + MAX_INT_PLUS_1 + STEP)) {
            System.out.println("TransformLevel   value: " + value);
            this.internalContext.getMultiStep().getTransformsToBeDone().set(2, value);
            Assertions.assertEquals((Object)"T-Reply InternalContext did not have levels set correctly", (Object)TransformStack.checkStructure((InternalContext)this.internalContext, (String)"T-Reply"));
        }
    }
}

