/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.config.reader;

import java.io.IOException;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.reader.TransformConfigReaderFactory;
import org.alfresco.transform.exceptions.TransformException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class TransformConfigResourceReader {
    @Autowired
    ResourceLoader resourceLoader;

    public TransformConfig read(String resourcePath) {
        return this.read(this.resourceLoader.getResource(resourcePath));
    }

    public TransformConfig read(Resource resource) {
        try {
            return TransformConfigReaderFactory.create(resource).load();
        }
        catch (IOException e) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, "Could not read " + resource.getFilename(), (Throwable)e);
        }
    }
}

