/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.client.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.alfresco.transform.client.model.InternalContext;
import org.alfresco.transform.common.ExtensionService;
import org.alfresco.transform.messages.TransformStack;

public class TransformRequest
implements Serializable {
    private String requestId;
    private String sourceReference;
    private String sourceMediaType;
    private Long sourceSize;
    private String sourceExtension;
    private String targetMediaType;
    private String targetExtension;
    private String clientData;
    private int schema;
    private Map<String, String> transformRequestOptions = new HashMap<String, String>();
    private InternalContext internalContext;

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getSourceReference() {
        return this.sourceReference;
    }

    public void setSourceReference(String sourceReference) {
        this.sourceReference = sourceReference;
    }

    public String getSourceMediaType() {
        return this.sourceMediaType;
    }

    public void setSourceMediaType(String sourceMediaType) {
        this.sourceMediaType = sourceMediaType;
    }

    public Long getSourceSize() {
        return this.sourceSize;
    }

    public void setSourceSize(Long sourceSize) {
        this.sourceSize = sourceSize;
    }

    public String getSourceExtension() {
        return this.sourceExtension;
    }

    public void setSourceExtension(String sourceExtension) {
        this.sourceExtension = sourceExtension;
    }

    public String getTargetMediaType() {
        return this.targetMediaType;
    }

    public void setTargetMediaType(String targetMediaType) {
        this.targetMediaType = targetMediaType;
    }

    public String getTargetExtension() {
        return this.targetExtension;
    }

    public void setTargetExtension(String targetExtension) {
        this.targetExtension = targetExtension;
    }

    public String getClientData() {
        return this.clientData;
    }

    public void setClientData(String clientData) {
        this.clientData = clientData;
    }

    public int getSchema() {
        return this.schema;
    }

    public void setSchema(int schema) {
        this.schema = schema;
    }

    public Map<String, String> getTransformRequestOptions() {
        return this.transformRequestOptions;
    }

    public void setTransformRequestOptions(Map<String, String> transformRequestOptions) {
        this.transformRequestOptions = transformRequestOptions;
    }

    public InternalContext getInternalContext() {
        return this.internalContext;
    }

    public void setInternalContext(InternalContext internalContext) {
        this.internalContext = internalContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformRequest that = (TransformRequest)o;
        return Objects.equals(this.requestId, that.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.requestId);
    }

    public String toString() {
        return "TransformRequest{requestId='" + this.requestId + "', sourceReference='" + this.sourceReference + "', sourceMediaType='" + this.sourceMediaType + "', sourceSize=" + this.sourceSize + ", sourceExtension='" + this.sourceExtension + "', targetMediaType='" + this.targetMediaType + "', targetExtension='" + this.targetExtension + "', clientData='" + this.clientData + "', schema=" + this.schema + ", transformRequestOptions=" + String.valueOf(this.transformRequestOptions) + ", internalContext=" + String.valueOf(this.internalContext) + "}";
    }

    public TransformRequest initialiseContextWhenReceivedByRouter() {
        this.setInternalContext(InternalContext.initialise(this.getInternalContext()));
        this.setTargetExtension(ExtensionService.getExtensionForTargetMimetype(this.getTargetMediaType(), this.getSourceMediaType()));
        this.getInternalContext().getMultiStep().setInitialRequestId(this.getRequestId());
        this.getInternalContext().getMultiStep().setInitialSourceMediaType(this.getSourceMediaType());
        this.getInternalContext().setTransformRequestOptions(this.getTransformRequestOptions());
        TransformStack.setInitialTransformRequestOptions(this.getInternalContext(), this.getTransformRequestOptions());
        TransformStack.setInitialSourceReference(this.getInternalContext(), this.getSourceReference());
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final TransformRequest request = new TransformRequest();

        private Builder() {
        }

        public Builder withRequestId(String requestId) {
            this.request.requestId = requestId;
            return this;
        }

        public Builder withInternalContext(InternalContext internalContext) {
            this.request.internalContext = internalContext;
            return this;
        }

        public Builder withSourceReference(String sourceReference) {
            this.request.sourceReference = sourceReference;
            return this;
        }

        public Builder withSourceMediaType(String sourceMediaType) {
            this.request.sourceMediaType = sourceMediaType;
            return this;
        }

        public Builder withSourceSize(Long sourceSize) {
            this.request.sourceSize = sourceSize;
            return this;
        }

        public Builder withSourceExtension(String sourceExtension) {
            this.request.sourceExtension = sourceExtension;
            return this;
        }

        public Builder withTargetMediaType(String targetMediaType) {
            this.request.targetMediaType = targetMediaType;
            return this;
        }

        public Builder withTargetExtension(String targetExtension) {
            this.request.targetExtension = targetExtension;
            return this;
        }

        public Builder withClientData(String clientData) {
            this.request.clientData = clientData;
            return this;
        }

        public Builder withTransformRequestOptions(Map<String, String> transformRequestOptions) {
            this.request.transformRequestOptions = transformRequestOptions;
            return this;
        }

        public Builder withSchema(int schema) {
            this.request.schema = schema;
            return this;
        }

        public Builder withInternalContextForTransformEngineTests() {
            this.request.initialiseContextWhenReceivedByRouter();
            TransformStack.addTransformLevel(this.request.internalContext, TransformStack.levelBuilder("P").withStep("dummyTransformerName", this.request.sourceMediaType, this.request.targetMediaType));
            return this;
        }

        public TransformRequest build() {
            return this.request;
        }
    }
}

