/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.registry;

import java.util.Objects;
import java.util.Set;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.TransformOptionGroup;

public class SupportedTransform {
    private final TransformOptionGroup transformOptions;
    private final long maxSourceSizeBytes;
    private final String name;
    private final int priority;

    SupportedTransform(String name, Set<TransformOption> transformOptions, long maxSourceSizeBytes, int priority) {
        this.transformOptions = new TransformOptionGroup(true, transformOptions);
        this.maxSourceSizeBytes = maxSourceSizeBytes;
        this.name = name;
        this.priority = priority;
    }

    public TransformOptionGroup getTransformOptions() {
        return this.transformOptions;
    }

    public long getMaxSourceSizeBytes() {
        return this.maxSourceSizeBytes;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportedTransform that = (SupportedTransform)o;
        return this.maxSourceSizeBytes == that.maxSourceSizeBytes && this.priority == that.priority && Objects.equals(this.transformOptions, that.transformOptions) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.transformOptions, this.maxSourceSizeBytes, this.name, this.priority);
    }

    public String toString() {
        return this.name + ":" + this.maxSourceSizeBytes + ":" + this.priority;
    }
}

