/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.common;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.StringJoiner;
import org.alfresco.transform.client.model.InternalContext;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.alfresco.transform.common.RepositoryClientData;
import org.alfresco.transform.common.TransformerDebug;
import org.alfresco.transform.messages.TransformStack;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;

class TransformerDebugTest {
    private static String MIMETYPE_PDF = "application/pdf";
    TransformerDebug transformerDebug = new TransformerDebug();
    private StringJoiner transformerDebugOutput = new StringJoiner("\n");

    TransformerDebugTest() {
    }

    public String getTransformerDebugOutput() {
        return this.transformerDebugOutput.toString().replaceAll(" [\\d,]+ ms", " -- ms");
    }

    private void twoStepTransform(boolean isTRouter, boolean fail, Level logLevel, String renditionName, long sourceSize) {
        this.transformerDebug.setIsTRouter(isTRouter);
        this.monitorLogs(logLevel);
        TransformRequest request = TransformRequest.builder().withSourceSize(Long.valueOf(sourceSize)).withInternalContext(InternalContext.initialise(null)).withClientData(RepositoryClientData.builder().withRenditionName(renditionName).build().toString()).build();
        TransformStack.setInitialSourceReference((InternalContext)request.getInternalContext(), (String)"fileRef");
        TransformReply reply = TransformReply.builder().withInternalContext(request.getInternalContext()).build();
        TransformStack.addTransformLevel((InternalContext)request.getInternalContext(), (TransformStack.LevelBuilder)TransformStack.levelBuilder((String)"P").withStep("wrapper", "text/plain", MIMETYPE_PDF));
        this.transformerDebug.pushTransform(request);
        TransformStack.addTransformLevel((InternalContext)request.getInternalContext(), (TransformStack.LevelBuilder)TransformStack.levelBuilder((String)"P").withStep("transformer1", "text/plain", "application/msword").withStep("transformer2", "application/msword", MIMETYPE_PDF));
        this.transformerDebug.pushTransform(request);
        this.transformerDebug.logOptions(request);
        TransformStack.removeSuccessfulStep((TransformReply)reply, (TransformerDebug)this.transformerDebug);
        request.setTransformRequestOptions((Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2"));
        this.transformerDebug.pushTransform(request);
        this.transformerDebug.logOptions(request);
        if (fail) {
            reply.setErrorDetails("Dummy error");
            this.transformerDebug.logFailure(reply);
        } else {
            TransformStack.removeSuccessfulStep((TransformReply)reply, (TransformerDebug)this.transformerDebug);
            TransformStack.removeTransformLevel((InternalContext)reply.getInternalContext());
        }
    }

    private void monitorLogs(Level logLevel) {
        Logger logger = (Logger)LoggerFactory.getLogger(TransformerDebug.class);
        AppenderBase<ILoggingEvent> logAppender = new AppenderBase<ILoggingEvent>(){

            protected void append(ILoggingEvent iLoggingEvent) {
                TransformerDebugTest.this.transformerDebugOutput.add(iLoggingEvent.getMessage());
            }
        };
        logAppender.setContext((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
        logger.setLevel(logLevel);
        logger.addAppender((Appender)logAppender);
        logAppender.start();
    }

    @Test
    void testRouterTwoStepTransform() {
        this.twoStepTransform(true, false, Level.DEBUG, "", 1234L);
        Assertions.assertEquals((Object)"1                 txt  pdf   1.2 KB wrapper\n1.1               txt  doc   transformer1\n1.2               doc  pdf   transformer2\n1.2                 k1=\"v1\"\n1.2                 k2=\"v2\"\n1                 Finished in -- ms", (Object)this.getTransformerDebugOutput());
    }

    @Test
    void testRouterTwoStepTransformWithTrace() {
        this.twoStepTransform(true, false, Level.TRACE, "", 1234L);
        Assertions.assertEquals((Object)"1                 txt  pdf   1.2 KB wrapper\n1.1               txt  doc   transformer1\n1.1               Finished in -- ms\n1.2               doc  pdf   transformer2\n1.2                 k1=\"v1\"\n1.2                 k2=\"v2\"\n1.2               Finished in -- ms\n1                 Finished in -- ms", (Object)this.getTransformerDebugOutput());
    }

    @Test
    void testEngineTwoStepTransform() {
        this.twoStepTransform(false, false, Level.DEBUG, "", 1234L);
        Assertions.assertEquals((Object)"1                 txt  pdf   1.2 KB wrapper\n1.1               txt  doc   1.2 KB transformer1\n1.1               Finished in -- ms\n1.2               doc  pdf   1.2 KB transformer2\n1.2                 k1=\"v1\"\n1.2                 k2=\"v2\"\n1.2               Finished in -- ms\n1                 Finished in -- ms", (Object)this.getTransformerDebugOutput());
    }

    @Test
    void testRouterTwoStepTransformWithFailure() {
        this.twoStepTransform(true, true, Level.DEBUG, "", 1234L);
        Assertions.assertEquals((Object)"1                 txt  pdf   1.2 KB wrapper\n1.1               txt  doc   transformer1\n1.2               doc  pdf   transformer2\n1.2                 k1=\"v1\"\n1.2                 k2=\"v2\"\n1.2               Dummy error", (Object)this.getTransformerDebugOutput());
    }

    @Test
    void testRenditionName() {
        this.twoStepTransform(true, false, Level.DEBUG, "renditionName", 1234L);
        Assertions.assertEquals((Object)"1                 txt  pdf   1.2 KB -- renditionName -- wrapper\n1.1               txt  doc   transformer1\n1.2               doc  pdf   transformer2\n1.2                 k1=\"v1\"\n1.2                 k2=\"v2\"\n1                 Finished in -- ms", (Object)this.getTransformerDebugOutput());
    }

    @Test
    void testMetadataExtract() {
        this.twoStepTransform(true, false, Level.DEBUG, "transform:alfresco-metadata-extract", 1234L);
        Assertions.assertEquals((Object)"1                 txt  pdf   1.2 KB -- metadataExtract -- wrapper\n1.1               txt  doc   transformer1\n1.2               doc  pdf   transformer2\n1.2                 k1=\"v1\"\n1.2                 k2=\"v2\"\n1                 Finished in -- ms", (Object)this.getTransformerDebugOutput());
    }

    @Test
    void testMetadataEmbed() {
        this.twoStepTransform(true, false, Level.DEBUG, "transform:alfresco-metadata-embed", 1234L);
        Assertions.assertEquals((Object)"1                 txt  pdf   1.2 KB -- metadataEmbed -- wrapper\n1.1               txt  doc   transformer1\n1.2               doc  pdf   transformer2\n1.2                 k1=\"v1\"\n1.2                 k2=\"v2\"\n1                 Finished in -- ms", (Object)this.getTransformerDebugOutput());
    }

    @Test
    void testSourceSize1Byte() {
        this.twoStepTransform(true, false, Level.DEBUG, "", 1L);
        Assertions.assertEquals((Object)"1                 txt  pdf   1 byte wrapper\n1.1               txt  doc   transformer1\n1.2               doc  pdf   transformer2\n1.2                 k1=\"v1\"\n1.2                 k2=\"v2\"\n1                 Finished in -- ms", (Object)this.getTransformerDebugOutput());
    }

    @Test
    void testSourceSize23TB() {
        this.twoStepTransform(true, false, Level.DEBUG, "", 0x170000000000L);
        Assertions.assertEquals((Object)"1                 txt  pdf   23 TB wrapper\n1.1               txt  doc   transformer1\n1.2               doc  pdf   transformer2\n1.2                 k1=\"v1\"\n1.2                 k2=\"v2\"\n1                 Finished in -- ms", (Object)this.getTransformerDebugOutput());
    }

    @Test
    void testLogFailureOnTEngine() {
        this.monitorLogs(Level.TRACE);
        String origClientData = RepositoryClientData.builder().build().toString();
        TransformReply reply = TransformReply.builder().withInternalContext(InternalContext.initialise(null)).withErrorDetails("T-Request was null - a major error").withClientData(origClientData).build();
        this.transformerDebug.setIsTRouter(false);
        this.transformerDebug.logFailure(reply);
        String expectedDebug = "                  T-Request was null - a major error";
        Assertions.assertEquals((Object)expectedDebug, (Object)this.getTransformerDebugOutput());
        Assertions.assertEquals((Object)origClientData, (Object)reply.getClientData());
    }

    @Test
    void testLogFailureOnTRouter() {
        this.monitorLogs(Level.TRACE);
        String origClientData = RepositoryClientData.builder().withDebug().build().toString();
        TransformReply reply = TransformReply.builder().withInternalContext(InternalContext.initialise(null)).withErrorDetails("T-Request was null - a major error").withClientData(origClientData).build();
        this.transformerDebug.setIsTRouter(true);
        this.transformerDebug.logFailure(reply);
        String expectedDebug = "                  T-Request was null - a major error";
        String expectedClientData = origClientData + "\u23d1" + expectedDebug;
        Assertions.assertEquals((Object)expectedDebug, (Object)this.getTransformerDebugOutput());
        Assertions.assertEquals((Object)expectedClientData, (Object)reply.getClientData());
    }

    @Test
    void tesGetOptionAndValue() {
        String sixtyChars = "12345678 10 345678 20 345678 30 345678 40 345678 50 abcdefgh";
        String sixtyOneChars = "12345678 10 345678 20 345678 30 345678 40 345678 50 abcd12345";
        String expected = "12345678 10 345678 20 345678 30 345678 40 345678 50 ...12345";
        Assertions.assertEquals((Object)"ref                 key=\"value\"", (Object)this.transformerDebug.getOptionAndValue("ref", "key", "value"));
        Assertions.assertEquals((Object)("ref                 key=\"" + sixtyChars + "\""), (Object)this.transformerDebug.getOptionAndValue("ref", "key", sixtyChars));
        Assertions.assertEquals((Object)("ref                 key=\"" + expected + "\""), (Object)this.transformerDebug.getOptionAndValue("ref", "key", sixtyOneChars));
    }
}

