/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.alfresco.transform.config.AddSupported;
import org.alfresco.transform.config.OverrideSupported;
import org.alfresco.transform.config.RemoveSupported;
import org.alfresco.transform.config.SupportedDefaults;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.Transformer;

public class TransformConfig {
    private Map<String, Set<TransformOption>> transformOptions = new HashMap<String, Set<TransformOption>>();
    private List<Transformer> transformers = new ArrayList<Transformer>();
    private Set<String> removeTransformers = new HashSet<String>();
    private Set<AddSupported> addSupported = new HashSet<AddSupported>();
    private Set<RemoveSupported> removeSupported = new HashSet<RemoveSupported>();
    private Set<OverrideSupported> overrideSupported = new HashSet<OverrideSupported>();
    private Set<SupportedDefaults> supportedDefaults = new HashSet<SupportedDefaults>();

    public Map<String, Set<TransformOption>> getTransformOptions() {
        return this.transformOptions;
    }

    public void setTransformOptions(Map<String, Set<TransformOption>> transformOptions) {
        this.transformOptions = transformOptions == null ? new HashMap<String, Set<TransformOption>>() : new HashMap<String, Set<TransformOption>>(transformOptions);
    }

    public void setRemoveTransformers(Set<String> removeTransformers) {
        this.removeTransformers = removeTransformers == null ? new HashSet() : removeTransformers;
    }

    public void setAddSupported(Set<AddSupported> addSupported) {
        this.addSupported = addSupported == null ? new HashSet() : addSupported;
    }

    public void setRemoveSupported(Set<RemoveSupported> removeSupported) {
        this.removeSupported = removeSupported == null ? new HashSet() : removeSupported;
    }

    public void setOverrideSupported(Set<OverrideSupported> overrideSupported) {
        this.overrideSupported = overrideSupported == null ? new HashSet() : overrideSupported;
    }

    public void setSupportedDefaults(Set<SupportedDefaults> supportedDefaults) {
        this.supportedDefaults = supportedDefaults == null ? new HashSet() : supportedDefaults;
    }

    public List<Transformer> getTransformers() {
        return this.transformers;
    }

    public Set<String> getRemoveTransformers() {
        return this.removeTransformers;
    }

    public Set<AddSupported> getAddSupported() {
        return this.addSupported;
    }

    public Set<RemoveSupported> getRemoveSupported() {
        return this.removeSupported;
    }

    public Set<OverrideSupported> getOverrideSupported() {
        return this.overrideSupported;
    }

    public Set<SupportedDefaults> getSupportedDefaults() {
        return this.supportedDefaults;
    }

    public void setTransformers(List<Transformer> transformers) {
        this.transformers = transformers == null ? new ArrayList() : transformers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformConfig that = (TransformConfig)o;
        return this.transformOptions.equals(that.transformOptions) && this.transformers.equals(that.transformers) && this.removeTransformers.equals(that.removeTransformers) && this.addSupported.equals(that.addSupported) && this.removeSupported.equals(that.removeSupported) && this.overrideSupported.equals(that.overrideSupported) && this.supportedDefaults.equals(that.supportedDefaults);
    }

    public int hashCode() {
        return Objects.hash(this.transformOptions, this.transformers, this.removeTransformers, this.addSupported, this.removeSupported, this.overrideSupported, this.supportedDefaults);
    }

    public String toString() {
        return "TransformConfig{transformOptions=" + String.valueOf(this.transformOptions) + ", transformers=" + String.valueOf(this.transformers) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final TransformConfig transformConfig = new TransformConfig();

        private Builder() {
        }

        public TransformConfig build() {
            return this.transformConfig;
        }

        public Builder withTransformOptions(Map<String, Set<TransformOption>> transformOptions) {
            this.transformConfig.setTransformOptions(transformOptions);
            return this;
        }

        public Builder withTransformers(List<Transformer> transformers) {
            this.transformConfig.transformers = transformers;
            return this;
        }

        public Builder withRemoveTransformers(Set<String> removeTransformers) {
            this.transformConfig.removeTransformers = removeTransformers;
            return this;
        }

        public Builder withAddSupported(Set<AddSupported> addSupported) {
            this.transformConfig.addSupported = addSupported;
            return this;
        }

        public Builder withRemoveSupported(Set<RemoveSupported> removeSupported) {
            this.transformConfig.removeSupported = removeSupported;
            return this;
        }

        public Builder withOverrideSupported(Set<OverrideSupported> overrideSupported) {
            this.transformConfig.overrideSupported = overrideSupported;
            return this;
        }

        public Builder withSupportedDefaults(Set<SupportedDefaults> supportedDefaults) {
            this.transformConfig.supportedDefaults = supportedDefaults;
            return this;
        }
    }
}

