/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.config;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.transform.config.CoreFunction;
import org.alfresco.transform.config.CoreVersionDecorator;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.TransformOptionValue;
import org.alfresco.transform.config.TransformStep;
import org.alfresco.transform.config.Transformer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CoreVersionDecoratorTest {
    private static final int CONFIG_VERSION_ORIGINAL = Integer.valueOf("1");
    private static final String SOME_NAME = "optionName";
    public static final Set<TransformOption> SOME_OPTIONS = Set.of(new TransformOptionValue(false, "someOption"));
    private static final Set<TransformOption> DIRECT_ACCESS_URL_OPTION = Set.of(new TransformOptionValue(false, "directAccessUrl"));
    private static final Set<TransformOption> SOURCE_FILENAME_OPTION = Set.of(new TransformOptionValue(false, "sourceFilename"));
    private final Map<String, Set<TransformOption>> TRANSFORM_OPTIONS_WITHOUT_DIRECT_ACCESS_URL = new HashMap<String, Set<TransformOption>>();
    private final Map<String, Set<TransformOption>> TRANSFORM_OPTIONS_WITH_DIRECT_ACCESS_URL = new HashMap<String, Set<TransformOption>>();
    private final Map<String, Set<TransformOption>> TRANSFORM_OPTIONS_WITHOUT_SOURCE_FILENAME = new HashMap<String, Set<TransformOption>>();
    private final Map<String, Set<TransformOption>> TRANSFORM_OPTIONS_WITH_SOURCE_FILENAME = new HashMap<String, Set<TransformOption>>();

    CoreVersionDecoratorTest() {
        this.TRANSFORM_OPTIONS_WITHOUT_DIRECT_ACCESS_URL.put(SOME_NAME, SOME_OPTIONS);
        this.TRANSFORM_OPTIONS_WITH_DIRECT_ACCESS_URL.put(SOME_NAME, SOME_OPTIONS);
        this.TRANSFORM_OPTIONS_WITH_DIRECT_ACCESS_URL.put("directAccessUrl", DIRECT_ACCESS_URL_OPTION);
        this.TRANSFORM_OPTIONS_WITHOUT_SOURCE_FILENAME.put(SOME_NAME, SOME_OPTIONS);
        this.TRANSFORM_OPTIONS_WITHOUT_SOURCE_FILENAME.put("directAccessUrl", DIRECT_ACCESS_URL_OPTION);
        this.TRANSFORM_OPTIONS_WITH_SOURCE_FILENAME.put(SOME_NAME, SOME_OPTIONS);
        this.TRANSFORM_OPTIONS_WITH_SOURCE_FILENAME.put("directAccessUrl", DIRECT_ACCESS_URL_OPTION);
        this.TRANSFORM_OPTIONS_WITH_SOURCE_FILENAME.put("sourceFilename", SOURCE_FILENAME_OPTION);
    }

    private TransformConfig newTransformConfig(String version1, String version2, String version3, String version4, String version5, boolean hasDirectAccessUrls, boolean multiStepHaveDirectAccessUrls) {
        HashSet<String> transformOptions1 = new HashSet<String>();
        HashSet<String> transformOptions2 = new HashSet<String>(transformOptions1);
        transformOptions2.add(SOME_NAME);
        HashSet<String> transformOptions3 = new HashSet<String>(transformOptions1);
        HashSet<String> transformOptions4 = new HashSet<String>(transformOptions1);
        transformOptions4.addAll(transformOptions2);
        HashSet<String> transformOptions5 = new HashSet<String>(transformOptions1);
        transformOptions5.addAll(transformOptions2);
        transformOptions5.addAll(transformOptions3);
        if (hasDirectAccessUrls) {
            transformOptions1.add("directAccessUrl");
            transformOptions2.add("directAccessUrl");
            transformOptions3.add("directAccessUrl");
        }
        if (multiStepHaveDirectAccessUrls) {
            transformOptions4.add("directAccessUrl");
            transformOptions5.add("directAccessUrl");
        }
        return TransformConfig.builder().withTransformOptions(hasDirectAccessUrls ? this.TRANSFORM_OPTIONS_WITH_DIRECT_ACCESS_URL : this.TRANSFORM_OPTIONS_WITHOUT_DIRECT_ACCESS_URL).withTransformers((List)ImmutableList.of((Object)Transformer.builder().withTransformerName("transformer1").withCoreVersion(version1).withTransformOptions(transformOptions1).build(), (Object)Transformer.builder().withTransformerName("transformer2").withCoreVersion(version2).withTransformOptions(transformOptions2).build(), (Object)Transformer.builder().withTransformerName("transformer3").withCoreVersion(version3).withTransformOptions(transformOptions3).build(), (Object)Transformer.builder().withTransformerName("pipeline4").withCoreVersion(version4).withTransformerPipeline(List.of(new TransformStep("transformer1", "mimetype/c"), new TransformStep("transformer2", null))).withTransformOptions(transformOptions4).build(), (Object)Transformer.builder().withTransformerName("failover5").withCoreVersion(version5).withTransformerFailover(List.of("transformer1", "transformer2", "transformer3")).withTransformOptions(transformOptions5).build())).build();
    }

    @Test
    void setCoreVersionOnSingleStepTransformersTest() {
        TransformConfig transformConfigReadFormTEngineJson = this.newTransformConfig(null, null, null, null, null, false, false);
        CoreVersionDecorator.setCoreVersionOnSingleStepTransformers((TransformConfig)transformConfigReadFormTEngineJson, (String)"2.3.1");
        Assertions.assertEquals((Object)this.newTransformConfig("2.3.1", "2.3.1", "2.3.1", null, null, false, false), (Object)transformConfigReadFormTEngineJson);
        transformConfigReadFormTEngineJson = this.newTransformConfig(null, null, null, null, null, false, false);
        CoreVersionDecorator.setCoreVersionOnSingleStepTransformers((TransformConfig)transformConfigReadFormTEngineJson, (String)"2.5.7");
        Assertions.assertEquals((Object)this.newTransformConfig("2.5.7", "2.5.7", "2.5.7", null, null, true, false), (Object)transformConfigReadFormTEngineJson);
    }

    @Test
    void setCoreVersionOnMultiStepTransformersTest() {
        TransformConfig decoratedSingleStepTransformConfig = this.newTransformConfig("2.1", "2.2", "1.2.3", null, null, false, false);
        CoreVersionDecorator.setCoreVersionOnMultiStepTransformers((Map)decoratedSingleStepTransformConfig.getTransformOptions(), (List)decoratedSingleStepTransformConfig.getTransformers());
        Assertions.assertEquals((Object)this.newTransformConfig("2.1", "2.2", "1.2.3", "2.1", "1.2.3", false, false), (Object)decoratedSingleStepTransformConfig);
        decoratedSingleStepTransformConfig = this.newTransformConfig("2.1", null, null, null, null, false, false);
        CoreVersionDecorator.setCoreVersionOnMultiStepTransformers((Map)decoratedSingleStepTransformConfig.getTransformOptions(), (List)decoratedSingleStepTransformConfig.getTransformers());
        Assertions.assertEquals((Object)this.newTransformConfig("2.1", null, null, null, null, false, false), (Object)decoratedSingleStepTransformConfig);
        decoratedSingleStepTransformConfig = this.newTransformConfig("2.5.7", "2.5.7", "2.5.7", null, null, true, false);
        CoreVersionDecorator.setCoreVersionOnMultiStepTransformers((Map)decoratedSingleStepTransformConfig.getTransformOptions(), (List)decoratedSingleStepTransformConfig.getTransformers());
        Assertions.assertEquals((Object)this.newTransformConfig("2.5.7", "2.5.7", "2.5.7", "2.5.7", "2.5.7", true, true), (Object)decoratedSingleStepTransformConfig);
    }

    @Test
    void setOrClearCoreVersionTest() {
        TransformConfig transformConfigWithCoreVersion = this.newTransformConfig("2.1", "2.2", "1.2.3", "2.1", "1.2.3", false, false);
        Assertions.assertEquals((Object)this.newTransformConfig(null, null, null, null, null, false, false), (Object)CoreVersionDecorator.setOrClearCoreVersion((TransformConfig)transformConfigWithCoreVersion, (int)CONFIG_VERSION_ORIGINAL));
        Assertions.assertEquals((Object)this.newTransformConfig("2.1", "2.2", "1.2.3", "2.1", "1.2.3", false, false), (Object)CoreVersionDecorator.setOrClearCoreVersion((TransformConfig)transformConfigWithCoreVersion, (int)2));
        Assertions.assertEquals((Object)this.newTransformConfig("2.1", "2.2", "1.2.3", "2.1", "1.2.3", false, false), (Object)CoreVersionDecorator.setOrClearCoreVersion((TransformConfig)transformConfigWithCoreVersion, (int)102));
        TransformConfig transformConfigWithoutCoreVersion = this.newTransformConfig(null, null, null, null, null, false, false);
        Assertions.assertEquals((Object)this.newTransformConfig(null, null, null, null, null, false, false), (Object)CoreVersionDecorator.setOrClearCoreVersion((TransformConfig)transformConfigWithoutCoreVersion, (int)CONFIG_VERSION_ORIGINAL));
        Assertions.assertEquals((Object)this.newTransformConfig(null, null, null, null, null, false, false), (Object)CoreVersionDecorator.setOrClearCoreVersion((TransformConfig)transformConfigWithoutCoreVersion, (int)2));
        transformConfigWithCoreVersion = this.newTransformConfig("2.5.7", "2.5.7", "2.5.7", "2.5.7", "2.5.7", true, true);
        Assertions.assertEquals((Object)this.newTransformConfig(null, null, null, null, null, false, false), (Object)CoreVersionDecorator.setOrClearCoreVersion((TransformConfig)transformConfigWithCoreVersion, (int)CONFIG_VERSION_ORIGINAL));
        Assertions.assertEquals((Object)this.newTransformConfig("2.5.7", "2.5.7", "2.5.7", "2.5.7", "2.5.7", true, true), (Object)CoreVersionDecorator.setOrClearCoreVersion((TransformConfig)transformConfigWithCoreVersion, (int)2));
    }

    @Test
    void standardizeCoreVersionTest() {
        Assertions.assertEquals((Object)"2.5.7", (Object)CoreFunction.standardizeCoreVersion((String)"2.5.7"));
        Assertions.assertEquals((Object)"2.5.7", (Object)CoreFunction.standardizeCoreVersion((String)"2.5.7-SNAPSHOT"));
        Assertions.assertEquals((Object)"2", (Object)CoreFunction.standardizeCoreVersion((String)"2"));
        Assertions.assertEquals((Object)"2.5.7", (Object)CoreFunction.standardizeCoreVersion((String)"2.5.7-A-SNAPSHOT"));
    }

    private TransformConfig newTransformConfigForSourceFileName(String version1, String version2, String version3, String version4, String version5, boolean hasSourceFilename, boolean multiStepHaveSourceFilename) {
        HashSet<String> transformOptions1 = new HashSet<String>();
        HashSet<String> transformOptions2 = new HashSet<String>(transformOptions1);
        transformOptions2.add(SOME_NAME);
        HashSet<String> transformOptions3 = new HashSet<String>(transformOptions1);
        HashSet<String> transformOptions4 = new HashSet<String>(transformOptions1);
        transformOptions4.addAll(transformOptions2);
        HashSet<String> transformOptions5 = new HashSet<String>(transformOptions1);
        transformOptions5.addAll(transformOptions2);
        transformOptions5.addAll(transformOptions3);
        transformOptions1.add("directAccessUrl");
        transformOptions2.add("directAccessUrl");
        transformOptions3.add("directAccessUrl");
        transformOptions4.add("directAccessUrl");
        transformOptions5.add("directAccessUrl");
        if (hasSourceFilename) {
            transformOptions1.add("sourceFilename");
            transformOptions2.add("sourceFilename");
            transformOptions3.add("sourceFilename");
        }
        if (multiStepHaveSourceFilename) {
            transformOptions4.add("sourceFilename");
            transformOptions5.add("sourceFilename");
        }
        return TransformConfig.builder().withTransformOptions(hasSourceFilename ? this.TRANSFORM_OPTIONS_WITH_SOURCE_FILENAME : this.TRANSFORM_OPTIONS_WITHOUT_SOURCE_FILENAME).withTransformers((List)ImmutableList.of((Object)Transformer.builder().withTransformerName("transformer1").withCoreVersion(version1).withTransformOptions(transformOptions1).build(), (Object)Transformer.builder().withTransformerName("transformer2").withCoreVersion(version2).withTransformOptions(transformOptions2).build(), (Object)Transformer.builder().withTransformerName("transformer3").withCoreVersion(version3).withTransformOptions(transformOptions3).build(), (Object)Transformer.builder().withTransformerName("pipeline4").withCoreVersion(version4).withTransformerPipeline(List.of(new TransformStep("transformer1", "mimetype/c"), new TransformStep("transformer2", null))).withTransformOptions(transformOptions4).build(), (Object)Transformer.builder().withTransformerName("failover5").withCoreVersion(version5).withTransformerFailover(List.of("transformer1", "transformer2", "transformer3")).withTransformOptions(transformOptions5).build())).build();
    }

    @Test
    void setCoreVersionWithSourceFileNameOptionTest() {
        String sourceFileName = "sourceFilename";
        String sourceFileNameSupport = "5.1.8";
        TransformConfig transformConfig = this.newTransformConfigForSourceFileName(sourceFileNameSupport, sourceFileNameSupport, sourceFileNameSupport, sourceFileNameSupport, sourceFileNameSupport, false, false);
        CoreVersionDecorator.setCoreVersionOnSingleStepTransformers((TransformConfig)transformConfig, (String)sourceFileNameSupport);
        Assertions.assertEquals((Object)this.newTransformConfigForSourceFileName("4.0.0", "4.0.0", "4.0.0", "4.0.0", "4.0.0", false, false), (Object)CoreVersionDecorator.setOrClearCoreVersion((TransformConfig)this.newTransformConfigForSourceFileName("4.0.0", "4.0.0", "4.0.0", "4.0.0", "4.0.0", false, false), (int)2));
        Assertions.assertEquals((Object)this.newTransformConfigForSourceFileName(sourceFileNameSupport, sourceFileNameSupport, sourceFileNameSupport, sourceFileNameSupport, sourceFileNameSupport, true, true), (Object)CoreVersionDecorator.setOrClearCoreVersion((TransformConfig)this.newTransformConfigForSourceFileName(sourceFileNameSupport, sourceFileNameSupport, sourceFileNameSupport, sourceFileNameSupport, sourceFileNameSupport, true, true), (int)2));
    }
}

