/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.config;

import org.apache.maven.artifact.versioning.ComparableVersion;

public enum CoreFunction {
    DIRECT_ACCESS_URL("2.5.7", null),
    ACTIVE_MQ("1", null),
    HTTP(null, "99999"),
    SOURCE_FILENAME("5.1.8", null);

    private final ComparableVersion fromVersion;
    private final ComparableVersion toVersion;

    public boolean isSupported(String version) {
        ComparableVersion comparableVersion = CoreFunction.newComparableVersion(version, Constants.NO_VERSION);
        return comparableVersion.compareTo(this.fromVersion) >= 0 && comparableVersion.compareTo(this.toVersion) <= 0;
    }

    public static String standardizeCoreVersion(String version) {
        return CoreFunction.newComparableVersion(version, Constants.NO_VERSION).toString();
    }

    private CoreFunction(String fromVersion, String toVersion) {
        this.fromVersion = CoreFunction.newComparableVersion(fromVersion, Constants.NO_VERSION);
        this.toVersion = CoreFunction.newComparableVersion(toVersion, Constants.NO_UPPER_VERSION);
    }

    static ComparableVersion newComparableVersion(String version, ComparableVersion defaultValue) {
        if (version == null) {
            return defaultValue;
        }
        int i = version.indexOf(45);
        version = i > 0 ? version.substring(0, i) : version;
        return new ComparableVersion(version);
    }

    static class Constants {
        static final ComparableVersion NO_VERSION = new ComparableVersion("");
        static final ComparableVersion NO_UPPER_VERSION = new ComparableVersion(Integer.toString(Integer.MAX_VALUE));

        Constants() {
        }
    }
}

