/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.messages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.alfresco.transform.client.model.InternalContext;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.common.TransformerDebug;
import org.apache.commons.lang3.StringUtils;

public class TransformStack {
    public static final String PIPELINE_FLAG = "P";
    public static final String FAILOVER_FLAG = "F";
    public static final String SEPARATOR = "\u23d0";
    private static final String SEPARATOR_REGEX = "\u23d0";
    static final int OPTIONS_LEVEL = 0;
    static final int SOURCE_REFERENCE_LEVEL = 1;
    static final int TOP_STACK_LEVEL = 2;
    private static final int FLAG_INDEX = 0;
    private static final int REFERENCE_INDEX = 1;
    private static final int START_INDEX = 2;
    private static final int RETRY_INDEX = 3;
    private static final int FIELDS_IN_HEADER = 4;
    private static final int FIELDS_PER_STEP = 3;

    public static LevelBuilder levelBuilder(String flag) {
        return new LevelBuilder(flag);
    }

    public static void setInitialTransformRequestOptions(InternalContext internalContext, Map<String, String> transformRequestOptions) {
        TransformStack.init(internalContext);
        StringJoiner sj = new StringJoiner("\u23d0");
        transformRequestOptions.forEach((key, value) -> sj.add((CharSequence)key).add((CharSequence)value));
        TransformStack.levels(internalContext).set(0, sj.toString());
    }

    public static void setInitialSourceReference(InternalContext internalContext, String sourceReference) {
        TransformStack.init(internalContext);
        TransformStack.levels(internalContext).set(1, sourceReference);
    }

    public static Map<String, String> getInitialTransformRequestOptions(InternalContext internalContext) {
        HashMap<String, String> transformRequestOptions = new HashMap<String, String>();
        String[] split = (TransformStack.level(internalContext, 0) + " ").split("\u23d0");
        String lastValue = split[split.length - 1];
        split[split.length - 1] = lastValue.substring(0, lastValue.length() - 1);
        for (int i = split.length - 2; i >= 0; i -= 2) {
            transformRequestOptions.put(split[i], split[i + 1]);
        }
        return transformRequestOptions;
    }

    public static String getInitialSourceReference(InternalContext internalContext) {
        return TransformStack.level(internalContext, 1);
    }

    private static List<String> levels(InternalContext internalContext) {
        return internalContext.getMultiStep().getTransformsToBeDone();
    }

    private static String level(InternalContext internalContext, int i) {
        return TransformStack.levels(internalContext).get(i);
    }

    private static void init(InternalContext internalContext) {
        while (TransformStack.levels(internalContext).size() < 2) {
            TransformStack.levels(internalContext).add(null);
        }
    }

    private static String currentLevel(InternalContext internalContext) {
        return TransformStack.parentLevel(internalContext, 0);
    }

    private static String parentLevel(InternalContext internalContext, int parentLevels) {
        List<String> levels = TransformStack.levels(internalContext);
        int i = levels.size() - 1 - parentLevels;
        return i >= 2 ? levels.get(i) : null;
    }

    public static boolean isFinished(InternalContext internalContext) {
        int levelsLeft = TransformStack.levels(internalContext).size() - 2;
        return levelsLeft <= 0 || levelsLeft == 1 && TransformStack.isTransformLevelFinished(internalContext);
    }

    public static void addTransformLevel(InternalContext internalContext, LevelBuilder levelBuilder) {
        TransformStack.levels(internalContext).add(levelBuilder.build());
    }

    public static void setReference(InternalContext internalContext, String requestCountOrClientRequestId) {
        TransformStack.setHeaderField(internalContext, 1, requestCountOrClientRequestId);
    }

    public static void incrementReference(InternalContext internalContext) {
        TransformStack.setHeaderField(internalContext, 1, Integer.toString(TransformStack.getReferenceCounter(internalContext) + 1));
    }

    public static void resetAttemptedRetries(InternalContext internalContext) {
        TransformStack.setHeaderField(internalContext, 3, 0L);
    }

    public static void setStartTime(InternalContext internalContext) {
        TransformStack.setHeaderField(internalContext, 2, System.currentTimeMillis());
    }

    public static void incrementAttemptedRetries(InternalContext internalContext) {
        TransformStack.setHeaderField(internalContext, 3, TransformStack.getAttemptedRetries(internalContext) + 1);
    }

    private static void setHeaderField(InternalContext internalContext, int index, long value) {
        TransformStack.setHeaderField(internalContext, index, Long.toString(value));
    }

    private static void setHeaderField(InternalContext internalContext, int index, String value) {
        List<String> levels = TransformStack.levels(internalContext);
        int size = levels.size();
        String level = levels.get(size - 1);
        int j = TransformStack.indexOfField(level, index);
        int k = level.indexOf("\u23d0", j + 1);
        levels.set(size - 1, level.substring(0, j) + value + level.substring(k));
    }

    public static String getReference(InternalContext internalContext) {
        StringJoiner ref = new StringJoiner(".");
        List<String> levels = TransformStack.levels(internalContext);
        for (int i = 2; i < levels.size(); ++i) {
            ref.add(TransformStack.getHeaderFieldString(levels.get(i), 1));
        }
        return ref.toString();
    }

    public static void setReferenceInADummyTopLevelIfUnset(InternalContext internalContext, String reference) {
        if (!reference.isBlank() && TransformStack.getReference(internalContext).isBlank()) {
            TransformStack.init(internalContext);
            TransformStack.addTransformLevel(internalContext, TransformStack.levelBuilder(PIPELINE_FLAG));
            TransformStack.setReference(internalContext, reference);
        }
    }

    public static long getElapsedTime(InternalContext internalContext) {
        return System.currentTimeMillis() - TransformStack.getHeaderField(internalContext, 2);
    }

    private static int getReferenceCounter(InternalContext internalContext) {
        return TransformStack.getHeaderField(internalContext, 1).intValue();
    }

    public static int getAttemptedRetries(InternalContext internalContext) {
        return TransformStack.getHeaderField(internalContext, 3).intValue();
    }

    private static Long getHeaderField(InternalContext internalContext, int index) {
        return TransformStack.getHeaderField(TransformStack.currentLevel(internalContext), index);
    }

    private static Long getHeaderField(String level, int index) {
        return Long.valueOf(TransformStack.getHeaderFieldString(level, index));
    }

    private static String getHeaderFieldString(String level, int index) {
        return level.split("\u23d0")[index];
    }

    public static void removeTransformLevel(InternalContext internalContext) {
        List<String> levels = TransformStack.levels(internalContext);
        levels.remove(levels.size() - 1);
    }

    public static void removeRemainingTransformLevels(TransformReply reply, TransformerDebug transformerDebug) {
        List<String> levels = TransformStack.levels(reply.getInternalContext());
        if (levels != null) {
            while (!TransformStack.isFinished(reply.getInternalContext())) {
                TransformStack.removeFailedStep(reply, transformerDebug);
            }
        }
    }

    public static boolean isParentAFailover(InternalContext internalContext) {
        String level = TransformStack.currentLevel(internalContext);
        return level != null && level.startsWith(FAILOVER_FLAG);
    }

    public static String getParentName(InternalContext internalContext) {
        String level = TransformStack.parentLevel(internalContext, 1);
        return level == null ? null : new Step(level.substring(TransformStack.indexOfNextStep(level))).getTransformerName();
    }

    public static Step currentStep(InternalContext internalContext) {
        String level = TransformStack.currentLevel(internalContext);
        return new Step(level.substring(TransformStack.indexOfNextStep(level)));
    }

    public static boolean isLastStepInTransformLevel(InternalContext internalContext) {
        return TransformStack.getStepCount(internalContext) == 1;
    }

    private static boolean isTransformLevelFinished(InternalContext internalContext) {
        return TransformStack.getStepCount(internalContext) == 0;
    }

    private static int getStepCount(InternalContext internalContext) {
        return (StringUtils.countMatches((CharSequence)TransformStack.currentLevel(internalContext), (CharSequence)"\u23d0") + 1 - 4) / 3;
    }

    public static void removeSuccessfulStep(TransformReply reply, TransformerDebug transformerDebug) {
        TransformStack.removeFinishedSteps(reply, true, transformerDebug);
    }

    public static void removeFailedStep(TransformReply reply, TransformerDebug transformerDebug) {
        TransformStack.removeFinishedSteps(reply, false, transformerDebug);
    }

    private static void removeFinishedSteps(TransformReply reply, boolean successful, TransformerDebug transformerDebug) {
        TransformStack.removeStep(reply, successful, transformerDebug);
        InternalContext internalContext = reply.getInternalContext();
        while (!TransformStack.isFinished(internalContext) && TransformStack.isTransformLevelFinished(internalContext)) {
            TransformStack.removeTransformLevel(internalContext);
            if (!successful && TransformStack.isParentAFailover(internalContext)) continue;
            TransformStack.removeStep(reply, successful, transformerDebug);
        }
    }

    private static void removeStep(TransformReply reply, boolean successful, TransformerDebug transformerDebug) {
        InternalContext internalContext = reply.getInternalContext();
        boolean parentAFailover = TransformStack.isParentAFailover(internalContext);
        boolean successfulFailoverStep = successful && parentAFailover;
        boolean unsuccessfulPipelineStep = !successful && !parentAFailover;
        transformerDebug.popTransform(reply);
        List<String> levels = TransformStack.levels(internalContext);
        int size = levels.size();
        String level = levels.get(size - 1);
        levels.set(size - 1, level.substring(0, (successfulFailoverStep || unsuccessfulPipelineStep ? TransformStack.indexOfLastStep(level) : TransformStack.indexOfNextStep(level)) - 1));
        if (!TransformStack.isTransformLevelFinished(internalContext)) {
            TransformStack.incrementReference(internalContext);
        }
    }

    private static int indexOfNextStep(String level) {
        int j = level.length() - 1;
        for (int i = 3; i >= 1 && j > 0; --i) {
            j = level.lastIndexOf("\u23d0", j - 1);
        }
        return j + 1;
    }

    private static int indexOfLastStep(String level) {
        return TransformStack.indexOfField(level, 4);
    }

    private static int indexOfField(String level, int n) {
        int j = 0;
        for (int i = n; i >= 1; --i) {
            j = level.indexOf("\u23d0", j + 1);
        }
        return j + 1;
    }

    public static String checkStructure(InternalContext internalContext, String type) {
        String errorMessage = TransformStack.levels(internalContext).size() < 3 ? type + " InternalContext did not have the Stack set" : (!TransformStack.validTransformOptions(internalContext) ? type + " InternalContext did not have the TransformOptions set correctly" : (TransformStack.levels(internalContext).size() == 1 ? type + " InternalContext levels were not set" : (!TransformStack.validLevels(TransformStack.levels(internalContext)) ? type + " InternalContext did not have levels set correctly" : null)));
        return errorMessage;
    }

    private static boolean validTransformOptions(InternalContext internalContext) {
        String keysAndValues = TransformStack.level(internalContext, 0);
        if (keysAndValues == null) {
            return false;
        }
        if ("".equals(keysAndValues)) {
            return true;
        }
        String[] split = keysAndValues.split("\u23d0");
        if (split.length % 2 != 0) {
            return false;
        }
        for (int i = split.length - 2; i >= 0; i -= 2) {
            if (!split[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean validLevels(List<String> levels) {
        for (int i = levels.size() - 1; i >= 2; --i) {
            String level = levels.get(i);
            if (TransformStack.validLevel(level)) continue;
            return false;
        }
        return true;
    }

    private static boolean validLevel(String level) {
        if (level == null) {
            return false;
        }
        String[] split = level.split("\u23d0");
        if (!(split.length >= 7 && (split.length - 4) % 3 == 0 && (PIPELINE_FLAG.equals(split[0]) || FAILOVER_FLAG.equals(split[0])) && TransformStack.aValidReference(split[1]) && TransformStack.aPositiveLong(split[2]) && TransformStack.aPositiveInt(split[3]))) {
            return false;
        }
        for (int i = split.length - 1; i >= 4; --i) {
            if (!split[i].isBlank()) continue;
            return false;
        }
        return true;
    }

    private static boolean aValidReference(String string) {
        string = string.startsWith("e") ? string.substring(1) : string;
        return TransformStack.aPositiveInt(string);
    }

    private static boolean aPositiveInt(String string) {
        try {
            return Integer.valueOf(string).toString().equals(string) && Integer.valueOf(string) >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean aPositiveLong(String string) {
        try {
            return Long.valueOf(string).toString().equals(string) && Long.valueOf(string) >= 0L;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static class LevelBuilder {
        private final ArrayList<String> reverseOrderStepElements = new ArrayList();
        private final String flag;

        private LevelBuilder(String flag) {
            this.flag = flag;
        }

        public LevelBuilder withStep(String transformerName, String sourceMediaType, String targetMediaType) {
            this.reverseOrderStepElements.add(targetMediaType);
            this.reverseOrderStepElements.add(sourceMediaType);
            this.reverseOrderStepElements.add(transformerName);
            return this;
        }

        public String build() {
            StringJoiner stringJoiner = new StringJoiner("\u23d0");
            stringJoiner.add(this.flag);
            stringJoiner.add("1");
            stringJoiner.add("0");
            stringJoiner.add("0");
            for (int i = this.reverseOrderStepElements.size() - 1; i >= 0; --i) {
                stringJoiner.add(this.reverseOrderStepElements.get(i));
            }
            return stringJoiner.toString();
        }
    }

    public static class Step {
        private final String[] step;

        private Step(String stepWithSeparatedFields) {
            this.step = stepWithSeparatedFields.split("\u23d0");
        }

        public String getTransformerName() {
            return this.step[0];
        }

        public String getSourceMediaType() {
            return this.step[1];
        }

        public String getTargetMediaType() {
            return this.step[2];
        }
    }
}

