/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.transform.registry.SupportedTransform;

public class TransformCache {
    private final Map<String, Map<String, List<SupportedTransform>>> transforms = new ConcurrentHashMap<String, Map<String, List<SupportedTransform>>>();
    private final Map<String, String> coreVersions = new ConcurrentHashMap<String, String>();
    private final Map<String, Map<String, List<SupportedTransform>>> cachedSupportedTransformList = new ConcurrentHashMap<String, Map<String, List<SupportedTransform>>>();
    protected int transformerCount = 0;
    protected int transformCount = 0;

    public void incrementTransformerCount() {
        ++this.transformerCount;
    }

    public void appendTransform(String sourceMimetype, String targetMimetype, SupportedTransform transform, String transformerName, String coreVersion) {
        this.transforms.computeIfAbsent(sourceMimetype, k -> new ConcurrentHashMap()).computeIfAbsent(targetMimetype, k -> new ArrayList()).add(transform);
        this.coreVersions.put(transformerName, coreVersion == null ? "" : coreVersion);
        ++this.transformCount;
    }

    public Map<String, List<SupportedTransform>> retrieveTransforms(String sourceMimetype) {
        return this.transforms.getOrDefault(sourceMimetype, Collections.emptyMap());
    }

    public Map<String, Map<String, List<SupportedTransform>>> getTransforms() {
        return this.transforms;
    }

    public void cache(String renditionName, String sourceMimetype, List<SupportedTransform> transformListBySize) {
        this.cachedSupportedTransformList.get(renditionName).put(sourceMimetype, transformListBySize);
    }

    public List<SupportedTransform> retrieveCached(String renditionName, String sourceMimetype) {
        return (List)this.cachedSupportedTransformList.computeIfAbsent(renditionName, k -> new ConcurrentHashMap()).get(sourceMimetype);
    }

    public String toString() {
        return this.transformerCount == 0 && this.transformCount == 0 ? "" : "(transformers: " + this.transformerCount + " transforms: " + this.transformCount + ")";
    }

    public String getCoreVersion(String transformerName) {
        String coreVersion = this.coreVersions.get(transformerName);
        return coreVersion.isBlank() ? null : coreVersion;
    }
}

