/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.TransformOptionGroup;
import org.alfresco.transform.config.TransformOptionValue;
import org.alfresco.transform.exceptions.TransformException;
import org.alfresco.transform.registry.SupportedTransform;
import org.alfresco.transform.registry.TransformCache;
import org.springframework.http.HttpStatus;

class TransformRegistryHelper {
    private TransformRegistryHelper() {
    }

    static Set<TransformOption> lookupTransformOptions(Set<String> transformOptionNames, Map<String, Set<TransformOption>> transformOptions, String readFrom, Consumer<String> logError) {
        if (transformOptionNames == null) {
            return Collections.emptySet();
        }
        HashSet<TransformOption> options = new HashSet<TransformOption>();
        for (String name : transformOptionNames) {
            Set<TransformOption> oneSetOfTransformOptions = transformOptions.get(name);
            if (oneSetOfTransformOptions == null) {
                logError.accept("transformOptions in " + readFrom + " with the name " + name + " does not exist. Ignored");
                continue;
            }
            options.add(new TransformOptionGroup(false, oneSetOfTransformOptions));
        }
        return options.size() == 1 ? ((TransformOptionGroup)options.iterator().next()).getTransformOptions() : options;
    }

    static List<SupportedTransform> retrieveTransformListBySize(TransformCache data, String sourceMimetype, String targetMimetype, Map<String, String> actualOptions, String renditionName) {
        List<SupportedTransform> cachedTransformList;
        if (actualOptions == null) {
            actualOptions = Collections.emptyMap();
        }
        if (renditionName != null && renditionName.trim().isEmpty()) {
            renditionName = null;
        }
        List<SupportedTransform> list = cachedTransformList = renditionName == null ? null : data.retrieveCached(renditionName, sourceMimetype);
        if (cachedTransformList != null) {
            return cachedTransformList;
        }
        if (actualOptions.containsKey("sourceEncoding") || actualOptions.containsKey("timeout") || actualOptions.containsKey("sourceFilename")) {
            actualOptions = new HashMap<String, String>(actualOptions);
            actualOptions.remove("sourceEncoding");
            actualOptions.remove("timeout");
            actualOptions.remove("sourceFilename");
        }
        List<SupportedTransform> builtTransformList = TransformRegistryHelper.buildTransformList(data, sourceMimetype, targetMimetype, actualOptions);
        if (renditionName != null) {
            data.cache(renditionName, sourceMimetype, builtTransformList);
        }
        return builtTransformList;
    }

    private static List<SupportedTransform> buildTransformList(TransformCache data, String sourceMimetype, String targetMimetype, Map<String, String> actualOptions) {
        if (sourceMimetype == null) {
            throw new TransformException(HttpStatus.BAD_REQUEST, "Null value provided for sourceMimetype, please provide a value");
        }
        if (targetMimetype == null) {
            throw new TransformException(HttpStatus.BAD_REQUEST, "Null value provided for targetMimetype, please provide a value");
        }
        Map<String, List<SupportedTransform>> targetMap = data.retrieveTransforms(sourceMimetype);
        List supportedTransformList = targetMap.getOrDefault(targetMimetype, Collections.emptyList());
        ArrayList<SupportedTransform> transformListBySize = new ArrayList<SupportedTransform>();
        for (SupportedTransform supportedTransform : supportedTransformList) {
            Map<String, Boolean> possibleTransformOptions = TransformRegistryHelper.gatherPossibleTransformOptions(supportedTransform.getTransformOptions(), actualOptions);
            if (!TransformRegistryHelper.optionsMatch(possibleTransformOptions, actualOptions)) continue;
            TransformRegistryHelper.addToSupportedTransformList(transformListBySize, supportedTransform);
        }
        return transformListBySize;
    }

    private static void addToSupportedTransformList(List<SupportedTransform> transformListBySize, SupportedTransform newTransform) {
        if (transformListBySize.isEmpty()) {
            transformListBySize.add(newTransform);
        } else {
            for (int i = 0; i < transformListBySize.size(); ++i) {
                SupportedTransform existingTransform = transformListBySize.get(i);
                int compareMaxSize = TransformRegistryHelper.compareMaxSize(newTransform.getMaxSourceSizeBytes(), existingTransform.getMaxSourceSizeBytes());
                int comparePriority = existingTransform.getPriority() - newTransform.getPriority();
                if (compareMaxSize == 0) {
                    if (comparePriority == 0) {
                        transformListBySize.set(i, newTransform);
                        break;
                    }
                    if (comparePriority <= 0) break;
                    transformListBySize.set(i, newTransform);
                    TransformRegistryHelper.discardFromSupportedTransformList(transformListBySize, i);
                    break;
                }
                if (compareMaxSize < 0) {
                    if (comparePriority <= 0) break;
                    transformListBySize.add(i, newTransform);
                    TransformRegistryHelper.discardFromSupportedTransformList(transformListBySize, i);
                    break;
                }
                if (comparePriority < 0) {
                    if (i + 1 < transformListBySize.size()) continue;
                    transformListBySize.add(newTransform);
                    break;
                }
                transformListBySize.set(i, newTransform);
                TransformRegistryHelper.discardFromSupportedTransformList(transformListBySize, i);
                break;
            }
        }
    }

    private static void discardFromSupportedTransformList(List<SupportedTransform> transformListBySize, int i) {
        SupportedTransform newTransform = transformListBySize.get(i++);
        while (i < transformListBySize.size()) {
            SupportedTransform existingTransform = transformListBySize.get(i);
            int compareMaxSize = TransformRegistryHelper.compareMaxSize(newTransform.getMaxSourceSizeBytes(), existingTransform.getMaxSourceSizeBytes());
            int comparePriority = existingTransform.getPriority() - newTransform.getPriority();
            if ((comparePriority != 0 || compareMaxSize < 0) && (comparePriority <= 0 || compareMaxSize < 0)) break;
            transformListBySize.remove(i);
        }
    }

    private static Map<String, Boolean> gatherPossibleTransformOptions(TransformOptionGroup transformOptionGroup, Map<String, String> actualOptions) {
        HashMap<String, Boolean> possibleTransformOptions = new HashMap<String, Boolean>();
        TransformRegistryHelper.addToPossibleTransformOptions(possibleTransformOptions, transformOptionGroup, true, actualOptions);
        return possibleTransformOptions;
    }

    static boolean addToPossibleTransformOptions(Map<String, Boolean> possibleTransformOptions, TransformOptionGroup transformOptionGroup, Boolean parentGroupRequired, Map<String, String> actualOptions) {
        boolean added = false;
        boolean required = false;
        Set<TransformOption> optionList = transformOptionGroup.getTransformOptions();
        if (optionList != null && !optionList.isEmpty()) {
            boolean transformOptionGroupRequired = transformOptionGroup.isRequired() && parentGroupRequired != false;
            for (TransformOption transformOption : optionList) {
                if (transformOption instanceof TransformOptionGroup) {
                    added = TransformRegistryHelper.addToPossibleTransformOptions(possibleTransformOptions, (TransformOptionGroup)transformOption, transformOptionGroupRequired, actualOptions);
                    required |= added;
                    continue;
                }
                String name = ((TransformOptionValue)transformOption).getName();
                if (!actualOptions.containsKey(name)) continue;
                required = true;
            }
            if (required || transformOptionGroupRequired) {
                for (TransformOption transformOption : optionList) {
                    if (!(transformOption instanceof TransformOptionValue)) continue;
                    added = true;
                    TransformOptionValue option = (TransformOptionValue)transformOption;
                    possibleTransformOptions.put(option.getName(), option.isRequired());
                }
            }
        }
        return added;
    }

    private static int compareMaxSize(long a, long b) {
        return a == -1L ? (b == -1L ? 0 : 1) : (b == -1L ? -1 : Long.compare(a, b));
    }

    static boolean optionsMatch(Map<String, Boolean> transformOptions, Map<String, String> actualOptions) {
        boolean supported = transformOptions.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).allMatch(actualOptions::containsKey);
        if (!supported) {
            return false;
        }
        return actualOptions.keySet().stream().allMatch(transformOptions::containsKey);
    }
}

