/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.common;

import java.util.StringJoiner;
import org.alfresco.transform.common.RepositoryClientData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RepositoryClientDataTest {
    RepositoryClientData repositoryClientData;

    @Test
    void AcsClientDataWithDebugTest() {
        this.repositoryClientData = RepositoryClientData.builder().withRepoId("ACS1234").withRenditionName("renditionName").withRequestId("e123").withDebug().build();
        String clientData = this.repositoryClientData.toString();
        Assertions.assertEquals((Object)"ACS1234", (Object)this.repositoryClientData.getAcsVersion());
        Assertions.assertEquals((Object)"renditionName", (Object)this.repositoryClientData.getRenditionName());
        Assertions.assertEquals((Object)"e123", (Object)this.repositoryClientData.getRequestId());
        Assertions.assertTrue((boolean)this.repositoryClientData.isDebugRequested());
        Assertions.assertEquals((Object)clientData, (Object)this.repositoryClientData.toString());
    }

    @Test
    void AcsClientDataWithoutDebugTest() {
        String clientData = new StringJoiner("\u23d0").add("RepoACS1234").add("1").add("renditionName").add("3").add("4").add("5").add("54321").add("7").add("8").add("9").toString();
        this.repositoryClientData = new RepositoryClientData(clientData);
        Assertions.assertEquals((Object)"ACS1234", (Object)this.repositoryClientData.getAcsVersion());
        Assertions.assertEquals((Object)"renditionName", (Object)this.repositoryClientData.getRenditionName());
        Assertions.assertEquals((Object)"54321", (Object)this.repositoryClientData.getRequestId());
        Assertions.assertFalse((boolean)this.repositoryClientData.isDebugRequested());
        Assertions.assertEquals((Object)clientData, (Object)this.repositoryClientData.toString());
    }

    @Test
    void noLeadingRepoTest() {
        String clientData = new StringJoiner("\u23d0").add("ACS1234").add("1").add("renditionName").add("3").add("4").add("5").add("54321").add("7").add("8").add("9").toString();
        this.repositoryClientData = new RepositoryClientData(clientData);
        Assertions.assertEquals((Object)"", (Object)this.repositoryClientData.getAcsVersion());
        Assertions.assertEquals((Object)"", (Object)this.repositoryClientData.getRenditionName());
        Assertions.assertEquals((Object)"", (Object)this.repositoryClientData.getRequestId());
        Assertions.assertFalse((boolean)this.repositoryClientData.isDebugRequested());
        Assertions.assertEquals((Object)clientData, (Object)this.repositoryClientData.toString());
    }

    @Test
    void tooFewElementsTest() {
        String clientData = new StringJoiner("\u23d0").add("RepoACS1234").add("1").add("renditionName").add("3").add("4").add("5").add("54321").add("7").add("8").toString();
        this.repositoryClientData = new RepositoryClientData(clientData);
        Assertions.assertEquals((Object)"", (Object)this.repositoryClientData.getAcsVersion());
        Assertions.assertEquals((Object)"", (Object)this.repositoryClientData.getRenditionName());
        Assertions.assertEquals((Object)"", (Object)this.repositoryClientData.getRequestId());
        Assertions.assertFalse((boolean)this.repositoryClientData.isDebugRequested());
        Assertions.assertEquals((Object)clientData, (Object)this.repositoryClientData.toString());
    }

    @Test
    void tooManyElementsTest() {
        String clientData = new StringJoiner("\u23d0").add("RepoACS1234").add("1").add("renditionName").add("3").add("4").add("5").add("54321").add("7").add("8").add("debug:").add("10").toString();
        this.repositoryClientData = new RepositoryClientData(clientData);
        Assertions.assertEquals((Object)"", (Object)this.repositoryClientData.getAcsVersion());
        Assertions.assertEquals((Object)"", (Object)this.repositoryClientData.getRenditionName());
        Assertions.assertEquals((Object)"", (Object)this.repositoryClientData.getRequestId());
        Assertions.assertFalse((boolean)this.repositoryClientData.isDebugRequested());
        Assertions.assertEquals((Object)clientData, (Object)this.repositoryClientData.toString());
    }

    @Test
    void nullClientDataTest() {
        this.repositoryClientData = new RepositoryClientData(null);
        Assertions.assertEquals(null, (Object)this.repositoryClientData.toString());
    }

    @Test
    void noElementsClientDataTest() {
        String clientData = "There are no CLIENT_DATA_SEPARATOR chars";
        this.repositoryClientData = new RepositoryClientData(clientData);
        Assertions.assertEquals((Object)clientData, (Object)this.repositoryClientData.toString());
    }

    @Test
    void debugTest() {
        String clientData = new StringJoiner("\u23d0").add("RepoACS1234").add("1").add("2").add("3").add("4").add("5").add("6").add("7").add("8").add("debug:").toString();
        this.repositoryClientData = new RepositoryClientData(clientData);
        Assertions.assertEquals((Object)clientData, (Object)this.repositoryClientData.toString());
        this.repositoryClientData.appendDebug("Some debug");
        Assertions.assertEquals((Object)(clientData + "\u23d1Some debug"), (Object)this.repositoryClientData.toString());
        this.repositoryClientData.appendDebug("Some other debug");
        Assertions.assertEquals((Object)(clientData + "\u23d1Some debug\u23d1Some other debug"), (Object)this.repositoryClientData.toString());
    }
}

