/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.messages;

import java.util.UUID;
import org.alfresco.transform.client.model.TransformRequest;
import org.alfresco.transform.messages.TransformRequestValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.validation.DirectFieldBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;

public class TransformRequestValidatorTest {
    private TransformRequestValidator validator = new TransformRequestValidator();

    @Test
    public void testSupports() {
        Assertions.assertTrue((boolean)this.validator.supports(TransformRequest.class));
    }

    @Test
    public void testNullRequest() {
        DirectFieldBindingResult errors = new DirectFieldBindingResult(null, "request");
        this.validator.validate(null, (Errors)errors);
        Assertions.assertEquals((int)1, (int)errors.getAllErrors().size());
        Assertions.assertEquals((Object)"request cannot be null", (Object)((ObjectError)errors.getAllErrors().iterator().next()).getDefaultMessage());
    }

    @Test
    public void testMissingId() {
        TransformRequest request = new TransformRequest();
        DirectFieldBindingResult errors = new DirectFieldBindingResult((Object)request, "request");
        this.validator.validate((Object)request, (Errors)errors);
        Assertions.assertFalse((boolean)errors.getAllErrors().isEmpty());
        Assertions.assertEquals((Object)"requestId cannot be null or empty", (Object)((ObjectError)errors.getAllErrors().iterator().next()).getDefaultMessage());
    }

    @Test
    public void testMissingSourceSize() {
        TransformRequest request = new TransformRequest();
        request.setRequestId(UUID.randomUUID().toString());
        request.setSourceReference(UUID.randomUUID().toString());
        DirectFieldBindingResult errors = new DirectFieldBindingResult((Object)request, "request");
        this.validator.validate((Object)request, (Errors)errors);
        Assertions.assertFalse((boolean)errors.getAllErrors().isEmpty());
        Assertions.assertEquals((Object)"sourceSize cannot be null or have its value smaller than 0", (Object)((ObjectError)errors.getAllErrors().iterator().next()).getDefaultMessage());
    }

    @Test
    public void testMissingSourceMediaType() {
        TransformRequest request = new TransformRequest();
        request.setRequestId(UUID.randomUUID().toString());
        request.setSourceReference(UUID.randomUUID().toString());
        request.setSourceSize(Long.valueOf(32L));
        DirectFieldBindingResult errors = new DirectFieldBindingResult((Object)request, "request");
        this.validator.validate((Object)request, (Errors)errors);
        Assertions.assertFalse((boolean)errors.getAllErrors().isEmpty());
        Assertions.assertEquals((Object)"sourceMediaType cannot be null or empty", (Object)((ObjectError)errors.getAllErrors().iterator().next()).getDefaultMessage());
    }

    @Test
    public void testMissingTargetMediaType() {
        TransformRequest request = new TransformRequest();
        request.setRequestId(UUID.randomUUID().toString());
        request.setSourceReference(UUID.randomUUID().toString());
        request.setSourceSize(Long.valueOf(32L));
        request.setSourceMediaType("application/pdf");
        DirectFieldBindingResult errors = new DirectFieldBindingResult((Object)request, "request");
        this.validator.validate((Object)request, (Errors)errors);
        Assertions.assertFalse((boolean)errors.getAllErrors().isEmpty());
        Assertions.assertEquals((Object)"targetMediaType cannot be null or empty", (Object)((ObjectError)errors.getAllErrors().iterator().next()).getDefaultMessage());
    }

    @Test
    public void testMissingTargetExtension() {
        TransformRequest request = new TransformRequest();
        request.setRequestId(UUID.randomUUID().toString());
        request.setSourceReference(UUID.randomUUID().toString());
        request.setSourceSize(Long.valueOf(32L));
        request.setSourceMediaType("application/pdf");
        request.setTargetMediaType("image/png");
        DirectFieldBindingResult errors = new DirectFieldBindingResult((Object)request, "request");
        this.validator.validate((Object)request, (Errors)errors);
        Assertions.assertFalse((boolean)errors.getAllErrors().isEmpty());
        Assertions.assertEquals((Object)"targetExtension cannot be null or empty", (Object)((ObjectError)errors.getAllErrors().iterator().next()).getDefaultMessage());
    }

    @Test
    public void testMissingClientData() {
        TransformRequest request = new TransformRequest();
        request.setRequestId(UUID.randomUUID().toString());
        request.setSourceReference(UUID.randomUUID().toString());
        request.setSourceSize(Long.valueOf(32L));
        request.setSourceMediaType("application/pdf");
        request.setTargetMediaType("image/png");
        request.setTargetExtension("png");
        DirectFieldBindingResult errors = new DirectFieldBindingResult((Object)request, "request");
        this.validator.validate((Object)request, (Errors)errors);
        Assertions.assertFalse((boolean)errors.getAllErrors().isEmpty());
        Assertions.assertEquals((Object)"clientData cannot be null or empty", (Object)((ObjectError)errors.getAllErrors().iterator().next()).getDefaultMessage());
    }

    @Test
    public void testMissingSchema() {
        TransformRequest request = new TransformRequest();
        request.setRequestId(UUID.randomUUID().toString());
        request.setSourceReference(UUID.randomUUID().toString());
        request.setSourceSize(Long.valueOf(32L));
        request.setSourceMediaType("application/pdf");
        request.setTargetMediaType("image/png");
        request.setTargetExtension("png");
        request.setClientData("ACS");
        request.setSchema(-1);
        DirectFieldBindingResult errors = new DirectFieldBindingResult((Object)request, "request");
        this.validator.validate((Object)request, (Errors)errors);
        Assertions.assertFalse((boolean)errors.getAllErrors().isEmpty());
        Assertions.assertEquals((Object)"schema cannot be less than 0", (Object)((ObjectError)errors.getAllErrors().iterator().next()).getDefaultMessage());
    }

    @Test
    public void testCompleteTransformRequest() {
        TransformRequest request = new TransformRequest();
        request.setRequestId(UUID.randomUUID().toString());
        request.setSourceReference(UUID.randomUUID().toString());
        request.setSourceSize(Long.valueOf(32L));
        request.setSourceMediaType("application/pdf");
        request.setTargetMediaType("image/png");
        request.setTargetExtension("png");
        request.setClientData("ACS");
        DirectFieldBindingResult errors = new DirectFieldBindingResult((Object)request, "request");
        this.validator.validate((Object)request, (Errors)errors);
        Assertions.assertTrue((boolean)errors.getAllErrors().isEmpty());
    }
}

