/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.common;

import java.util.StringJoiner;
import java.util.stream.Stream;

public class RepositoryClientData {
    public static final String CLIENT_DATA_SEPARATOR = "\u23d0";
    public static final String DEBUG_SEPARATOR = "\u23d1";
    public static final String REPO_ID = "Repo";
    public static final String DEBUG = "debug:";
    private static final String NO_DEBUG = "nodebug:";
    private static final int REPO_INDEX = 0;
    private static final int RENDITION_INDEX = 2;
    private static final int REQUEST_ID_INDEX = 6;
    private static final int DEBUG_INDEX = 9;
    private static final int EXPECTED_ELEMENTS = 10;
    private final String origClientData;
    private final String[] split;

    public RepositoryClientData(String clientData) {
        this.origClientData = clientData;
        this.split = clientData == null ? null : clientData.split(CLIENT_DATA_SEPARATOR);
    }

    private boolean isRepositoryClientData() {
        return this.split != null && this.split.length == 10 && this.split[0].startsWith(REPO_ID);
    }

    public String getAcsVersion() {
        return this.isRepositoryClientData() ? this.split[0].substring(REPO_ID.length()) : "";
    }

    public String getRequestId() {
        return this.isRepositoryClientData() ? this.split[6] : "";
    }

    public String getRenditionName() {
        return this.isRepositoryClientData() ? this.split[2] : "";
    }

    public void appendDebug(String message) {
        if (this.isDebugRequested()) {
            this.split[9] = this.split[9] + DEBUG_SEPARATOR + message;
        }
    }

    public boolean isDebugRequested() {
        return this.isRepositoryClientData() && this.split[9].startsWith(DEBUG);
    }

    public String toString() {
        if (this.split == null) {
            return this.origClientData;
        }
        StringJoiner sj = new StringJoiner(CLIENT_DATA_SEPARATOR);
        Stream.of(this.split).forEach(sj::add);
        return sj.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final RepositoryClientData clientData = new RepositoryClientData(Builder.emptyClientData());

        private Builder() {
        }

        private static String emptyClientData() {
            StringJoiner sj = new StringJoiner(RepositoryClientData.CLIENT_DATA_SEPARATOR);
            sj.add("RepoACS1234");
            for (int i = 0; i < 8; ++i) {
                sj.add("");
            }
            sj.add(RepositoryClientData.NO_DEBUG);
            return sj.toString();
        }

        public Builder withRepoId(String version) {
            this.clientData.split[0] = RepositoryClientData.REPO_ID + version;
            return this;
        }

        public Builder withRequestId(String requestId) {
            this.clientData.split[6] = requestId;
            return this;
        }

        public Builder withRenditionName(String renditionName) {
            this.clientData.split[2] = renditionName;
            return this;
        }

        public Builder withDebug() {
            this.clientData.split[9] = RepositoryClientData.DEBUG;
            return this;
        }

        public Builder withDebugMessage(String message) {
            this.clientData.split[9] = "debug:\u23d1" + message;
            return this;
        }

        public RepositoryClientData build() {
            return this.clientData;
        }
    }
}

