/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.messages;

import org.alfresco.transform.client.model.TransformRequest;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class TransformRequestValidator
implements Validator {
    public boolean supports(Class<?> aClass) {
        return aClass.isAssignableFrom(TransformRequest.class);
    }

    public void validate(Object o, Errors errors) {
        TransformRequest request = (TransformRequest)o;
        if (request == null) {
            errors.reject(null, "request cannot be null");
        } else {
            String clientData;
            String targetExtension;
            String targetMediaType;
            String sourceMediaType;
            Long sourceSize;
            String requestId = request.getRequestId();
            if (requestId == null || requestId.isEmpty()) {
                errors.rejectValue("requestId", null, "requestId cannot be null or empty");
            }
            if ((sourceSize = request.getSourceSize()) == null || sourceSize <= 0L) {
                errors.rejectValue("sourceSize", null, "sourceSize cannot be null or have its value smaller than 0");
            }
            if ((sourceMediaType = request.getSourceMediaType()) == null || sourceMediaType.isEmpty()) {
                errors.rejectValue("sourceMediaType", null, "sourceMediaType cannot be null or empty");
            }
            if ((targetMediaType = request.getTargetMediaType()) == null || targetMediaType.isEmpty()) {
                errors.rejectValue("targetMediaType", null, "targetMediaType cannot be null or empty");
            }
            if ((targetExtension = request.getTargetExtension()) == null || targetExtension.isEmpty()) {
                errors.rejectValue("targetExtension", null, "targetExtension cannot be null or empty");
            }
            if ((clientData = request.getClientData()) == null || clientData.isEmpty()) {
                errors.rejectValue("clientData", String.valueOf(request.getSchema()), "clientData cannot be null or empty");
            }
            if (request.getSchema() < 0) {
                errors.rejectValue("schema", String.valueOf(request.getSchema()), "schema cannot be less than 0");
            }
        }
    }
}

