/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.alfresco.transform.config.AddSupported;
import org.alfresco.transform.config.CoreVersionDecorator;
import org.alfresco.transform.config.OverrideSupported;
import org.alfresco.transform.config.RemoveSupported;
import org.alfresco.transform.config.SupportedDefaults;
import org.alfresco.transform.config.SupportedSourceAndTarget;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.TransformStep;
import org.alfresco.transform.config.Transformer;
import org.alfresco.transform.config.TransformerAndTypes;
import org.alfresco.transform.config.Types;
import org.alfresco.transform.registry.AbstractTransformRegistry;
import org.alfresco.transform.registry.Defaults;
import org.alfresco.transform.registry.Origin;

public class CombinedTransformConfig {
    private static final String MIMETYPE_METADATA_EXTRACT = "alfresco-metadata-extract";
    private static final String MIMETYPE_METADATA_EMBED = "alfresco-metadata-embed";
    private static final String INTERMEDIATE_STEPS_SHOULD_HAVE_A_TARGET_MIMETYPE = "intermediate steps should have a target mimetype";
    private static final String THE_FINAL_STEP_SHOULD_NOT_HAVE_A_TARGET_MIMETYPE = "the final step should not have a target mimetype";
    private final Map<String, Set<TransformOption>> combinedTransformOptions = new HashMap<String, Set<TransformOption>>();
    private List<Origin<Transformer>> combinedTransformers = new ArrayList<Origin<Transformer>>();
    private final Defaults defaults = new Defaults();

    public static void combineAndRegister(TransformConfig transformConfig, String readFrom, String baseUrl, AbstractTransformRegistry registry) {
        CombinedTransformConfig combinedTransformConfig = new CombinedTransformConfig();
        combinedTransformConfig.addTransformConfig(transformConfig, readFrom, baseUrl, registry);
        combinedTransformConfig.combineTransformerConfig(registry);
        combinedTransformConfig.registerCombinedTransformers(registry);
    }

    public void clear() {
        this.combinedTransformOptions.clear();
        this.combinedTransformers.clear();
        this.defaults.clear();
    }

    public void addTransformConfig(List<Origin<TransformConfig>> transformConfigList, AbstractTransformRegistry registry) {
        transformConfigList.forEach(tc -> this.addTransformConfig((TransformConfig)tc.get(), tc.getReadFrom(), tc.getBaseUrl(), registry));
    }

    public void addTransformConfig(TransformConfig transformConfig, String readFrom, String baseUrl, AbstractTransformRegistry registry) {
        this.removeTransformers(transformConfig.getRemoveTransformers(), readFrom, registry);
        this.supportedDefaults(transformConfig.getSupportedDefaults(), readFrom, registry);
        this.removeSupported(transformConfig.getRemoveSupported(), readFrom, registry);
        this.addSupported(transformConfig.getAddSupported(), readFrom, registry);
        this.overrideSupported(transformConfig.getOverrideSupported(), readFrom, registry);
        transformConfig.getTransformOptions().forEach(this.combinedTransformOptions::put);
        transformConfig.getTransformers().forEach(t -> this.combinedTransformers.add(new Origin<Transformer>((Transformer)t, baseUrl, readFrom)));
    }

    private void removeTransformers(Set<String> removeTransformersSet, String readFrom, AbstractTransformRegistry registry) {
        if (!removeTransformersSet.isEmpty()) {
            HashSet<String> leftOver = new HashSet<String>(removeTransformersSet);
            this.combinedTransformers.removeIf(combinedTransformer -> {
                String transformerName = ((Transformer)combinedTransformer.get()).getTransformerName();
                if (removeTransformersSet.contains(transformerName)) {
                    leftOver.remove(transformerName);
                    return true;
                }
                return false;
            });
            Set quotedLeftOver = leftOver.stream().map(transformerName -> "\"" + transformerName + "\"").collect(Collectors.toSet());
            this.logWarn(quotedLeftOver, readFrom, registry, "removeTransformers");
        }
    }

    private void supportedDefaults(Set<SupportedDefaults> supportedDefaults, String readFrom, AbstractTransformRegistry registry) {
        if (!supportedDefaults.isEmpty()) {
            HashSet<SupportedDefaults> leftOver = new HashSet<SupportedDefaults>(supportedDefaults);
            supportedDefaults.stream().filter(supportedDefault -> supportedDefault.getMaxSourceSizeBytes() != null || supportedDefault.getPriority() != null).forEach(supportedDefault -> {
                this.defaults.add((SupportedDefaults)supportedDefault);
                leftOver.remove(supportedDefault);
            });
            this.logWarn(leftOver, readFrom, registry, "supportedDefaults");
        }
    }

    private <T extends TransformerAndTypes> void processSupported(Set<T> tSet, String readFrom, AbstractTransformRegistry registry, String elementName, ProcessSingleT<T> process) {
        if (!tSet.isEmpty()) {
            HashSet leftOver = new HashSet(tSet);
            tSet.stream().filter(t -> t.getTransformerName() != null && t.getSourceMediaType() != null && t.getTargetMediaType() != null).forEach(t -> process.process(leftOver, t));
            this.logWarn(leftOver, readFrom, registry, elementName);
        }
    }

    private <T> void logWarn(Set<T> leftOver, String readFrom, AbstractTransformRegistry registry, String elementName) {
        if (!leftOver.isEmpty()) {
            StringJoiner sj = new StringJoiner(", ", "Unable to process \"" + elementName + "\": [", "]. Read from " + readFrom);
            leftOver.forEach(removeSupported -> sj.add(removeSupported.toString()));
            registry.logWarn(sj.toString());
        }
    }

    private void removeSupported(Set<RemoveSupported> removeSupportedSet, String readFrom, AbstractTransformRegistry registry) {
        this.processSupported(removeSupportedSet, readFrom, registry, "removeSupported", (leftOver, removeSupported) -> this.combinedTransformers.stream().map(Origin::get).forEach(transformer -> {
            if (transformer.getTransformerName().equals(removeSupported.getTransformerName()) && transformer.getSupportedSourceAndTargetList().removeIf(supported -> supported.getSourceMediaType().equals(removeSupported.getSourceMediaType()) && supported.getTargetMediaType().equals(removeSupported.getTargetMediaType()))) {
                leftOver.remove(removeSupported);
            }
        }));
    }

    private void addSupported(Set<AddSupported> addSupportedSet, String readFrom, AbstractTransformRegistry registry) {
        this.processSupported(addSupportedSet, readFrom, registry, "addSupported", (leftOver, addSupported) -> this.combinedTransformers.stream().map(Origin::get).filter(transformer -> transformer.getTransformerName().equals(addSupported.getTransformerName())).forEach(transformerWithName -> {
            Set<SupportedSourceAndTarget> supportedSourceAndTargetList = transformerWithName.getSupportedSourceAndTargetList();
            SupportedSourceAndTarget existingSupported = this.getExistingSupported(supportedSourceAndTargetList, addSupported.getSourceMediaType(), addSupported.getTargetMediaType());
            if (existingSupported == null) {
                SupportedSourceAndTarget newSupportedSourceAndTarget = (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(addSupported.getSourceMediaType())).withTargetMediaType(addSupported.getTargetMediaType())).withMaxSourceSizeBytes(addSupported.getMaxSourceSizeBytes()).withPriority(addSupported.getPriority()).build();
                supportedSourceAndTargetList.add(newSupportedSourceAndTarget);
                leftOver.remove(addSupported);
            }
        }));
    }

    private void overrideSupported(Set<OverrideSupported> overrideSupportedSet, String readFrom, AbstractTransformRegistry registry) {
        this.processSupported(overrideSupportedSet, readFrom, registry, "overrideSupported", (leftOver, overrideSupported) -> this.combinedTransformers.stream().map(Origin::get).filter(transformer -> transformer.getTransformerName().equals(overrideSupported.getTransformerName())).forEach(transformerWithName -> {
            Set<SupportedSourceAndTarget> supportedSourceAndTargetList = transformerWithName.getSupportedSourceAndTargetList();
            SupportedSourceAndTarget existingSupported = this.getExistingSupported(supportedSourceAndTargetList, overrideSupported.getSourceMediaType(), overrideSupported.getTargetMediaType());
            if (existingSupported != null) {
                supportedSourceAndTargetList.remove(existingSupported);
                existingSupported.setMaxSourceSizeBytes(overrideSupported.getMaxSourceSizeBytes());
                existingSupported.setPriority(overrideSupported.getPriority());
                supportedSourceAndTargetList.add(existingSupported);
                leftOver.remove(overrideSupported);
            }
        }));
    }

    private SupportedSourceAndTarget getExistingSupported(Set<SupportedSourceAndTarget> supportedSourceAndTargetList, String sourceMediaType, String targetMediaType) {
        return supportedSourceAndTargetList.stream().filter(supported -> supported.getSourceMediaType().equals(sourceMediaType) && supported.getTargetMediaType().equals(targetMediaType)).findFirst().orElse(null);
    }

    public void combineTransformerConfig(AbstractTransformRegistry registry) {
        this.removeInvalidTransformers(registry);
        this.sortTransformers(registry);
        this.applyDefaults();
        this.addWildcardSupportedSourceAndTarget(registry);
        this.removePipelinesWithUnsupportedTransforms(registry);
        this.setCoreVersionOnCombinedMultiStepTransformers();
    }

    public TransformConfig buildTransformConfig() {
        ArrayList<Transformer> transformers = new ArrayList<Transformer>();
        this.combinedTransformers.forEach(ct -> transformers.add((Transformer)ct.get()));
        Set<SupportedDefaults> supportedDefaults = this.defaults.getSupportedDefaults();
        return TransformConfig.builder().withTransformers(transformers).withTransformOptions(this.combinedTransformOptions).withSupportedDefaults(supportedDefaults).build();
    }

    public void registerCombinedTransformers(AbstractTransformRegistry registry) {
        this.combinedTransformers.forEach(ct -> registry.register((Transformer)ct.get(), this.combinedTransformOptions, ct.getBaseUrl(), ct.getReadFrom()));
    }

    private void removeInvalidTransformers(AbstractTransformRegistry registry) {
        for (int i = 0; i < this.combinedTransformers.size(); ++i) {
            String msg;
            try {
                boolean isFailover;
                Origin<Transformer> transformAndItsOrigin = this.combinedTransformers.get(i);
                Transformer transformer = transformAndItsOrigin.get();
                String readFrom = transformAndItsOrigin.getReadFrom();
                String name = transformer.getTransformerName();
                List<TransformStep> pipeline = transformer.getTransformerPipeline();
                List<String> failover = transformer.getTransformerFailover();
                boolean isPipeline = pipeline != null && !pipeline.isEmpty();
                boolean bl = isFailover = failover != null && !failover.isEmpty();
                if (isPipeline && isFailover) {
                    throw new IllegalArgumentException("Transformer " + CombinedTransformConfig.transformerName(name) + " cannot have both pipeline and failover sections. Read from " + readFrom);
                }
                int indexToRemove = this.removeInvalidTransformer(i, this.combinedTransformers, registry, transformAndItsOrigin, transformer, name, readFrom, isPipeline, isFailover);
                if (indexToRemove < 0) continue;
                this.combinedTransformers.remove(indexToRemove);
                if (i < indexToRemove) continue;
                --i;
                continue;
            }
            catch (IllegalStateException e) {
                msg = e.getMessage();
                registry.logWarn(msg);
                this.combinedTransformers.remove(i--);
                continue;
            }
            catch (IllegalArgumentException e) {
                msg = e.getMessage();
                registry.logError(msg);
                this.combinedTransformers.remove(i--);
            }
        }
    }

    private int removeInvalidTransformer(int i, List<Origin<Transformer>> combinedTransformers, AbstractTransformRegistry registry, Origin<Transformer> transformAndItsOrigin, Transformer transformer, String name, String readFrom, boolean isPipeline, boolean isFailover) {
        String testBaseUrl;
        int indexToRemove = -1;
        if (name == null || "".equals(name.trim())) {
            throw new IllegalArgumentException("Transformer names may not be null. Read from " + readFrom);
        }
        String baseUrl = transformAndItsOrigin.getBaseUrl();
        if (!CombinedTransformConfig.nullSafeEquals(baseUrl, testBaseUrl = registry.getBaseUrlIfTesting(name, baseUrl))) {
            baseUrl = testBaseUrl;
            transformAndItsOrigin = new Origin<Transformer>(transformer, baseUrl, readFrom);
            combinedTransformers.set(i, transformAndItsOrigin);
        }
        boolean isTEngineTransform = baseUrl != null;
        boolean isPassThroughTransform = this.isPassThroughTransformName(name);
        if (isPassThroughTransform && isTEngineTransform) {
            throw new IllegalArgumentException("T-Engines should not use " + CombinedTransformConfig.transformerName(name) + " as a transform name. Read from " + readFrom);
        }
        for (String transformOptionsLabel : transformer.getTransformOptions()) {
            if (this.combinedTransformOptions.containsKey(transformOptionsLabel)) continue;
            throw new IllegalStateException("Transformer " + CombinedTransformConfig.transformerName(name) + " references \"" + transformOptionsLabel + "\" which do not exist. Read from " + readFrom);
        }
        boolean isOneStepTransform = !isPipeline && !isFailover && !isPassThroughTransform;
        int j = CombinedTransformConfig.lastIndexOf(name, combinedTransformers, i);
        if (j >= 0) {
            if (isTEngineTransform) {
                throw new IllegalArgumentException("Transformer " + CombinedTransformConfig.transformerName(name) + " must be a unique name. Read from " + readFrom);
            }
            if (isPassThroughTransform) {
                throw new IllegalArgumentException("Pipeline files should not use " + CombinedTransformConfig.transformerName(name) + " as a transform name. Read from " + readFrom);
            }
            if (isOneStepTransform) {
                boolean isOverriddenFailover;
                Origin<Transformer> overriddenTransformAndItsOrigin = combinedTransformers.get(j);
                Transformer overriddenTransformer = overriddenTransformAndItsOrigin.get();
                List<TransformStep> overriddenPipeline = overriddenTransformer.getTransformerPipeline();
                List<String> overriddenFailover = overriddenTransformer.getTransformerFailover();
                boolean isOverriddenPipeline = overriddenPipeline != null && !overriddenPipeline.isEmpty();
                boolean bl = isOverriddenFailover = overriddenFailover != null && !overriddenFailover.isEmpty();
                if (isOverriddenPipeline || isOverriddenFailover) {
                    throw new IllegalArgumentException("Single step transformers (such as " + CombinedTransformConfig.transformerName(name) + ") may not override a pipeline or failover transform as there is no T-Engine to perform work. Read from " + readFrom);
                }
                String overriddenBaseUrl = overriddenTransformAndItsOrigin.getBaseUrl();
                Transformer overriddenTransformTransform = transformAndItsOrigin.get();
                Origin<Transformer> overridingTransform = new Origin<Transformer>(overriddenTransformTransform, overriddenBaseUrl, readFrom);
                combinedTransformers.set(i, overridingTransform);
            }
            indexToRemove = j;
        } else if (isOneStepTransform && baseUrl == null) {
            throw new IllegalArgumentException("Single step transformers (such as " + CombinedTransformConfig.transformerName(name) + ") must be defined in a T-Engine rather than in a pipeline file, unless they are overriding an existing single step definition. Read from " + readFrom);
        }
        return indexToRemove;
    }

    protected boolean isPassThroughTransformName(String name) {
        return false;
    }

    private static int lastIndexOf(String name, List<Origin<Transformer>> combinedTransformers, int toIndex) {
        for (int j = toIndex - 1; j >= 0; --j) {
            Origin<Transformer> transformAndItsOrigin = combinedTransformers.get(j);
            Transformer transformer = transformAndItsOrigin.get();
            String transformerName = transformer.getTransformerName();
            if (!name.equals(transformerName)) continue;
            return j;
        }
        return -1;
    }

    protected static String transformerName(String name) {
        return name == null ? " without a name" : "\"" + name + "\"";
    }

    private static boolean nullSafeEquals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private void sortTransformers(AbstractTransformRegistry registry) {
        String name;
        Transformer transformer;
        boolean added;
        ArrayList<Origin<Transformer>> transformers = new ArrayList<Origin<Transformer>>(this.combinedTransformers.size());
        ArrayList<Origin<Transformer>> todo = new ArrayList<Origin<Transformer>>(this.combinedTransformers.size());
        HashSet<String> transformerNames = new HashSet<String>();
        do {
            added = false;
            for (Origin<Transformer> transformAndItsOrigin : this.combinedTransformers) {
                transformer = transformAndItsOrigin.get();
                name = transformer.getTransformerName();
                Set<String> referencedTransformerNames = this.getReferencedTransformerNames(transformer);
                boolean addEntry = true;
                for (String referencedTransformerName : referencedTransformerNames) {
                    if (transformerNames.contains(referencedTransformerName)) continue;
                    todo.add(transformAndItsOrigin);
                    addEntry = false;
                    break;
                }
                if (!addEntry) continue;
                transformers.add(transformAndItsOrigin);
                added = true;
                if (name == null) continue;
                transformerNames.add(name);
            }
            this.combinedTransformers.clear();
            this.combinedTransformers.addAll(todo);
            todo.clear();
        } while (added && !this.combinedTransformers.isEmpty());
        transformers.addAll(todo);
        for (Origin<Transformer> transformAndItsOrigin : this.combinedTransformers) {
            transformer = transformAndItsOrigin.get();
            name = transformer.getTransformerName();
            registry.logWarn("Transformer " + CombinedTransformConfig.transformerName(name) + " ignored as step transforms " + this.getUnknownReferencedTransformerNames(transformer, transformerNames) + " do not exist. Read from " + transformAndItsOrigin.getReadFrom());
        }
        this.combinedTransformers = transformers;
    }

    private Set<String> getReferencedTransformerNames(Transformer transformer) {
        List<String> failover;
        HashSet<String> referencedTransformerNames = new HashSet<String>();
        List<TransformStep> pipeline = transformer.getTransformerPipeline();
        if (pipeline != null) {
            for (TransformStep step : pipeline) {
                String stepName = step.getTransformerName();
                referencedTransformerNames.add(stepName);
            }
        }
        if ((failover = transformer.getTransformerFailover()) != null) {
            referencedTransformerNames.addAll(failover);
        }
        return referencedTransformerNames;
    }

    private String getUnknownReferencedTransformerNames(Transformer transformer, Set<String> transformerNames) {
        StringJoiner sj = new StringJoiner(", ", "(", ")");
        Set<String> referencedTransformerNames = this.getReferencedTransformerNames(transformer);
        for (String referencedTransformerName : referencedTransformerNames) {
            if (transformerNames.contains(referencedTransformerName)) continue;
            sj.add(CombinedTransformConfig.transformerName(referencedTransformerName));
        }
        return sj.toString();
    }

    private void applyDefaults() {
        this.combinedTransformers.stream().map(Origin::get).forEach(transformer -> transformer.setSupportedSourceAndTargetList(transformer.getSupportedSourceAndTargetList().stream().map(supportedSourceAndTarget -> {
            Long maxSourceSizeBytes;
            Integer priority = supportedSourceAndTarget.getPriority();
            if (this.defaults.valuesUnset(priority, maxSourceSizeBytes = supportedSourceAndTarget.getMaxSourceSizeBytes())) {
                String transformerName = transformer.getTransformerName();
                String sourceMediaType = supportedSourceAndTarget.getSourceMediaType();
                supportedSourceAndTarget.setPriority(this.defaults.getPriority(transformerName, sourceMediaType, priority));
                supportedSourceAndTarget.setMaxSourceSizeBytes(this.defaults.getMaxSourceSizeBytes(transformerName, sourceMediaType, maxSourceSizeBytes));
            }
            return supportedSourceAndTarget;
        }).collect(Collectors.toSet())));
        this.defaults.clear();
    }

    private void addWildcardSupportedSourceAndTarget(AbstractTransformRegistry registry) {
        HashMap transformers = new HashMap();
        this.combinedTransformers.forEach(ct -> transformers.put(((Transformer)ct.get()).getTransformerName(), (Transformer)ct.get()));
        this.combinedTransformers.forEach(transformAndItsOrigin -> {
            Transformer transformer = (Transformer)transformAndItsOrigin.get();
            if (transformer.getSupportedSourceAndTargetList().isEmpty()) {
                List<TransformStep> pipeline = transformer.getTransformerPipeline();
                List<String> failover = transformer.getTransformerFailover();
                boolean isPipeline = pipeline != null && !pipeline.isEmpty();
                boolean isFailover = failover != null && !failover.isEmpty();
                Object errorReason = null;
                if (isFailover) {
                    Set<SupportedSourceAndTarget> supportedSourceAndTargets = failover.stream().flatMap(name -> ((Transformer)transformers.get(name)).getSupportedSourceAndTargetList().stream()).collect(Collectors.toSet());
                    supportedSourceAndTargets.forEach(s -> s.setPriority(s.getPriority() - 1));
                    transformer.setSupportedSourceAndTargetList(supportedSourceAndTargets);
                    errorReason = "the step transforms don't support any";
                } else if (isPipeline) {
                    String sourceMediaType = null;
                    Set sourceMediaTypesAndMaxSizes = null;
                    Set<String> firstTransformOptions = null;
                    String firstTransformStepName = null;
                    int numberOfSteps = pipeline.size();
                    for (int stepIndex = 0; stepIndex < numberOfSteps; ++stepIndex) {
                        TransformStep step = pipeline.get(stepIndex);
                        String name2 = step.getTransformerName();
                        Transformer stepTransformer = (Transformer)transformers.get(name2);
                        if (stepTransformer == null) {
                            errorReason = "one of the step transformers is missing";
                            break;
                        }
                        String stepTrg = step.getTargetMediaType();
                        if (stepIndex == 0) {
                            sourceMediaTypesAndMaxSizes = stepTransformer.getSupportedSourceAndTargetList().stream().filter(s -> stepTrg.equals(s.getTargetMediaType())).collect(Collectors.toSet());
                            sourceMediaType = stepTrg;
                            firstTransformOptions = stepTransformer.getTransformOptions();
                            firstTransformStepName = name2;
                            if (!sourceMediaTypesAndMaxSizes.isEmpty()) continue;
                            errorReason = "the first step transformer " + CombinedTransformConfig.transformerName(name2) + " does not support to \"" + stepTrg + "\"";
                            break;
                        }
                        String src = sourceMediaType;
                        if (stepIndex + 1 == numberOfSteps) {
                            if (stepTrg != null) {
                                errorReason = THE_FINAL_STEP_SHOULD_NOT_HAVE_A_TARGET_MIMETYPE;
                                break;
                            }
                            Set<SupportedSourceAndTarget> supportedSourceAndTargets = sourceMediaTypesAndMaxSizes.stream().flatMap(s -> stepTransformer.getSupportedSourceAndTargetList().stream().filter(st -> {
                                String targetMimetype = st.getTargetMediaType();
                                return st.getSourceMediaType().equals(src) && !MIMETYPE_METADATA_EXTRACT.equals(targetMimetype) && !MIMETYPE_METADATA_EMBED.equals(targetMimetype);
                            }).map(Types::getTargetMediaType).map(trg -> (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(s.getSourceMediaType())).withMaxSourceSizeBytes(s.getMaxSourceSizeBytes()).withPriority(s.getPriority()).withTargetMediaType((String)trg)).build())).collect(Collectors.toSet());
                            if (supportedSourceAndTargets.isEmpty()) {
                                errorReason = "the final step transformer " + CombinedTransformConfig.transformerName(name2) + " does not support from \"" + src + "\"";
                            } else {
                                Set<String> transformOptions = transformer.getTransformOptions();
                                if (this.sameOptions(transformOptions, firstTransformOptions)) {
                                    supportedSourceAndTargets.removeAll(sourceMediaTypesAndMaxSizes);
                                }
                                if (supportedSourceAndTargets.isEmpty()) {
                                    errorReason = "the first transformer " + CombinedTransformConfig.transformerName(firstTransformStepName) + " in the pipeline already supported all source and target mimetypes that would have been added as wildcards";
                                }
                            }
                            transformer.setSupportedSourceAndTargetList(supportedSourceAndTargets);
                            continue;
                        }
                        if (stepTrg == null) {
                            errorReason = INTERMEDIATE_STEPS_SHOULD_HAVE_A_TARGET_MIMETYPE;
                            break;
                        }
                        if (stepTransformer.getSupportedSourceAndTargetList().stream().noneMatch(st -> st.getSourceMediaType().equals(src) && st.getTargetMediaType().equals(stepTrg))) {
                            errorReason = "the step transformer " + CombinedTransformConfig.transformerName(stepTransformer.getTransformerName()) + " does not support \"" + src + "\" to \"" + stepTrg + "\"";
                            break;
                        }
                        sourceMediaType = stepTrg;
                    }
                }
                if (transformer.getSupportedSourceAndTargetList().isEmpty() && (isFailover || isPipeline)) {
                    registry.logError("No supported source and target mimetypes could be added to the transformer " + CombinedTransformConfig.transformerName(transformer.getTransformerName()) + " as " + errorReason + ". Read from " + transformAndItsOrigin.getReadFrom());
                }
            }
        });
    }

    private boolean sameOptions(Set<String> transformOptionNames1, Set<String> transformOptionNames2) {
        if (transformOptionNames1.equals(transformOptionNames2)) {
            return true;
        }
        Set<TransformOption> transformOptions1 = this.getTransformOptions(transformOptionNames1);
        Set<TransformOption> transformOptions2 = this.getTransformOptions(transformOptionNames2);
        return transformOptions1.equals(transformOptions2);
    }

    private Set<TransformOption> getTransformOptions(Set<String> transformOptionNames) {
        HashSet<TransformOption> transformOptions = new HashSet<TransformOption>();
        transformOptionNames.forEach(name -> transformOptions.addAll((Collection)this.combinedTransformOptions.get(name)));
        return transformOptions;
    }

    private void removePipelinesWithUnsupportedTransforms(AbstractTransformRegistry registry) {
        Map transformersByName = this.combinedTransformers.stream().map(Origin::get).collect(Collectors.toMap(Transformer::getTransformerName, Function.identity()));
        for (int i = 0; i < this.combinedTransformers.size(); ++i) {
            try {
                boolean isPipeline;
                Origin<Transformer> transformAndItsOrigin = this.combinedTransformers.get(i);
                Transformer transformer = transformAndItsOrigin.get();
                String readFrom = transformAndItsOrigin.getReadFrom();
                String name = transformer.getTransformerName();
                List<TransformStep> pipeline = transformer.getTransformerPipeline();
                boolean bl = isPipeline = pipeline != null && !pipeline.isEmpty();
                if (!isPipeline) continue;
                if (transformer.getSupportedSourceAndTargetList().isEmpty()) {
                    throw new IllegalStateException("Transformer " + CombinedTransformConfig.transformerName(name) + " has no supported source and target mimetypes, so will be ignored. Read from " + readFrom);
                }
                ArrayList unsupported = new ArrayList();
                transformer.getSupportedSourceAndTargetList().forEach(supportedSourceAndTarget -> {
                    String nextSource = supportedSourceAndTarget.getSourceMediaType();
                    for (TransformStep step : pipeline) {
                        String target;
                        String source = nextSource;
                        String string = target = step.getTargetMediaType() == null ? supportedSourceAndTarget.getTargetMediaType() : step.getTargetMediaType();
                        if (((Transformer)transformersByName.get(step.getTransformerName())).getSupportedSourceAndTargetList().stream().noneMatch(stepsSupportedSourceAndTarget -> source.equals(stepsSupportedSourceAndTarget.getSourceMediaType()) && target.equals(stepsSupportedSourceAndTarget.getTargetMediaType()))) {
                            unsupported.add(supportedSourceAndTarget.getSourceMediaType() + "->" + supportedSourceAndTarget.getTargetMediaType());
                            break;
                        }
                        nextSource = target;
                    }
                });
                if (unsupported.isEmpty()) continue;
                throw new IllegalStateException("Pipeline transformer " + CombinedTransformConfig.transformerName(name) + " steps do not support (" + unsupported.stream().sorted().collect(Collectors.joining(", ")) + ") so will be ignored");
            }
            catch (IllegalStateException e) {
                String msg = e.getMessage();
                registry.logError(msg);
                this.combinedTransformers.remove(i--);
            }
        }
    }

    private void setCoreVersionOnCombinedMultiStepTransformers() {
        CoreVersionDecorator.setCoreVersionOnMultiStepTransformers(this.combinedTransformOptions, this.combinedTransformers.stream().map(Origin::get).collect(Collectors.toList()));
    }

    protected int transformerCount() {
        return this.combinedTransformers.size();
    }

    public Map<String, Origin<Transformer>> getTransformerByNameMap() {
        return this.combinedTransformers.stream().collect(Collectors.toMap(origin -> ((Transformer)origin.get()).getTransformerName(), origin -> origin));
    }

    private static interface ProcessSingleT<T> {
        public void process(Set<T> var1, T var2);
    }
}

