/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.transform.config.SupportedDefaults;
import org.alfresco.transform.registry.TransformerAndSourceType;

class Defaults {
    private static final Integer DEFAULT_PRIORITY = 50;
    private static final Long DEFAULT_MAX_SOURCE_SIZE_BYTES = -1L;
    private static final TransformerAndSourceType SYSTEM_WIDE_KEY = new TransformerAndSourceType(null, null);
    private final Map<TransformerAndSourceType, Integer> priorityDefaults = new HashMap<TransformerAndSourceType, Integer>();
    private final Map<TransformerAndSourceType, Long> maxSourceSizeBytesDefaults = new HashMap<TransformerAndSourceType, Long>();

    public void add(SupportedDefaults supportedDefault) {
        Integer priority;
        TransformerAndSourceType key = new TransformerAndSourceType(supportedDefault.getTransformerName(), supportedDefault.getSourceMediaType());
        Long maxSourceSizeBytes = supportedDefault.getMaxSourceSizeBytes();
        if (maxSourceSizeBytes != null) {
            this.maxSourceSizeBytesDefaults.put(key, maxSourceSizeBytes);
        }
        if ((priority = supportedDefault.getPriority()) != null) {
            this.priorityDefaults.put(key, priority);
        }
    }

    Defaults() {
        this.clear();
    }

    public boolean valuesUnset(Integer supportedSourceAndTargetPriority, Long supportedSourceAndTargetMaxSourceSizeBytes) {
        return supportedSourceAndTargetPriority == null || supportedSourceAndTargetMaxSourceSizeBytes == null;
    }

    public int getPriority(String transformerName, String sourceMediaType, Integer supportedSourceAndTargetPriority) {
        return this.getDefault(transformerName, sourceMediaType, supportedSourceAndTargetPriority, this.priorityDefaults);
    }

    public long getMaxSourceSizeBytes(String transformerName, String sourceMediaType, Long supportedSourceAndTargetMaxSourceSizeBytes) {
        return this.getDefault(transformerName, sourceMediaType, supportedSourceAndTargetMaxSourceSizeBytes, this.maxSourceSizeBytesDefaults);
    }

    private <T> T getDefault(String transformerName, String sourceMediaType, T supportedSourceAndTargetValue, Map<TransformerAndSourceType, T> map) {
        if (supportedSourceAndTargetValue != null) {
            return supportedSourceAndTargetValue;
        }
        TransformerAndSourceType key = new TransformerAndSourceType(transformerName, sourceMediaType);
        int i = 0;
        T value;
        while ((value = map.get(key)) == null) {
            switch (i) {
                case 0: 
                case 2: {
                    key.setSourceMediaType(null);
                    break;
                }
                case 1: {
                    key.setSourceMediaType(sourceMediaType);
                    key.setTransformerName(null);
                    break;
                }
                default: {
                    throw new IllegalStateException("Should have found an entry with a null, null lookup");
                }
            }
            ++i;
        }
        return value;
    }

    public Set<SupportedDefaults> getSupportedDefaults() {
        return Stream.concat(this.maxSourceSizeBytesDefaults.keySet().stream(), this.priorityDefaults.keySet().stream()).filter(key -> !SYSTEM_WIDE_KEY.equals(key) || !DEFAULT_MAX_SOURCE_SIZE_BYTES.equals(this.maxSourceSizeBytesDefaults.get(key)) || !DEFAULT_PRIORITY.equals(this.priorityDefaults.get(key))).map(key -> {
            Long maxSourceSizeBytes = this.maxSourceSizeBytesDefaults.get(key);
            Integer priority = this.priorityDefaults.get(key);
            return SupportedDefaults.builder().withTransformerName(key.getTransformerName()).withSourceMediaType(key.getSourceMediaType()).withPriority(priority).withMaxSourceSizeBytes(maxSourceSizeBytes).build();
        }).collect(Collectors.toSet());
    }

    public void clear() {
        this.priorityDefaults.clear();
        this.maxSourceSizeBytesDefaults.clear();
        this.priorityDefaults.put(SYSTEM_WIDE_KEY, DEFAULT_PRIORITY);
        this.maxSourceSizeBytesDefaults.put(SYSTEM_WIDE_KEY, DEFAULT_MAX_SOURCE_SIZE_BYTES);
    }
}

