/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.config.reader;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.transform.config.SupportedSourceAndTarget;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.TransformStep;
import org.alfresco.transform.config.Transformer;
import org.alfresco.transform.config.reader.TransformConfigReader;
import org.alfresco.transform.config.reader.TransformConfigReaderFactory;
import org.alfresco.transform.config.reader.TransformConfigReaderJsonTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class TransformConfigReaderYamlTest {
    @Test
    public void testEmptyRoutesFile() throws Exception {
        ClassPathResource resource = new ClassPathResource("config/sample3.yaml");
        TransformConfigReader loader = TransformConfigReaderFactory.create((Resource)resource);
        TransformConfig transformConfig = loader.load();
        List transformers = transformConfig.getTransformers();
        Assertions.assertNotNull((Object)transformers);
        Assertions.assertEquals(Collections.emptyList(), (Object)transformers);
    }

    @Test
    public void testMixedRoutesFile() throws Exception {
        List<Transformer> expected = this.prepareSample4();
        Map<String, Set<TransformOption>> expectedOptions = TransformConfigReaderJsonTest.prepareSample5Options();
        ClassPathResource resource = new ClassPathResource("config/sample4.yaml");
        TransformConfigReader loader = TransformConfigReaderFactory.create((Resource)resource);
        TransformConfig transformConfig = loader.load();
        List transformers = transformConfig.getTransformers();
        Map transformOptions = transformConfig.getTransformOptions();
        Assertions.assertNotNull((Object)transformers);
        Assertions.assertEquals((int)expected.size(), (int)transformers.size());
        Assertions.assertTrue((boolean)expected.containsAll(transformers));
        Assertions.assertEquals(expectedOptions, (Object)transformOptions);
    }

    private List<Transformer> prepareSample4() {
        ArrayList<Transformer> result = new ArrayList<Transformer>();
        result.add(Transformer.builder().withTransformerName("CORE_AIO").withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("image/gif")).withTargetMediaType("image/gif")).build()))).withTransformOptions((Set)ImmutableSet.of((Object)"imageMagickOptions")).build());
        result.add(Transformer.builder().withTransformerName("IMAGEMAGICK").withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("image/gif")).withTargetMediaType("image/gif")).build()))).withTransformOptions((Set)ImmutableSet.of((Object)"imageMagickOptions")).build());
        result.add(Transformer.builder().withTransformerName("CORE_AIO").withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("application/msword")).withTargetMediaType("application/pdf")).withMaxSourceSizeBytes(Long.valueOf(0x1200000L)).build()))).build());
        result.add(Transformer.builder().withTransformerName("PDF_RENDERER").withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("application/vnd.ms-powerpoint")).withTargetMediaType("application/pdf")).withPriority(Integer.valueOf(55)).withMaxSourceSizeBytes(Long.valueOf(0x3000000L)).build()))).build());
        result.add(Transformer.builder().withTransformerName("CORE_AIO").withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/plain")).withTargetMediaType("text/plain")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/mediawiki")).withTargetMediaType("text/plain")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/css")).withTargetMediaType("text/plain")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/csv")).withTargetMediaType("text/plain")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/xml")).withTargetMediaType("text/plain")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/html")).withTargetMediaType("text/plain")).build()), (Object[])new SupportedSourceAndTarget[]{(SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("application/x-javascript")).withTargetMediaType("text/plain")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("application/dita+xml")).withTargetMediaType("text/plain")).build()})).withTransformOptions((Set)ImmutableSet.of((Object)"stringOptions")).build());
        result.add(Transformer.builder().withTransformerName("officeToImageViaPdf").withTransformerPipeline((List)ImmutableList.of((Object)new TransformStep("libreoffice", "application/pdf"), (Object)new TransformStep("pdfToImageViaPng", null))).withTransformOptions((Set)ImmutableSet.of((Object)"pdfRendererOptions", (Object)"imageMagickOptions")).build());
        result.add(Transformer.builder().withTransformerName("textToImageViaPdf").withTransformerPipeline((List)ImmutableList.of((Object)new TransformStep("libreoffice", "application/pdf"), (Object)new TransformStep("pdfToImageViaPng", null))).withTransformOptions((Set)ImmutableSet.of((Object)"pdfRendererOptions", (Object)"imageMagickOptions")).withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/plain")).withTargetMediaType("image/gif")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/plain")).withTargetMediaType("image/jpeg")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/plain")).withTargetMediaType("image/tiff")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/plain")).withTargetMediaType("image/png")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/csv")).withTargetMediaType("image/gif")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/csv")).withTargetMediaType("image/jpeg")).build()), (Object[])new SupportedSourceAndTarget[]{(SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/csv")).withTargetMediaType("image/tiff")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/csv")).withTargetMediaType("image/png")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/xml")).withTargetMediaType("image/gif")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/xml")).withTargetMediaType("image/jpeg")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/xml")).withTargetMediaType("image/tiff")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/xml")).withTargetMediaType("image/png")).build()})).withTransformOptions((Set)ImmutableSet.of((Object)"pdfRendererOptions", (Object)"imageMagickOptions")).build());
        return result;
    }
}

