/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.pdfrenderer;

import java.text.MessageFormat;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.transform.base.clients.FileInfo;
import org.alfresco.transform.base.clients.HttpClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class PdfRendererTransformationIT {
    private static final Logger logger = LoggerFactory.getLogger(PdfRendererTransformationIT.class);
    private static final String ENGINE_URL = "http://localhost:8090";
    private static final Map<String, FileInfo> TEST_FILES = Stream.of(FileInfo.testFile((String)"application/pdf", (String)"pdf", (String)"quick.pdf"), FileInfo.testFile((String)"application/illustrator", (String)"ai", (String)"quickCS3.ai"), FileInfo.testFile((String)"application/illustrator", (String)"ai", (String)"quickCS5.ai")).collect(Collectors.toMap(FileInfo::getPath, Function.identity()));

    public static Stream<String> engineTransformations() {
        return Stream.of("quick.pdf", "quickCS3.ai", "quickCS5.ai");
    }

    @ParameterizedTest
    @MethodSource(value={"engineTransformations"})
    public void testTransformation(String sourceFile) {
        String sourceMimetype = TEST_FILES.get(sourceFile).getMimeType();
        String descriptor = MessageFormat.format("Transform ({0}, {1} -> {2}, {3})", sourceFile, sourceMimetype, "image/png", "png");
        try {
            ResponseEntity response = HttpClient.sendTRequest((String)ENGINE_URL, (String)sourceFile, (String)sourceMimetype, (String)"image/png", (String)"png");
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)response.getStatusCode(), (String)descriptor);
        }
        catch (Exception e) {
            Assertions.fail((String)(descriptor + " exception: " + e.getMessage()));
        }
    }
}

