/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.tika.metadata.extractors;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.transform.base.metadata.AbstractMetadataExtractorEmbedder;
import org.alfresco.transform.tika.metadata.AbstractTikaMetadataExtractorEmbeddor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.dwg.DWGParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DWGMetadataExtractor
extends AbstractTikaMetadataExtractorEmbeddor {
    private static final Logger logger = LoggerFactory.getLogger(DWGMetadataExtractor.class);
    private static final String KEY_KEYWORD = "keyword";
    private static final String KEY_LAST_AUTHOR = "lastAuthor";

    public DWGMetadataExtractor() {
        super(AbstractMetadataExtractorEmbedder.Type.EXTRACTOR, logger);
    }

    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        this.putRawValue(KEY_KEYWORD, (Serializable)((Object)metadata.get(TikaCoreProperties.SUBJECT)), properties);
        this.putRawValue(KEY_LAST_AUTHOR, (Serializable)((Object)metadata.get(TikaCoreProperties.MODIFIED)), properties);
        return properties;
    }

    protected Parser getParser() {
        return new DWGParser();
    }
}

