/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.tika;

import java.util.Collections;
import org.alfresco.transform.base.TransformEngine;
import org.alfresco.transform.base.logging.StandardMessages;
import org.alfresco.transform.base.probes.ProbeTransform;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.reader.TransformConfigResourceReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TikaTransformEngine
implements TransformEngine {
    @Autowired
    private TransformConfigResourceReader transformConfigResourceReader;

    public String getTransformEngineName() {
        return "0010 Tika";
    }

    public String getStartupMessage() {
        return StandardMessages.COMMUNITY_LICENCE + "This transformer uses Tika from Apache. See the license at http://www.apache.org/licenses/LICENSE-2.0. or in /Apache\\ 2.0.txt\nThis transformer uses ExifTool by Phil Harvey. See license at https://exiftool.org/#license. or in /Perl-Artistic-License.txt";
    }

    public TransformConfig getTransformConfig() {
        return this.transformConfigResourceReader.read("classpath:tika_engine_config.json");
    }

    public ProbeTransform getProbeTransform() {
        return new ProbeTransform("probe.pdf", "application/pdf", "text/plain", Collections.emptyMap(), 60L, 16L, 400, 10240L, 1801L, 920L);
    }
}

