/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.tika.metadata.extractors;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.transform.base.metadata.AbstractMetadataExtractorEmbedder;
import org.alfresco.transform.tika.metadata.AbstractTikaMetadataExtractorEmbeddor;
import org.alfresco.transform.tika.transformers.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TikaAutoMetadataExtractor
extends AbstractTikaMetadataExtractorEmbeddor {
    private static final Logger logger = LoggerFactory.getLogger(TikaAutoMetadataExtractor.class);
    private static final String EXIF_IMAGE_HEIGHT_TAG = "Exif Image Height";
    private static final String EXIF_IMAGE_WIDTH_TAG = "Exif Image Width";
    private static final String JPEG_IMAGE_HEIGHT_TAG = "Image Height";
    private static final String JPEG_IMAGE_WIDTH_TAG = "Image Width";
    private static final String COMPRESSION_TAG = "Compression";
    protected final TikaConfig tikaConfig = Tika.readTikaConfig((Logger)logger);

    public TikaAutoMetadataExtractor() {
        super(AbstractMetadataExtractorEmbedder.Type.EXTRACTOR, logger);
    }

    protected Parser getParser() {
        return new AutoDetectParser(this.tikaConfig);
    }

    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        if ("image/jpeg".equals(metadata.get("Content-Type")) && metadata.get(EXIF_IMAGE_WIDTH_TAG) != null && metadata.get(EXIF_IMAGE_HEIGHT_TAG) != null && metadata.get(COMPRESSION_TAG) != null) {
            this.putRawValue(TIFF.IMAGE_LENGTH.getName(), (Serializable)((Object)this.extractSize(metadata.get(EXIF_IMAGE_HEIGHT_TAG))), properties);
            this.putRawValue(TIFF.IMAGE_WIDTH.getName(), (Serializable)((Object)this.extractSize(metadata.get(EXIF_IMAGE_WIDTH_TAG))), properties);
            this.putRawValue(JPEG_IMAGE_HEIGHT_TAG, (Serializable)((Object)metadata.get(EXIF_IMAGE_HEIGHT_TAG)), properties);
            this.putRawValue(JPEG_IMAGE_WIDTH_TAG, (Serializable)((Object)metadata.get(EXIF_IMAGE_WIDTH_TAG)), properties);
        }
        return properties;
    }

    private String extractSize(String sizeText) {
        StringBuilder sizeValue = new StringBuilder();
        for (char c : sizeText.toCharArray()) {
            if (!Character.isDigit(c)) break;
            sizeValue.append(c);
        }
        return sizeValue.toString();
    }
}

