/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.tika.metadata.extractors;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.alfresco.transform.base.metadata.AbstractMetadataExtractorEmbedder;
import org.alfresco.transform.tika.metadata.AbstractTikaMetadataExtractorEmbeddor;
import org.alfresco.transform.tika.transformers.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.mp4.MP4Parser;
import org.gagravarr.tika.FlacParser;
import org.gagravarr.tika.VorbisParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TikaAudioMetadataExtractor
extends AbstractTikaMetadataExtractorEmbeddor {
    private static final Logger logger = LoggerFactory.getLogger(TikaAudioMetadataExtractor.class);
    private static final Parser[] parsers = new Parser[]{new VorbisParser(), new FlacParser(), new MP4Parser()};
    protected final TikaConfig tikaConfig;

    public TikaAudioMetadataExtractor() {
        this(logger);
    }

    public TikaAudioMetadataExtractor(Logger logger) {
        super(AbstractMetadataExtractorEmbedder.Type.EXTRACTOR, logger);
        this.tikaConfig = Tika.readTikaConfig((Logger)logger);
    }

    protected Parser getParser() {
        return new CompositeParser(this.tikaConfig.getMediaTypeRegistry(), parsers);
    }

    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        this.putRawValue("description", (Serializable)((Object)this.generateDescription(metadata)), properties);
        Serializable releaseDate = this.generateReleaseDate(metadata);
        this.putRawValue("created", releaseDate, properties);
        this.putRawValue(XMPDM.RELEASE_DATE.getName(), releaseDate, properties);
        return properties;
    }

    private Serializable generateReleaseDate(Metadata metadata) {
        String date = metadata.get(XMPDM.RELEASE_DATE);
        if (date == null || date.length() == 0) {
            return null;
        }
        if (date.matches("\\d\\d\\d\\d")) {
            Calendar c = Calendar.getInstance();
            c.set(Integer.parseInt(date), 0, 1, 0, 0, 0);
            c.set(14, 0);
            return c.getTime();
        }
        return this.makeDate(date);
    }

    private String generateDescription(Metadata metadata) {
        StringBuilder result = new StringBuilder();
        if (metadata.get(TikaCoreProperties.TITLE) != null) {
            result.append(metadata.get(TikaCoreProperties.TITLE));
            if (metadata.get(XMPDM.ALBUM) != null) {
                result.append(" - ").append(metadata.get(XMPDM.ALBUM));
            }
            if (metadata.get(XMPDM.ARTIST) != null) {
                result.append(" (").append(metadata.get(XMPDM.ARTIST)).append(")");
            }
        }
        return result.toString();
    }
}

